package com.gradle.develocity.agent.maven.api.cache;

import java.time.Duration;

/**
 * Configures the cleanup policy of the local build cache.
 * <p>
 * The specified values will take precedence over the values defined in the {@code develocity.xml}.
 *
 * @since 1.21
 */
public interface CleanupPolicy {

    /**
     * Gets whether the local build cache cleanup is enabled.
     *
     * @return {@code true} if the local build cache cleanup is enabled, {@code false} otherwise
     */
    boolean isEnabled();

    /**
     * Sets whether to enable the local build cache cleanup.
     * <p>
     * Configuration via the {@code develocity.cache.local.cleanup.enabled} system property will always take precedence.
     *
     * @param enabled whether to enable the local build cache cleanup
     */
    void setEnabled(boolean enabled);

    /**
     * Gets the local build cache retention period.
     *
     * @return the local build cache cleanup retention period
     */
    Duration getRetentionPeriod();

    /**
     * Sets the local build cache cleanup retention period.
     * <p>
     * Configuration via the {@code develocity.cache.local.cleanup.retention} system property will always take precedence.
     *
     * @param retentionPeriod the local build cache cleanup retention period
     */
    void setRetentionPeriod(Duration retentionPeriod);

    /**
     * Gets the local build cache cleanup interval.
     *
     * @return the local build cache cleanup interval
     */
    Duration getCleanupInterval();

    /**
     * Sets the local build cache cleanup interval.
     * <p>
     * Configuration via the {@code develocity.cache.local.cleanup.interval} system property will always take precedence.
     *
     * @param cleanupInterval the local build cache cleanup interval
     */
    void setCleanupInterval(Duration cleanupInterval);

}
