package com.gradle.develocity.agent.maven.api.cache;

import java.io.File;

/**
 * Configures the local build cache.
 * <p>
 * The specified values will take precedence over the values defined in the {@code develocity.xml}.
 *
 * @since 1.21
 */
public interface LocalBuildCache {

    /**
     * Whether the local build cache is enabled.
     *
     * @return {@code true} if the local build cache is enabled, {@code false} otherwise
     */
    boolean isEnabled();

    /**
     * Sets whether to enable the local build cache.
     * <p>
     * Configuration via the {@code develocity.cache.local.enabled} system property will always take precedence.
     *
     * @param enabled whether to enable the local build cache
     */
    void setEnabled(boolean enabled);

    /**
     * Whether storing build cache entries is enabled.
     *
     * @return {@code true} if storing build cache entries is enabled, {@code false} otherwise
     */
    boolean isStoreEnabled();

    /**
     * Sets whether to store build cache entries.
     * <p>
     * Configuration via the {@code develocity.cache.local.storeEnabled} system property will always take precedence.
     *
     * @param storeEnabled whether to enable storing build cache entries
     */
    void setStoreEnabled(boolean storeEnabled);

    /**
     * Gets the local build cache directory.
     *
     * @return the local build cache directory
     */
    File getDirectory();

    /**
     * Sets the local build cache directory.
     * <p>
     * Configuration via the {@code develocity.cache.local.directory} system property will always take precedence.
     *
     * @param directory the local build cache directory
     */
    void setDirectory(File directory);

    /**
     * Gets the cleanup policy configuration.
     *
     * @return the cleanup policy configuration
     */
    CleanupPolicy getCleanupPolicy();

}
