package com.gradle.maven.extension.api;

import javax.annotation.Nullable;
import java.net.URI;
import java.nio.file.Path;

/**
 * Allows to interact with the Develocity Maven extension.
 *
 * @since 1.10.1
 * @deprecated since 1.21, replaced by {@link com.gradle.develocity.agent.maven.api.DevelocityApi}
 */
@Deprecated
public interface GradleEnterpriseApi {

    /**
     * Whether the Develocity Maven extension is enabled.
     *
     * @return {@code true} if the Develocity Maven extension is enabled, {@code false} otherwise
     * @since 1.10.3
     */
    boolean isEnabled();

    /**
     * Sets whether to enable the Develocity Maven extension.
     * <p>
     * Configuration via the {@code gradle.enterprise.enabled} system property will always take precedence.
     *
     * @param enabled whether to enable the Develocity Maven extension
     * @since 1.10.3
     */
    void setEnabled(boolean enabled);

    /**
     * Sets the project identifier. The value must not be empty or exceed 256 characters.
     *
     * @param projectId the project identifier
     * @since 1.19
     */
    void setProjectId(@Nullable String projectId);

    /**
     * Returns the project identifier.
     *
     * @return null when no project identifier is configured
     * @since 1.19
     */
    @Nullable
    String getProjectId();

    /**
     * Returns the Develocity Maven extension storage directory.
     *
     * @return the Develocity Maven extension storage directory.
     * @see <a href="https://gradle.com/help/maven-extension-storage-directory">Develocity Maven extension documentation</a>.
     * @since 1.10.1
     */
    Path getStorageDirectory();

    /**
     * Sets the Develocity Maven extension storage directory to the specified path.
     * <p>
     * Configuration via the {@code develocity.storage.directory} system property will always take precedence.
     *
     * @param path The new storage directory
     * @see <a href="https://gradle.com/help/maven-extension-storage-directory">Develocity Maven extension documentation</a>.
     * @since 1.10.1
     */
    void setStorageDirectory(Path path);

    /**
     * Sets the URL of the Develocity server.
     * <p>
     * Configuration via the {@code gradle.enterprise.url} system property will always take precedence.
     *
     * @param url the server URL
     * @since 1.10.1
     */
    default void setServer(@Nullable String url) {
        setServer(url == null ? null : URI.create(url));
    }

    /**
     * Sets the URL of the Develocity server.
     * <p>
     * Configuration via the {@code gradle.enterprise.url} system property will always take precedence.
     *
     * @param url the server URL
     * @since 1.10.3
     */
    void setServer(@Nullable URI url);

    /**
     * Returns the URL of the Develocity server.
     *
     * @return null when no Develocity server is configured
     * @since 1.10.1
     */
    @Nullable
    String getServer();

    /**
     * Specifies whether it is acceptable to communicate with a Develocity server using an untrusted SSL certificate.
     * <p>
     * The default (public) Develocity server uses SSL certificates that are trusted by default by standard modern Java environments.
     * If you are using a different Develocity server, it may use an untrusted certificate.
     * This may be due to the use of an internally provisioned or self-signed certificate.
     * <p>
     * In such a scenario, you can either configure the build JVM environment to trust the certificate,
     * or call this method with {@code true} to disable verification of the server's identity.
     * Alternatively, you may disable SSL completely for Develocity installation but this is not recommended.
     * <p>
     * Allowing communication with untrusted servers keeps data encrypted during transmission,
     * but makes it easy for a man-in-the-middle to impersonate the intended server and capture data.
     * <p>
     * This value has no effect if a server is specified using the HTTP protocol (i.e. has SSL disabled).
     * <p>
     * Configuration via the {@code develocity.allowUntrustedServer} system property will always take precedence.
     *
     * @param allow whether to allow communication with a HTTPS server with an untrusted certificate
     * @since 1.10.1
     */
    void setAllowUntrustedServer(boolean allow);

    /**
     * Whether it is acceptable to communicate with a Develocity server with an untrusted SSL certificate.
     *
     * @return <code>true</code> if it is acceptable to communicate with a build scan server with an untrusted SSL certificate
     * @since 1.10.1
     **/
    boolean getAllowUntrustedServer();

    /**
     * Sets the access key for authenticating with the Develocity server.
     * <p>
     * An access key configured this way will take precedence over the {@code GRADLE_ENTERPRISE_ACCESS_KEY}
     * environment variable or access key file entry associated with the server.
     *
     * @param accessKey a Develocity server access key without any hostname prefix
     * @since 1.11
     */
    void setAccessKey(String accessKey);

    /**
     * Returns the access key for authenticating with the Develocity server.
     * <p>
     * Only the value of the explicitly configured access key (via {@link #setAccessKey(String)} or {@code gradle-enterprise.xml}) is returned but
     * not the value of an access key configured via the {@code GRADLE_ENTERPRISE_ACCESS_KEY} environment variable or access key file entry.
     *
     * @return the configured Develocity server access key, if available; otherwise, {@code null}
     * @since 1.11
     */
    @Nullable
    String getAccessKey();

    /**
     * The build scan API.
     *
     * @return the build scan API
     * @since 1.10.1
     */
    com.gradle.maven.extension.api.scan.BuildScanApi getBuildScan();

    /**
     * The build cache API.
     *
     * @return the build cache API
     * @since 1.10.1
     */
    com.gradle.maven.extension.api.cache.BuildCacheApi getBuildCache();

}
