package com.gradle.maven.extension.api.cache;

/**
 * Configures the remote build cache.
 * <p>
 * The specified values will take precedence over the values defined in the {@code gradle-enterprise.xml}.
 *
 * @since 1.6.5
 * @deprecated since 1.21, replaced by {@link com.gradle.develocity.agent.maven.api.cache.RemoteBuildCache}
 */
@Deprecated
public interface RemoteBuildCache {

    /**
     * Whether the remote build cache is enabled.
     *
     * @return {@code true} if the remote build cache is enabled, {@code false} otherwise
     * @since 1.6.5
     */
    boolean isEnabled();

    /**
     * Sets whether to enable the remote build cache.
     * <p>
     * Configuration via the {@code gradle.cache.remote.enabled} system property will always take precedence.
     *
     * @param enabled whether to enable the remote build cache
     * @since 1.6.5
     */
    void setEnabled(boolean enabled);

    /**
     * Whether storing build cache entries is enabled.
     *
     * @return {@code true} if storing build cache entries is enabled, {@code false} otherwise
     * @since 1.6.5
     */
    boolean isStoreEnabled();

    /**
     * Sets whether to store build cache entries.
     * <p>
     * Configuration via the {@code gradle.cache.remote.storeEnabled} system property will always take precedence.
     *
     * @param storeEnabled whether to enable storing build cache entries
     * @since 1.6.5
     */
    void setStoreEnabled(boolean storeEnabled);

    /**
     * Gets the server configuration.
     *
     * @return the server configuration
     * @since 1.6.5
     */
    Server getServer();

}
