package com.gradle.maven.extension.api.scan;

import java.net.InetAddress;
import java.util.List;
import java.util.function.Function;

/**
 * Allows registering functions for obfuscating certain identifying information within build scans.
 *
 * @see BuildScanApi#getObfuscation()
 * @deprecated since 1.21, replaced by {@link com.gradle.develocity.agent.maven.api.scan.BuildScanDataObfuscation}
 */
@Deprecated
public interface BuildScanDataObfuscation {

    /**
     * Registers a function to transform the <em>username</em> captured.
     * <p>
     * The function receives the username that would be captured,
     * and should return the username that will be captured.
     * <p>
     * The received username may be <code>null</code>,
     * and the function may return a <code>null</code> value.
     *
     * @param obfuscator the function to obfuscate the username
     * @since 1.3.1
     */
    void username(Function<? super String, ? extends String> obfuscator);

    /**
     * Registers a function to transform the <em>local hostname</em> and <em>public hostname</em> captured.
     * <p>
     * The function receives the hostname that would be captured,
     * and should return the hostname that will be captured.
     * <p>
     * The received hostname may be <code>null</code>,
     * and the function may return a <code>null</code> value.
     *
     * @param obfuscator the function to obfuscate the hostname
     * @since 1.3.1
     */
    void hostname(Function<? super String, ? extends String> obfuscator);

    /**
     * Registers a function used to transform the <em>IP addresses</em> captured.
     * <p>
     * The function receives a list of {@link InetAddress} that would be captured,
     * and should return the list of {@link String} that will be captured.
     * <p>
     * The received list may be <code>null</code> or empty,
     * and the function may return a <code>null</code> or empty list,
     * but may not return a list with a <code>null</code> element.
     *
     * @param obfuscator the function to obfuscate the IP addresses
     * @since 1.3.1
     */
    void ipAddresses(Function<? super List<InetAddress>, ? extends List<String>> obfuscator);

}
