/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ModelNode;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.TokenModel;
import java.util.BitSet;
import java.util.List;

public class ConcatModel
extends ModelNode {
    ModelNode mLeftModel;
    ModelNode mRightModel;
    final boolean mNullable;
    BitSet mFirstPos;
    BitSet mLastPos;

    public ConcatModel(ModelNode modelNode, ModelNode modelNode2) {
        this.mLeftModel = modelNode;
        this.mRightModel = modelNode2;
        this.mNullable = this.mLeftModel.isNullable() && this.mRightModel.isNullable();
    }

    @Override
    public ModelNode cloneModel() {
        return new ConcatModel(this.mLeftModel.cloneModel(), this.mRightModel.cloneModel());
    }

    @Override
    public boolean isNullable() {
        return this.mNullable;
    }

    @Override
    public void indexTokens(List<TokenModel> list) {
        this.mLeftModel.indexTokens(list);
        this.mRightModel.indexTokens(list);
    }

    @Override
    public void addFirstPos(BitSet bitSet) {
        if (this.mFirstPos == null) {
            this.mFirstPos = new BitSet();
            this.mLeftModel.addFirstPos(this.mFirstPos);
            if (this.mLeftModel.isNullable()) {
                this.mRightModel.addFirstPos(this.mFirstPos);
            }
        }
        bitSet.or(this.mFirstPos);
    }

    @Override
    public void addLastPos(BitSet bitSet) {
        if (this.mLastPos == null) {
            this.mLastPos = new BitSet();
            this.mRightModel.addLastPos(this.mLastPos);
            if (this.mRightModel.isNullable()) {
                this.mLeftModel.addLastPos(this.mLastPos);
            }
        }
        bitSet.or(this.mLastPos);
    }

    @Override
    public void calcFollowPos(BitSet[] bitSetArray) {
        this.mLeftModel.calcFollowPos(bitSetArray);
        this.mRightModel.calcFollowPos(bitSetArray);
        BitSet bitSet = new BitSet();
        this.mRightModel.addFirstPos(bitSet);
        BitSet bitSet2 = new BitSet();
        this.mLeftModel.addLastPos(bitSet2);
        int n2 = 0;
        while ((n2 = bitSet2.nextSetBit(n2 + 1)) >= 0) {
            bitSetArray[n2].or(bitSet);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(this.mLeftModel.toString());
        stringBuilder.append(", ");
        stringBuilder.append(this.mRightModel.toString());
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

