/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxEOFException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.InputBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.MergedReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputLocation;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationProblem;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public final class ReaderBootstrapper
extends InputBootstrapper {
    static final char CHAR_BOM_MARKER = '\ufeff';
    final Reader mIn;
    final String mInputEncoding;
    private char[] mCharBuffer;
    private int mInputPtr;
    private int mInputEnd;

    private ReaderBootstrapper(String string, SystemId systemId, Reader reader, String string2) {
        super(string, systemId);
        this.mIn = reader;
        if (string2 == null && reader instanceof InputStreamReader) {
            string2 = ((InputStreamReader)reader).getEncoding();
        }
        this.mInputEncoding = string2;
    }

    public static ReaderBootstrapper getInstance(String string, SystemId systemId, Reader reader, String string2) {
        return new ReaderBootstrapper(string, systemId, reader, string2);
    }

    @Override
    public Reader bootstrapInput(ReaderConfig readerConfig, boolean bl2, int n2) throws IOException, XMLStreamException {
        this.mCharBuffer = readerConfig == null ? new char[128] : readerConfig.allocSmallCBuffer(128);
        this.initialLoad(7);
        if (this.mInputEnd >= 7) {
            char c2 = this.mCharBuffer[this.mInputPtr];
            if (c2 == '\ufeff') {
                c2 = this.mCharBuffer[++this.mInputPtr];
            }
            if (c2 == '<') {
                if (this.mCharBuffer[this.mInputPtr + 1] == '?' && this.mCharBuffer[this.mInputPtr + 2] == 'x' && this.mCharBuffer[this.mInputPtr + 3] == 'm' && this.mCharBuffer[this.mInputPtr + 4] == 'l' && this.mCharBuffer[this.mInputPtr + 5] <= ' ') {
                    this.mInputPtr += 6;
                    this.readXmlDecl(bl2, n2);
                    if (this.mFoundEncoding != null && this.mInputEncoding != null) {
                        this.verifyXmlEncoding(readerConfig);
                    }
                }
            } else if (c2 == '\u00ef') {
                throw new WstxIOException("Unexpected first character (char code 0xEF), not valid in xml document: could be mangled UTF-8 BOM marker. Make sure that the Reader uses correct encoding or pass an InputStream instead");
            }
        }
        if (this.mInputPtr < this.mInputEnd) {
            return new MergedReader(readerConfig, this.mIn, this.mCharBuffer, this.mInputPtr, this.mInputEnd);
        }
        return this.mIn;
    }

    @Override
    public String getInputEncoding() {
        return this.mInputEncoding;
    }

    @Override
    public int getInputTotal() {
        return this.mInputProcessed + this.mInputPtr;
    }

    @Override
    public int getInputColumn() {
        return this.mInputPtr - this.mInputRowStart;
    }

    protected void verifyXmlEncoding(ReaderConfig readerConfig) throws XMLStreamException {
        String string = this.mInputEncoding;
        if (StringUtil.equalEncodings(string, this.mFoundEncoding)) {
            return;
        }
        XMLReporter xMLReporter = readerConfig.getXMLReporter();
        if (xMLReporter != null) {
            Location location = this.getLocation();
            String string2 = MessageFormat.format(ErrorConsts.W_MIXED_ENCODINGS, this.mFoundEncoding, string);
            String string3 = ErrorConsts.WT_XML_DECL;
            XMLValidationProblem xMLValidationProblem = new XMLValidationProblem(location, string2, 1, string3);
            xMLReporter.report(string2, string3, xMLValidationProblem, location);
        }
    }

    protected boolean initialLoad(int n2) throws IOException {
        this.mInputPtr = 0;
        this.mInputEnd = 0;
        while (this.mInputEnd < n2) {
            int n3 = this.mIn.read(this.mCharBuffer, this.mInputEnd, this.mCharBuffer.length - this.mInputEnd);
            if (n3 < 1) {
                return false;
            }
            this.mInputEnd += n3;
        }
        return true;
    }

    protected void loadMore() throws IOException, WstxException {
        this.mInputProcessed += this.mInputEnd;
        this.mInputRowStart -= this.mInputEnd;
        this.mInputPtr = 0;
        this.mInputEnd = this.mIn.read(this.mCharBuffer, 0, this.mCharBuffer.length);
        if (this.mInputEnd < 1) {
            throw new WstxEOFException(" in xml declaration", this.getLocation());
        }
    }

    @Override
    protected void pushback() {
        --this.mInputPtr;
    }

    @Override
    protected int getNext() throws IOException, WstxException {
        return this.mInputPtr < this.mInputEnd ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
    }

    @Override
    protected int getNextAfterWs(boolean bl2) throws IOException, WstxException {
        int n2 = 0;
        while (true) {
            char c2;
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
            if (c2 > ' ') {
                if (bl2 && n2 == 0) {
                    this.reportUnexpectedChar(c2, "; expected a white space");
                }
                return c2;
            }
            if (c2 == '\r' || c2 == '\n') {
                this.skipCRLF(c2);
            } else if (c2 == '\u0000') {
                this.reportNull();
            }
            ++n2;
        }
    }

    @Override
    protected int checkKeyword(String string) throws IOException, WstxException {
        int n2 = string.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            char c2;
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
            if (c2 != string.charAt(i2)) {
                return c2;
            }
            if (c2 != '\u0000') continue;
            this.reportNull();
        }
        return 0;
    }

    @Override
    protected int readQuotedValue(char[] cArray, int n2) throws IOException, WstxException {
        int n3 = 0;
        int n4 = cArray.length;
        while (true) {
            char c2;
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
            if (c2 == '\r' || c2 == '\n') {
                this.skipCRLF(c2);
            } else if (c2 == '\u0000') {
                this.reportNull();
            }
            if (c2 == n2) {
                return n3 < n4 ? n3 : -1;
            }
            if (n3 >= n4) continue;
            cArray[n3++] = c2;
        }
    }

    @Override
    protected Location getLocation() {
        return new WstxInputLocation(null, this.mPublicId, this.mSystemId, (long)(this.mInputProcessed + this.mInputPtr - 1), this.mInputRow, this.mInputPtr - this.mInputRowStart);
    }

    protected char nextChar() throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputEnd) {
            this.loadMore();
        }
        return this.mCharBuffer[this.mInputPtr++];
    }

    protected void skipCRLF(char c2) throws IOException, WstxException {
        if (c2 == '\r') {
            char c3;
            char c4 = c3 = this.mInputPtr < this.mInputEnd ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
            if (c3 != '\n') {
                --this.mInputPtr;
            }
        }
        ++this.mInputRow;
        this.mInputRowStart = this.mInputPtr;
    }
}

