/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.driver.textui;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.driver.textui.Driver;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.ValidationUnrecoverableException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReportErrorHandler
implements ErrorHandler {
    private int counter = 0;
    public boolean hadError = false;
    public static final String MSG_TOO_MANY_ERRORS = "ReportErrorHandler.TooManyErrors";
    public static final String MSG_ERROR = "ReportErrorHandler.Error";
    public static final String MSG_WARNING = "ReportErrorHandler.Warning";
    public static final String MSG_FATAL = "ReportErrorHandler.Fatal";

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.hadError = true;
        this.countCheck(sAXParseException);
        ReportErrorHandler.printSAXParseException(sAXParseException, MSG_ERROR);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.hadError = true;
        ReportErrorHandler.printSAXParseException(sAXParseException, MSG_FATAL);
        throw new ValidationUnrecoverableException(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        ReportErrorHandler.printSAXParseException(sAXParseException, MSG_WARNING);
    }

    protected static void printSAXParseException(SAXParseException sAXParseException, String string) {
        System.out.println(Driver.localize((String)string, (Object[])new Object[]{new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getSystemId(), sAXParseException.getLocalizedMessage()}));
    }

    private void countCheck(SAXParseException sAXParseException) throws ValidationUnrecoverableException {
        if (this.counter++ < 20) {
            return;
        }
        System.out.println(Driver.localize((String)MSG_TOO_MANY_ERRORS));
        throw new ValidationUnrecoverableException(sAXParseException);
    }
}

