/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    public static Class<?>[] types() {
        return new Class[]{File.class, URL.class, URI.class, Class.class, JavaType.class, Currency.class, Pattern.class, Locale.class, Charset.class, TimeZone.class, InetAddress.class, InetSocketAddress.class, StringBuilder.class, StringBuffer.class};
    }

    protected FromStringDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public static FromStringDeserializer<?> findDeserializer(Class<?> clazz) {
        int n2 = 0;
        if (clazz == File.class) {
            n2 = 1;
        } else if (clazz == URL.class) {
            n2 = 2;
        } else if (clazz == URI.class) {
            n2 = 3;
        } else if (clazz == Class.class) {
            n2 = 4;
        } else if (clazz == JavaType.class) {
            n2 = 5;
        } else if (clazz == Currency.class) {
            n2 = 6;
        } else if (clazz == Pattern.class) {
            n2 = 7;
        } else if (clazz == Locale.class) {
            n2 = 8;
        } else if (clazz == Charset.class) {
            n2 = 9;
        } else if (clazz == TimeZone.class) {
            n2 = 10;
        } else if (clazz == InetAddress.class) {
            n2 = 11;
        } else if (clazz == InetSocketAddress.class) {
            n2 = 12;
        } else {
            if (clazz == StringBuilder.class) {
                return new StringBuilderDeserializer();
            }
            if (clazz == StringBuffer.class) {
                return new StringBufferDeserializer();
            }
            return null;
        }
        return new Std(clazz, n2);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        String string = jsonParser.getValueAsString();
        if (string == null) {
            object = jsonParser.currentToken();
            if (object != JsonToken.START_OBJECT) {
                return (T)this._deserializeFromOther(jsonParser, deserializationContext, (JsonToken)((Object)object));
            }
            string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
        }
        if (string.isEmpty()) {
            return (T)this._deserializeFromEmptyString(deserializationContext);
        }
        if (this._shouldTrim()) {
            object = string;
            if ((string = string.trim()) != object && string.isEmpty()) {
                return (T)this._deserializeFromEmptyString(deserializationContext);
            }
        }
        object = null;
        try {
            return this._deserialize(string, deserializationContext);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            object = exception;
            String string2 = "not a valid textual representation";
            String string3 = ((Throwable)object).getMessage();
            if (string3 != null) {
                string2 = string2 + ", problem: " + string3;
            }
            throw deserializationContext.weirdStringException(string, this._valueClass, string2).withCause((Throwable)object);
        }
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2) throws IOException;

    protected boolean _shouldTrim() {
        return true;
    }

    protected Object _deserializeFromOther(JsonParser jsonParser, DeserializationContext deserializationContext, JsonToken jsonToken) throws IOException {
        if (jsonToken == JsonToken.START_ARRAY) {
            return this._deserializeFromArray(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected T _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException {
        deserializationContext.reportInputMismatch(this, "Don't know how to convert embedded Object of type %s into %s", object.getClass().getName(), this._valueClass.getName());
        return null;
    }

    protected Object _deserializeFromEmptyString(DeserializationContext deserializationContext) throws IOException {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.EmptyString);
        if (coercionAction == CoercionAction.Fail) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", this._coercedTypeDesc());
        }
        if (coercionAction == CoercionAction.AsNull) {
            return this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return this.getEmptyValue(deserializationContext);
        }
        return this._deserializeFromEmptyStringDefault(deserializationContext);
    }

    protected Object _deserializeFromEmptyStringDefault(DeserializationContext deserializationContext) throws IOException {
        return this.getNullValue(deserializationContext);
    }

    static class StringBufferDeserializer
    extends FromStringDeserializer<Object> {
        public StringBufferDeserializer() {
            super(StringBuffer.class);
        }

        @Override
        public LogicalType logicalType() {
            return LogicalType.Textual;
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return new StringBuffer();
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string = jsonParser.getValueAsString();
            if (string != null) {
                return this._deserialize(string, deserializationContext);
            }
            return super.deserialize(jsonParser, deserializationContext);
        }

        @Override
        protected Object _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return new StringBuffer(string);
        }
    }

    static class StringBuilderDeserializer
    extends FromStringDeserializer<Object> {
        public StringBuilderDeserializer() {
            super(StringBuilder.class);
        }

        @Override
        public LogicalType logicalType() {
            return LogicalType.Textual;
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
            return new StringBuilder();
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string = jsonParser.getValueAsString();
            if (string != null) {
                return this._deserialize(string, deserializationContext);
            }
            return super.deserialize(jsonParser, deserializationContext);
        }

        @Override
        protected Object _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return new StringBuilder(string);
        }
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        protected final int _kind;

        protected Std(Class<?> clazz, int n2) {
            super(clazz);
            this._kind = n2;
        }

        @Override
        protected Object _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            switch (this._kind) {
                case 1: {
                    return new File(string);
                }
                case 2: {
                    return new URL(string);
                }
                case 3: {
                    return URI.create(string);
                }
                case 4: {
                    try {
                        return deserializationContext.findClass(string);
                    }
                    catch (Exception exception) {
                        return deserializationContext.handleInstantiationProblem(this._valueClass, string, ClassUtil.getRootCause(exception));
                    }
                }
                case 5: {
                    return deserializationContext.getTypeFactory().constructFromCanonical(string);
                }
                case 6: {
                    return Currency.getInstance(string);
                }
                case 7: {
                    return Pattern.compile(string);
                }
                case 8: {
                    return this._deserializeLocale(string, deserializationContext);
                }
                case 9: {
                    return Charset.forName(string);
                }
                case 10: {
                    return TimeZone.getTimeZone(string);
                }
                case 11: {
                    return InetAddress.getByName(string);
                }
                case 12: {
                    if (string.startsWith("[")) {
                        int n2 = string.lastIndexOf(93);
                        if (n2 == -1) {
                            throw new InvalidFormatException(deserializationContext.getParser(), "Bracketed IPv6 address must contain closing bracket", string, InetSocketAddress.class);
                        }
                        int n3 = string.indexOf(58, n2);
                        int n4 = n3 > -1 ? Integer.parseInt(string.substring(n3 + 1)) : 0;
                        return new InetSocketAddress(string.substring(0, n2 + 1), n4);
                    }
                    int n5 = string.indexOf(58);
                    if (n5 >= 0 && string.indexOf(58, n5 + 1) < 0) {
                        int n6 = Integer.parseInt(string.substring(n5 + 1));
                        return new InetSocketAddress(string.substring(0, n5), n6);
                    }
                    return new InetSocketAddress(string, 0);
                }
            }
            VersionUtil.throwInternal();
            return null;
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
            switch (this._kind) {
                case 3: {
                    return URI.create("");
                }
                case 8: {
                    return Locale.ROOT;
                }
            }
            return super.getEmptyValue(deserializationContext);
        }

        @Override
        protected Object _deserializeFromEmptyStringDefault(DeserializationContext deserializationContext) throws IOException {
            return this.getEmptyValue(deserializationContext);
        }

        @Override
        protected boolean _shouldTrim() {
            return this._kind != 7;
        }

        protected int _firstHyphenOrUnderscore(String string) {
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 != '_' && c2 != '-') continue;
                return i2;
            }
            return -1;
        }

        private Locale _deserializeLocale(String string, DeserializationContext deserializationContext) throws IOException {
            int n2 = this._firstHyphenOrUnderscore(string);
            if (n2 < 0) {
                return new Locale(string);
            }
            String string2 = string.substring(0, n2);
            if ((n2 = this._firstHyphenOrUnderscore(string = string.substring(n2 + 1))) < 0) {
                return new Locale(string2, string);
            }
            String string3 = string.substring(0, n2);
            int n3 = string.indexOf("_#");
            if (n3 < 0) {
                return new Locale(string2, string3, string.substring(n2 + 1));
            }
            return this._deSerializeBCP47Locale(string, n2, string2, string3, n3);
        }

        private Locale _deSerializeBCP47Locale(String string, int n2, String string2, String string3, int n3) {
            String string4 = "";
            try {
                int n4;
                if (n3 > 0 && n3 > n2) {
                    string4 = string.substring(n2 + 1, n3);
                }
                if ((n4 = (string = string.substring(n3 + 2)).indexOf(95)) < 0) {
                    int n5 = string.indexOf(45);
                    if (n5 < 0) {
                        return new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setScript(string).build();
                    }
                    return new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setExtension(string.charAt(0), string.substring(n5 + 1)).build();
                }
                int n6 = string.length();
                Locale.Builder builder = new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setScript(string.substring(0, n4));
                if (n4 + 1 < n6) {
                    builder = builder.setExtension(string.charAt(n4 + 1), string.substring(Math.min(n6, n4 + 3)));
                }
                return builder.build();
            }
            catch (IllformedLocaleException illformedLocaleException) {
                return new Locale(string2, string3, string4);
            }
        }
    }
}

