/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Function;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Objects;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Predicate;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIndexedListIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.NullnessCasts;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.PeekingIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.TransformedIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableListIterator;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Iterators {
    static <T> UnmodifiableIterator<T> emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static <T> UnmodifiableListIterator<T> emptyListIterator() {
        return ArrayItr.EMPTY;
    }

    static <T> Iterator<T> emptyModifiableIterator() {
        return EmptyModifiableIterator.INSTANCE;
    }

    public static <T> UnmodifiableIterator<T> unmodifiableIterator(final Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(iterator);
        if (iterator instanceof UnmodifiableIterator) {
            UnmodifiableIterator unmodifiableIterator = (UnmodifiableIterator)iterator;
            return unmodifiableIterator;
        }
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static boolean contains(Iterator<?> iterator, Object object) {
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removeAll(Iterator<?> iterator, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl2 = false;
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object obj2 = iterator.next();
            if (Objects.equal(obj2, obj = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean bl2 = true;
        while (iterator.hasNext()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            bl2 = false;
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.append(']').toString();
    }

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        T t2 = iterator.next();
        if (!iterator.hasNext()) {
            return t2;
        }
        StringBuilder stringBuilder = new StringBuilder().append("expected one element but was: <").append(t2);
        for (int i2 = 0; i2 < 4 && iterator.hasNext(); ++i2) {
            stringBuilder.append(", ").append(iterator.next());
        }
        if (iterator.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator);
        boolean bl2 = false;
        while (iterator.hasNext()) {
            bl2 |= collection.add(iterator.next());
        }
        return bl2;
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> iterator) {
        return new ConcatenatedIterator(iterator);
    }

    public static <T> UnmodifiableIterator<T> filter(final Iterator<T> iterator, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (!predicate.apply(e2)) continue;
                    return e2;
                }
                return this.endOfData();
            }
        };
    }

    public static <F, T> Iterator<T> transform(Iterator<F> iterator, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        return new TransformedIterator<F, T>(iterator){

            @Override
            T transform(F f2) {
                return function.apply(f2);
            }
        };
    }

    public static <T> T getNext(Iterator<? extends T> iterator, T t2) {
        return iterator.hasNext() ? iterator.next() : t2;
    }

    static <T> T pollNext(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            T t2 = iterator.next();
            iterator.remove();
            return t2;
        }
        return null;
    }

    static void clear(Iterator<?> iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @SafeVarargs
    public static <T> UnmodifiableIterator<T> forArray(T ... TArray) {
        return Iterators.forArrayWithPosition(TArray, 0);
    }

    static <T> UnmodifiableListIterator<T> forArrayWithPosition(T[] TArray, int n2) {
        if (TArray.length == 0) {
            Preconditions.checkPositionIndex(n2, TArray.length);
            return Iterators.emptyListIterator();
        }
        return new ArrayItr<T>(TArray, n2);
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(T t2) {
        return new SingletonIterator<T>(t2);
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator) {
        if (iterator instanceof PeekingImpl) {
            PeekingImpl peekingImpl = (PeekingImpl)iterator;
            return peekingImpl;
        }
        return new PeekingImpl<T>(iterator);
    }

    private static class ConcatenatedIterator<T>
    implements Iterator<T> {
        private Iterator<? extends T> toRemove;
        private Iterator<? extends T> iterator = Iterators.emptyIterator();
        private Iterator<? extends Iterator<? extends T>> topMetaIterator;
        private Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;

        ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> iterator) {
            this.topMetaIterator = Preconditions.checkNotNull(iterator);
        }

        private Iterator<? extends Iterator<? extends T>> getTopMetaIterator() {
            while (this.topMetaIterator == null || !this.topMetaIterator.hasNext()) {
                if (this.metaIterators != null && !this.metaIterators.isEmpty()) {
                    this.topMetaIterator = this.metaIterators.removeFirst();
                    continue;
                }
                return null;
            }
            return this.topMetaIterator;
        }

        @Override
        public boolean hasNext() {
            while (!Preconditions.checkNotNull(this.iterator).hasNext()) {
                this.topMetaIterator = this.getTopMetaIterator();
                if (this.topMetaIterator == null) {
                    return false;
                }
                this.iterator = this.topMetaIterator.next();
                if (!(this.iterator instanceof ConcatenatedIterator)) continue;
                ConcatenatedIterator concatenatedIterator = (ConcatenatedIterator)this.iterator;
                this.iterator = concatenatedIterator.iterator;
                if (this.metaIterators == null) {
                    this.metaIterators = new ArrayDeque<Iterator<? extends Iterator<? extends T>>>();
                }
                this.metaIterators.addFirst(this.topMetaIterator);
                if (concatenatedIterator.metaIterators != null) {
                    while (!concatenatedIterator.metaIterators.isEmpty()) {
                        this.metaIterators.addFirst(concatenatedIterator.metaIterators.removeLast());
                    }
                }
                this.topMetaIterator = concatenatedIterator.topMetaIterator;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.toRemove = this.iterator;
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.toRemove == null) {
                throw new IllegalStateException("no calls to next() since the last call to remove()");
            }
            this.toRemove.remove();
            this.toRemove = null;
        }
    }

    private static class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        private E peekedElement;

        public PeekingImpl(Iterator<? extends E> iterator) {
            this.iterator = Preconditions.checkNotNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E e2 = NullnessCasts.uncheckedCastNullableTToT(this.peekedElement);
            this.hasPeeked = false;
            this.peekedElement = null;
            return e2;
        }

        @Override
        public void remove() {
            Preconditions.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.peekedElement);
        }
    }

    private static final class SingletonIterator<T>
    extends UnmodifiableIterator<T> {
        private static final Object SENTINEL = new Object();
        private Object valueOrSentinel;

        SingletonIterator(T t2) {
            this.valueOrSentinel = t2;
        }

        @Override
        public boolean hasNext() {
            return this.valueOrSentinel != SENTINEL;
        }

        @Override
        public T next() {
            if (this.valueOrSentinel == SENTINEL) {
                throw new NoSuchElementException();
            }
            Object object = this.valueOrSentinel;
            this.valueOrSentinel = SENTINEL;
            return (T)object;
        }
    }

    private static final class ArrayItr<T>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<Object> EMPTY = new ArrayItr<Object>(new Object[0], 0);
        private final T[] array;

        ArrayItr(T[] TArray, int n2) {
            super(TArray.length, n2);
            this.array = TArray;
        }

        @Override
        protected T get(int n2) {
            return this.array[n2];
        }
    }

    private static enum EmptyModifiableIterator implements Iterator<Object>
    {
        INSTANCE;


        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(false);
        }
    }
}

