/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.AbstractFuture;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public final class VoidChannelPromise
extends AbstractFuture<Void>
implements ChannelPromise {
    private final Channel channel;
    private final ChannelFutureListener fireExceptionListener;

    public VoidChannelPromise(Channel channel, boolean bl2) {
        ObjectUtil.checkNotNull(channel, "channel");
        this.channel = channel;
        this.fireExceptionListener = bl2 ? new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                Throwable throwable = channelFuture.cause();
                if (throwable != null) {
                    VoidChannelPromise.this.fireException0(throwable);
                }
            }
        } : null;
    }

    @Override
    public VoidChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public VoidChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        return this;
    }

    @Override
    public VoidChannelPromise await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this;
    }

    @Override
    public boolean await(long l2, TimeUnit timeUnit) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public boolean setUncancellable() {
        return true;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public Throwable cause() {
        return null;
    }

    @Override
    public VoidChannelPromise sync() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public VoidChannelPromise syncUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public VoidChannelPromise setFailure(Throwable throwable) {
        this.fireException0(throwable);
        return this;
    }

    @Override
    public VoidChannelPromise setSuccess() {
        return this;
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        this.fireException0(throwable);
        return false;
    }

    @Override
    public boolean cancel(boolean bl2) {
        return false;
    }

    @Override
    public boolean trySuccess() {
        return false;
    }

    private static void fail() {
        throw new IllegalStateException("void future");
    }

    @Override
    public VoidChannelPromise setSuccess(Void void_) {
        return this;
    }

    @Override
    public boolean trySuccess(Void void_) {
        return false;
    }

    @Override
    public Void getNow() {
        return null;
    }

    @Override
    public ChannelPromise unvoid() {
        DefaultChannelPromise defaultChannelPromise = new DefaultChannelPromise(this.channel);
        if (this.fireExceptionListener != null) {
            defaultChannelPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)this.fireExceptionListener);
        }
        return defaultChannelPromise;
    }

    @Override
    public boolean isVoid() {
        return true;
    }

    private void fireException0(Throwable throwable) {
        if (this.fireExceptionListener != null && this.channel.isRegistered()) {
            this.channel.pipeline().fireExceptionCaught(throwable);
        }
    }
}

