/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.CipherSuiteConverter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.GroupsConverter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslEngine;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.PemPrivateKey;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SslContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SslProvider;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.Buffer;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.Library;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSLContext;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.NativeLibraryLoader;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public final class OpenSsl {
    private static final InternalLogger logger;
    private static final Throwable UNAVAILABILITY_CAUSE;
    static final List<String> DEFAULT_CIPHERS;
    static final Set<String> AVAILABLE_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_OPENSSL_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_JAVA_CIPHER_SUITES;
    private static final boolean SUPPORTS_KEYMANAGER_FACTORY;
    private static final boolean USE_KEYMANAGER_FACTORY;
    private static final boolean SUPPORTS_OCSP;
    private static final boolean TLSV13_SUPPORTED;
    private static final boolean IS_BORINGSSL;
    private static final Set<String> CLIENT_DEFAULT_PROTOCOLS;
    private static final Set<String> SERVER_DEFAULT_PROTOCOLS;
    static final Set<String> SUPPORTED_PROTOCOLS_SET;
    static final String[] EXTRA_SUPPORTED_TLS_1_3_CIPHERS;
    static final String EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING;
    static final String[] NAMED_GROUPS;
    static final boolean JAVAX_CERTIFICATE_CREATION_SUPPORTED;
    private static final String[] DEFAULT_NAMED_GROUPS;

    static String checkTls13Ciphers(InternalLogger internalLogger, String string) {
        if (IS_BORINGSSL && !string.isEmpty()) {
            assert (EXTRA_SUPPORTED_TLS_1_3_CIPHERS.length > 0);
            HashSet hashSet = new HashSet(EXTRA_SUPPORTED_TLS_1_3_CIPHERS.length);
            Collections.addAll(hashSet, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
            boolean bl2 = false;
            for (String string2 : string.split(":")) {
                if (hashSet.isEmpty()) {
                    bl2 = true;
                    break;
                }
                if (hashSet.remove(string2) || hashSet.remove(CipherSuiteConverter.toJava(string2, "TLS"))) continue;
                bl2 = true;
                break;
            }
            if (bl2 |= !hashSet.isEmpty()) {
                if (internalLogger.isInfoEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder(128);
                    for (String string3 : string.split(":")) {
                        stringBuilder.append(CipherSuiteConverter.toJava(string3, "TLS")).append(":");
                    }
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    internalLogger.info("BoringSSL doesn't allow to enable or disable TLSv1.3 ciphers explicitly. Provided TLSv1.3 ciphers: '{}', default TLSv1.3 ciphers that will be used: '{}'.", stringBuilder, EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING);
                }
                return EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING;
            }
        }
        return string;
    }

    static java.security.cert.X509Certificate selfSignedCertificate() throws java.security.cert.CertificateException {
        return (java.security.cert.X509Certificate)SslContext.X509_CERT_FACTORY.generateCertificate(new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICrjCCAZagAwIBAgIIdSvQPv1QAZQwDQYJKoZIhvcNAQELBQAwFjEUMBIGA1UEAxMLZXhhbXBs\nZS5jb20wIBcNMTgwNDA2MjIwNjU5WhgPOTk5OTEyMzEyMzU5NTlaMBYxFDASBgNVBAMTC2V4YW1w\nbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAggbWsmDQ6zNzRZ5AW8E3eoGl\nqWvOBDb5Fs1oBRrVQHuYmVAoaqwDzXYJ0LOwa293AgWEQ1jpcbZ2hpoYQzqEZBTLnFhMrhRFlH6K\nbJND8Y33kZ/iSVBBDuGbdSbJShlM+4WwQ9IAso4MZ4vW3S1iv5fGGpLgbtXRmBf/RU8omN0Gijlv\nWlLWHWijLN8xQtySFuBQ7ssW8RcKAary3pUm6UUQB+Co6lnfti0Tzag8PgjhAJq2Z3wbsGRnP2YS\nvYoaK6qzmHXRYlp/PxrjBAZAmkLJs4YTm/XFF+fkeYx4i9zqHbyone5yerRibsHaXZWLnUL+rFoe\nMdKvr0VS3sGmhQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQADQi441pKmXf9FvUV5EHU4v8nJT9Iq\nyqwsKwXnr7AsUlDGHBD7jGrjAXnG5rGxuNKBQ35wRxJATKrUtyaquFUL6H8O6aGQehiFTk6zmPbe\n12Gu44vqqTgIUxnv3JQJiox8S2hMxsSddpeCmSdvmalvD6WG4NthH6B9ZaBEiep1+0s0RUaBYn73\nI7CCUaAtbjfR6pcJjrFk5ei7uwdQZFSJtkP2z8r7zfeANJddAKFlkaMWn7u+OIVuB4XPooWicObk\nNAHFtP65bocUYnDpTVdiyvn8DdqyZ/EO8n1bBKBzuSLplk2msW4pdgaFgY7Vw/0wzcFXfUXmL1uy\nG8sQD/wx\n-----END CERTIFICATE-----".getBytes(CharsetUtil.US_ASCII)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doesSupportOcsp() {
        boolean bl2 = false;
        if ((long)OpenSsl.version() >= 0x10002000L) {
            long l2 = -1L;
            try {
                l2 = SSLContext.make((int)16, (int)1);
                SSLContext.enableOcsp((long)l2, (boolean)false);
                bl2 = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (l2 != -1L) {
                    SSLContext.free((long)l2);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doesSupportProtocol(int n2, int n3) {
        if (n3 == 0) {
            return false;
        }
        long l2 = -1L;
        try {
            l2 = SSLContext.make((int)n2, (int)2);
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (l2 != -1L) {
                SSLContext.free((long)l2);
            }
        }
    }

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static boolean isOcspSupported() {
        return SUPPORTS_OCSP;
    }

    public static int version() {
        return OpenSsl.isAvailable() ? SSL.version() : -1;
    }

    public static String versionString() {
        return OpenSsl.isAvailable() ? SSL.versionString() : null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Set<String> availableJavaCipherSuites() {
        return AVAILABLE_JAVA_CIPHER_SUITES;
    }

    public static boolean isCipherSuiteAvailable(String string) {
        String string2 = CipherSuiteConverter.toOpenSsl(string, IS_BORINGSSL);
        if (string2 != null) {
            string = string2;
        }
        return AVAILABLE_OPENSSL_CIPHER_SUITES.contains(string);
    }

    static boolean useKeyManagerFactory() {
        return USE_KEYMANAGER_FACTORY;
    }

    static long memoryAddress(ByteBuf byteBuf) {
        assert (byteBuf.isDirect());
        return byteBuf.hasMemoryAddress() ? byteBuf.memoryAddress() : Buffer.address((ByteBuffer)byteBuf.internalNioBuffer(0, byteBuf.readableBytes()));
    }

    private OpenSsl() {
    }

    private static void loadTcNative() throws Exception {
        String string = PlatformDependent.normalizedOs();
        String string2 = PlatformDependent.normalizedArch();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(5);
        String string3 = "netty_tcnative";
        if ("linux".equals(string)) {
            Set<String> set = PlatformDependent.normalizedLinuxClassifiers();
            for (String string4 : set) {
                linkedHashSet.add(string3 + "_" + string + '_' + string2 + "_" + string4);
            }
            linkedHashSet.add(string3 + "_" + string + '_' + string2);
            linkedHashSet.add(string3 + "_" + string + '_' + string2 + "_fedora");
        } else {
            linkedHashSet.add(string3 + "_" + string + '_' + string2);
        }
        linkedHashSet.add(string3 + "_" + string2);
        linkedHashSet.add(string3);
        NativeLibraryLoader.loadFirstAvailable(PlatformDependent.getClassLoader(SSLContext.class), linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS));
    }

    private static boolean initializeTcNative(String string) throws Exception {
        return Library.initialize((String)"provided", (String)string);
    }

    static void releaseIfNeeded(ReferenceCounted referenceCounted) {
        if (referenceCounted.refCnt() > 0) {
            ReferenceCountUtil.safeRelease(referenceCounted);
        }
    }

    static boolean isTlsv13Supported() {
        return TLSV13_SUPPORTED;
    }

    private static Set<String> protocols(String string) {
        String string2 = SystemPropertyUtil.get(string, null);
        if (string2 != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string3 : string2.split(",")) {
                String string4 = string3.trim();
                hashSet.add(string4);
            }
            return hashSet;
        }
        return null;
    }

    static String[] defaultProtocols(boolean bl2) {
        Set<String> set;
        Set<String> set2 = set = bl2 ? CLIENT_DEFAULT_PROTOCOLS : SERVER_DEFAULT_PROTOCOLS;
        if (set == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        for (String string : set) {
            if (!SUPPORTED_PROTOCOLS_SET.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    static boolean isBoringSSL() {
        return IS_BORINGSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        logger = InternalLoggerFactory.getInstance(OpenSsl.class);
        DEFAULT_NAMED_GROUPS = new String[]{"x25519", "secp256r1", "secp384r1", "secp521r1"};
        Throwable throwable = null;
        if (SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.noOpenSsl", false)) {
            throwable = new UnsupportedOperationException("OpenSSL was explicit disabled with -Dio.netty.handler.ssl.noOpenSsl=true");
            logger.debug("netty-tcnative explicit disabled; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.", throwable);
        } else {
            try {
                Class.forName("com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSLContext", false, PlatformDependent.getClassLoader(OpenSsl.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throwable = classNotFoundException;
                logger.debug("netty-tcnative not in the classpath; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.");
            }
            if (throwable == null) {
                try {
                    OpenSsl.loadTcNative();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    logger.debug("Failed to load netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable, unless the application has already loaded the symbols by some other means. See https://netty.io/wiki/forked-tomcat-native.html for more information.", throwable2);
                }
                try {
                    object = SystemPropertyUtil.get("com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.openssl.engine", null);
                    if (object == null) {
                        logger.debug("Initialize netty-tcnative using engine: 'default'");
                    } else {
                        logger.debug("Initialize netty-tcnative using engine: '{}'", object);
                    }
                    OpenSsl.initializeTcNative((String)object);
                    throwable = null;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    }
                    logger.debug("Failed to initialize netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable. See https://netty.io/wiki/forked-tomcat-native.html for more information.", throwable3);
                }
            }
        }
        UNAVAILABILITY_CAUSE = throwable;
        CLIENT_DEFAULT_PROTOCOLS = OpenSsl.protocols("jdk.tls.client.protocols");
        SERVER_DEFAULT_PROTOCOLS = OpenSsl.protocols("jdk.tls.server.protocols");
        if (throwable == null) {
            int n2;
            logger.debug("netty-tcnative using native library: {}", (Object)SSL.versionString());
            object = new ArrayList();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(128);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String[] stringArray = DEFAULT_NAMED_GROUPS;
            String[] stringArray2 = new String[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray2[i2] = GroupsConverter.toOpenSsl(stringArray[i2]);
            }
            IS_BORINGSSL = "BoringSSL".equals(OpenSsl.versionString());
            if (IS_BORINGSSL) {
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS = new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256"};
                StringBuilder stringBuilder = new StringBuilder(128);
                for (String string : EXTRA_SUPPORTED_TLS_1_3_CIPHERS) {
                    stringBuilder.append(string).append(":");
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = stringBuilder.toString();
            } else {
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS = EmptyArrays.EMPTY_STRINGS;
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = "";
            }
            try {
                long l2 = SSLContext.make((int)63, (int)1);
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                try {
                    Object[] objectArray;
                    if (SslProvider.isTlsv13Supported(SslProvider.JDK)) {
                        try {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String object22 : SslUtils.TLSV13_CIPHERS) {
                                String error = CipherSuiteConverter.toOpenSsl(object22, IS_BORINGSSL);
                                if (error == null) continue;
                                stringBuilder.append(error).append(':');
                            }
                            if (stringBuilder.length() == 0) {
                                bl4 = false;
                            } else {
                                stringBuilder.setLength(stringBuilder.length() - 1);
                                SSLContext.setCipherSuite((long)l2, (String)stringBuilder.toString(), (boolean)true);
                                bl4 = true;
                            }
                        }
                        catch (Exception exception) {
                            bl4 = false;
                        }
                    }
                    SSLContext.setCipherSuite((long)l2, (String)"ALL", (boolean)false);
                    long l7 = SSL.newSSL((long)l2, (boolean)true);
                    try {
                        for (String string : SSL.getCiphers((long)l7)) {
                            if (string == null || string.isEmpty() || linkedHashSet.contains(string) || !bl4 && SslUtils.isTLSv13Cipher(string)) continue;
                            linkedHashSet.add(string);
                        }
                        if (IS_BORINGSSL) {
                            Collections.addAll(linkedHashSet, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
                            Collections.addAll(linkedHashSet, "AEAD-AES128-GCM-SHA256", "AEAD-AES256-GCM-SHA384", "AEAD-CHACHA20-POLY1305-SHA256");
                        }
                        PemPrivateKey pemPrivateKey = PemPrivateKey.valueOf("-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCCBtayYNDrM3NFnkBbwTd6gaWp\na84ENvkWzWgFGtVAe5iZUChqrAPNdgnQs7Brb3cCBYRDWOlxtnaGmhhDOoRkFMucWEyuFEWUfops\nk0PxjfeRn+JJUEEO4Zt1JslKGUz7hbBD0gCyjgxni9bdLWK/l8YakuBu1dGYF/9FTyiY3QaKOW9a\nUtYdaKMs3zFC3JIW4FDuyxbxFwoBqvLelSbpRRAH4KjqWd+2LRPNqDw+COEAmrZnfBuwZGc/ZhK9\nihorqrOYddFiWn8/GuMEBkCaQsmzhhOb9cUX5+R5jHiL3OodvKid7nJ6tGJuwdpdlYudQv6sWh4x\n0q+vRVLewaaFAgMBAAECggEAP8tPJvFtTxhNJAkCloHz0D0vpDHqQBMgntlkgayqmBqLwhyb18pR\ni0qwgh7HHc7wWqOOQuSqlEnrWRrdcI6TSe8R/sErzfTQNoznKWIPYcI/hskk4sdnQ//Yn9/Jvnsv\nU/BBjOTJxtD+sQbhAl80JcA3R+5sArURQkfzzHOL/YMqzAsn5hTzp7HZCxUqBk3KaHRxV7NefeOE\nxlZuWSmxYWfbFIs4kx19/1t7h8CHQWezw+G60G2VBtSBBxDnhBWvqG6R/wpzJ3nEhPLLY9T+XIHe\nipzdMOOOUZorfIg7M+pyYPji+ZIZxIpY5OjrOzXHciAjRtr5Y7l99K1CG1LguQKBgQDrQfIMxxtZ\nvxU/1cRmUV9l7pt5bjV5R6byXq178LxPKVYNjdZ840Q0/OpZEVqaT1xKVi35ohP1QfNjxPLlHD+K\niDAR9z6zkwjIrbwPCnb5kuXy4lpwPcmmmkva25fI7qlpHtbcuQdoBdCfr/KkKaUCMPyY89LCXgEw\n5KTDj64UywKBgQCNfbO+eZLGzhiHhtNJurresCsIGWlInv322gL8CSfBMYl6eNfUTZvUDdFhPISL\nUljKWzXDrjw0ujFSPR0XhUGtiq89H+HUTuPPYv25gVXO+HTgBFZEPl4PpA+BUsSVZy0NddneyqLk\n42Wey9omY9Q8WsdNQS5cbUvy0uG6WFoX7wKBgQDZ1jpW8pa0x2bZsQsm4vo+3G5CRnZlUp+XlWt2\ndDcp5dC0xD1zbs1dc0NcLeGDOTDv9FSl7hok42iHXXq8AygjEm/QcuwwQ1nC2HxmQP5holAiUs4D\nWHM8PWs3wFYPzE459EBoKTxeaeP/uWAn+he8q7d5uWvSZlEcANs/6e77eQKBgD21Ar0hfFfj7mK8\n9E0FeRZBsqK3omkfnhcYgZC11Xa2SgT1yvs2Va2n0RcdM5kncr3eBZav2GYOhhAdwyBM55XuE/sO\neokDVutNeuZ6d5fqV96TRaRBpvgfTvvRwxZ9hvKF4Vz+9wfn/JvCwANaKmegF6ejs7pvmF3whq2k\ndrZVAoGAX5YxQ5XMTD0QbMAl7/6qp6S58xNoVdfCkmkj1ZLKaHKIjS/benkKGlySVQVPexPfnkZx\np/Vv9yyphBoudiTBS9Uog66ueLYZqpgxlM/6OhYg86Gm3U2ycvMxYjBM1NFiyze21AqAhI+HX+Ot\nmraV2/guSgDgZAhukRZzeQ2RucI=\n-----END PRIVATE KEY-----".getBytes(CharsetUtil.US_ASCII));
                        try {
                            SSLContext.setCertificateCallback((long)l2, null);
                            objectArray = OpenSsl.selfSignedCertificate();
                            l3 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, new java.security.cert.X509Certificate[]{objectArray});
                            l5 = SSL.parseX509Chain((long)l3);
                            l4 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemPrivateKey.retain());
                            l6 = SSL.parsePrivateKey((long)l4, null);
                            SSL.setKeyMaterial((long)l7, (long)l5, (long)l6);
                            bl2 = true;
                            try {
                                int n3 = SystemPropertyUtil.contains("com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.openssl.useKeyManagerFactory") ? 1 : 0;
                                if (!IS_BORINGSSL) {
                                    bl3 = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.openssl.useKeyManagerFactory", true);
                                    if (n3 != 0) {
                                        logger.info("System property 'io.netty.handler.ssl.openssl.useKeyManagerFactory' is deprecated and so will be ignored in the future");
                                    }
                                } else {
                                    bl3 = true;
                                    if (n3 != 0) {
                                        logger.info("System property 'io.netty.handler.ssl.openssl.useKeyManagerFactory' is deprecated and will be ignored when using BoringSSL");
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                logger.debug("Failed to get useKeyManagerFactory system property.");
                            }
                        }
                        catch (Error error) {
                            logger.debug("KeyManagerFactory not supported.");
                        }
                        finally {
                            pemPrivateKey.release();
                        }
                    }
                    finally {
                        SSL.freeSSL((long)l7);
                        if (l3 != 0L) {
                            SSL.freeBIO((long)l3);
                        }
                        if (l4 != 0L) {
                            SSL.freeBIO((long)l4);
                        }
                        if (l5 != 0L) {
                            SSL.freeX509Chain((long)l5);
                        }
                        if (l6 != 0L) {
                            SSL.freePrivateKey((long)l6);
                        }
                    }
                    String string = SystemPropertyUtil.get("jdk.tls.namedGroups", null);
                    if (string != null) {
                        objectArray = string.split(",");
                        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(objectArray.length);
                        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>(objectArray.length);
                        LinkedHashSet<String> linkedHashSet4 = new LinkedHashSet<String>();
                        for (String string2 : objectArray) {
                            String string3 = GroupsConverter.toOpenSsl(string2);
                            if (SSLContext.setCurvesList((long)l2, (String[])new String[]{string3})) {
                                linkedHashSet3.add(string3);
                                linkedHashSet2.add(string2);
                                continue;
                            }
                            linkedHashSet4.add(string2);
                        }
                        if (linkedHashSet2.isEmpty()) {
                            stringArray = stringArray2;
                            logger.info("All configured namedGroups are not supported: {}. Use default: {}.", Arrays.toString(linkedHashSet4.toArray(EmptyArrays.EMPTY_STRINGS)), Arrays.toString(DEFAULT_NAMED_GROUPS));
                        } else {
                            Object[] objectArray2 = linkedHashSet2.toArray(EmptyArrays.EMPTY_STRINGS);
                            if (linkedHashSet4.isEmpty()) {
                                logger.info("Using configured namedGroups -D 'jdk.tls.namedGroup': {} ", Arrays.toString(objectArray2));
                            } else {
                                logger.info("Using supported configured namedGroups: {}. Unsupported namedGroups: {}. ", Arrays.toString(objectArray2), Arrays.toString(linkedHashSet4.toArray(EmptyArrays.EMPTY_STRINGS)));
                            }
                            stringArray = linkedHashSet3.toArray(EmptyArrays.EMPTY_STRINGS);
                        }
                    } else {
                        stringArray = stringArray2;
                    }
                }
                finally {
                    SSLContext.free((long)l2);
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to get the list of available OpenSSL cipher suites.", exception);
            }
            NAMED_GROUPS = stringArray;
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet);
            LinkedHashSet<String> linkedHashSet4 = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() * 2);
            for (String string : AVAILABLE_OPENSSL_CIPHER_SUITES) {
                if (!SslUtils.isTLSv13Cipher(string)) {
                    linkedHashSet4.add(CipherSuiteConverter.toJava(string, "TLS"));
                    linkedHashSet4.add(CipherSuiteConverter.toJava(string, "SSL"));
                    continue;
                }
                linkedHashSet4.add(string);
            }
            SslUtils.addIfSupported(linkedHashSet4, (List<String>)object, SslUtils.DEFAULT_CIPHER_SUITES);
            SslUtils.addIfSupported(linkedHashSet4, (List<String>)object, SslUtils.TLSV13_CIPHER_SUITES);
            SslUtils.addIfSupported(linkedHashSet4, (List<String>)object, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
            SslUtils.useFallbackCiphersIfDefaultIsEmpty((List<String>)object, linkedHashSet4);
            DEFAULT_CIPHERS = Collections.unmodifiableList(object);
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet4);
            LinkedHashSet linkedHashSet5 = new LinkedHashSet(AVAILABLE_OPENSSL_CIPHER_SUITES.size() + AVAILABLE_JAVA_CIPHER_SUITES.size());
            linkedHashSet5.addAll(AVAILABLE_OPENSSL_CIPHER_SUITES);
            linkedHashSet5.addAll(AVAILABLE_JAVA_CIPHER_SUITES);
            AVAILABLE_CIPHER_SUITES = linkedHashSet5;
            SUPPORTS_KEYMANAGER_FACTORY = bl2;
            USE_KEYMANAGER_FACTORY = bl3;
            LinkedHashSet<String> linkedHashSet6 = new LinkedHashSet<String>(6);
            linkedHashSet6.add("SSLv2Hello");
            if (OpenSsl.doesSupportProtocol(1, SSL.SSL_OP_NO_SSLv2)) {
                linkedHashSet6.add("SSLv2");
            }
            if (OpenSsl.doesSupportProtocol(2, SSL.SSL_OP_NO_SSLv3)) {
                linkedHashSet6.add("SSLv3");
            }
            if (OpenSsl.doesSupportProtocol(4, SSL.SSL_OP_NO_TLSv1)) {
                linkedHashSet6.add("TLSv1");
            }
            if (OpenSsl.doesSupportProtocol(8, SSL.SSL_OP_NO_TLSv1_1)) {
                linkedHashSet6.add("TLSv1.1");
            }
            if (OpenSsl.doesSupportProtocol(16, SSL.SSL_OP_NO_TLSv1_2)) {
                linkedHashSet6.add("TLSv1.2");
            }
            if (bl4 && OpenSsl.doesSupportProtocol(32, SSL.SSL_OP_NO_TLSv1_3)) {
                linkedHashSet6.add("TLSv1.3");
                TLSV13_SUPPORTED = true;
            } else {
                TLSV13_SUPPORTED = false;
            }
            SUPPORTED_PROTOCOLS_SET = Collections.unmodifiableSet(linkedHashSet6);
            SUPPORTS_OCSP = OpenSsl.doesSupportOcsp();
            if (logger.isDebugEnabled()) {
                logger.debug("Supported protocols (OpenSSL): {} ", (Object)SUPPORTED_PROTOCOLS_SET);
                logger.debug("Default cipher suites (OpenSSL): {}", (Object)DEFAULT_CIPHERS);
            }
            try {
                X509Certificate.getInstance("-----BEGIN CERTIFICATE-----\nMIICrjCCAZagAwIBAgIIdSvQPv1QAZQwDQYJKoZIhvcNAQELBQAwFjEUMBIGA1UEAxMLZXhhbXBs\nZS5jb20wIBcNMTgwNDA2MjIwNjU5WhgPOTk5OTEyMzEyMzU5NTlaMBYxFDASBgNVBAMTC2V4YW1w\nbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAggbWsmDQ6zNzRZ5AW8E3eoGl\nqWvOBDb5Fs1oBRrVQHuYmVAoaqwDzXYJ0LOwa293AgWEQ1jpcbZ2hpoYQzqEZBTLnFhMrhRFlH6K\nbJND8Y33kZ/iSVBBDuGbdSbJShlM+4WwQ9IAso4MZ4vW3S1iv5fGGpLgbtXRmBf/RU8omN0Gijlv\nWlLWHWijLN8xQtySFuBQ7ssW8RcKAary3pUm6UUQB+Co6lnfti0Tzag8PgjhAJq2Z3wbsGRnP2YS\nvYoaK6qzmHXRYlp/PxrjBAZAmkLJs4YTm/XFF+fkeYx4i9zqHbyone5yerRibsHaXZWLnUL+rFoe\nMdKvr0VS3sGmhQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQADQi441pKmXf9FvUV5EHU4v8nJT9Iq\nyqwsKwXnr7AsUlDGHBD7jGrjAXnG5rGxuNKBQ35wRxJATKrUtyaquFUL6H8O6aGQehiFTk6zmPbe\n12Gu44vqqTgIUxnv3JQJiox8S2hMxsSddpeCmSdvmalvD6WG4NthH6B9ZaBEiep1+0s0RUaBYn73\nI7CCUaAtbjfR6pcJjrFk5ei7uwdQZFSJtkP2z8r7zfeANJddAKFlkaMWn7u+OIVuB4XPooWicObk\nNAHFtP65bocUYnDpTVdiyvn8DdqyZ/EO8n1bBKBzuSLplk2msW4pdgaFgY7Vw/0wzcFXfUXmL1uy\nG8sQD/wx\n-----END CERTIFICATE-----".getBytes(CharsetUtil.US_ASCII));
                n2 = 1;
            }
            catch (CertificateException certificateException) {
                n2 = 0;
            }
            JAVAX_CERTIFICATE_CREATION_SUPPORTED = n2;
        } else {
            DEFAULT_CIPHERS = Collections.emptyList();
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.emptySet();
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.emptySet();
            AVAILABLE_CIPHER_SUITES = Collections.emptySet();
            SUPPORTS_KEYMANAGER_FACTORY = false;
            USE_KEYMANAGER_FACTORY = false;
            SUPPORTED_PROTOCOLS_SET = Collections.emptySet();
            SUPPORTS_OCSP = false;
            TLSV13_SUPPORTED = false;
            IS_BORINGSSL = false;
            EXTRA_SUPPORTED_TLS_1_3_CIPHERS = EmptyArrays.EMPTY_STRINGS;
            EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = "";
            NAMED_GROUPS = DEFAULT_NAMED_GROUPS;
            JAVAX_CERTIFICATE_CREATION_SUPPORTED = false;
        }
    }
}

