/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.concurrent;

import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.DefaultPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutorGroup;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GlobalEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.OrderedEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.RejectedExecutionHandler;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.ScheduledFutureTask;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.ThreadProperties;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ThreadExecutorMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.Async;

public abstract class SingleThreadEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    static final int DEFAULT_MAX_PENDING_EXECUTOR_TASKS = Math.max(16, SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.eventexecutor.maxPendingTasks", Integer.MAX_VALUE));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final Runnable NOOP_TASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "state");
    private static final AtomicReferenceFieldUpdater<SingleThreadEventExecutor, ThreadProperties> PROPERTIES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleThreadEventExecutor.class, ThreadProperties.class, "threadProperties");
    private final Queue<Runnable> taskQueue;
    private volatile Thread thread;
    private volatile ThreadProperties threadProperties;
    private final Executor executor;
    private volatile boolean interrupted;
    private final CountDownLatch threadLock = new CountDownLatch(1);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private final int maxPendingTasks;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, Executor executor, boolean bl2, Queue<Runnable> queue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventExecutorGroup);
        this.addTaskWakesUp = bl2;
        this.maxPendingTasks = DEFAULT_MAX_PENDING_EXECUTOR_TASKS;
        this.executor = ThreadExecutorMap.apply(executor, (EventExecutor)this);
        this.taskQueue = ObjectUtil.checkNotNull(queue, "taskQueue");
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedExecutionHandler, "rejectedHandler");
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        return SingleThreadEventExecutor.pollTaskFrom(this.taskQueue);
    }

    protected static Runnable pollTaskFrom(Queue<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) == WAKEUP_TASK) {
        }
        return runnable;
    }

    private boolean fetchFromScheduledTaskQueue() {
        Runnable runnable;
        if (this.scheduledTaskQueue == null || this.scheduledTaskQueue.isEmpty()) {
            return true;
        }
        long l2 = this.getCurrentTimeNanos();
        do {
            if ((runnable = this.pollScheduledTask(l2)) != null) continue;
            return true;
        } while (this.taskQueue.offer(runnable));
        this.scheduledTaskQueue.add((ScheduledFutureTask)runnable);
        return false;
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    protected void addTask(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "task");
        if (!this.offerTask(runnable)) {
            this.reject(runnable);
        }
    }

    final boolean offerTask(Runnable runnable) {
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        return this.taskQueue.offer(runnable);
    }

    protected boolean removeTask(Runnable runnable) {
        return this.taskQueue.remove(ObjectUtil.checkNotNull(runnable, "task"));
    }

    protected boolean runAllTasks() {
        boolean bl2;
        assert (this.inEventLoop());
        boolean bl3 = false;
        do {
            bl2 = this.fetchFromScheduledTaskQueue();
            if (!this.runAllTasksFrom(this.taskQueue)) continue;
            bl3 = true;
        } while (!bl2);
        if (bl3) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        return bl3;
    }

    protected final boolean runAllTasksFrom(Queue<Runnable> queue) {
        Runnable runnable = SingleThreadEventExecutor.pollTaskFrom(queue);
        if (runnable == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(runnable);
        } while ((runnable = SingleThreadEventExecutor.pollTaskFrom(queue)) != null);
        return true;
    }

    protected boolean runAllTasks(long l2) {
        long l3;
        block2: {
            this.fetchFromScheduledTaskQueue();
            Runnable runnable = this.pollTask();
            if (runnable == null) {
                this.afterRunningAllTasks();
                return false;
            }
            long l4 = l2 > 0L ? this.getCurrentTimeNanos() + l2 : 0L;
            long l5 = 0L;
            do {
                SingleThreadEventExecutor.safeExecute(runnable);
                if ((++l5 & 0x3FL) == 0L && (l3 = this.getCurrentTimeNanos()) >= l4) break block2;
            } while ((runnable = this.pollTask()) != null);
            l3 = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        this.lastExecutionTime = l3;
        return true;
    }

    protected void afterRunningAllTasks() {
    }

    protected void updateLastExecutionTime() {
        this.lastExecutionTime = this.getCurrentTimeNanos();
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean bl2) {
        if (!bl2) {
            this.taskQueue.offer(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runShutdownHooks() {
        boolean bl2 = false;
        while (!this.shutdownHooks.isEmpty()) {
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            for (Runnable runnable : arrayList) {
                try {
                    SingleThreadEventExecutor.runTask(runnable);
                }
                catch (Throwable throwable) {
                    logger.warn("Shutdown hook raised an exception.", throwable);
                }
                finally {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        return bl2;
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        boolean bl2;
        int n2;
        int n3;
        ObjectUtil.checkPositiveOrZero(l2, "quietPeriod");
        if (l3 < l2) {
            throw new IllegalArgumentException("timeout: " + l3 + " (expected >= quietPeriod (" + l2 + "))");
        }
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (this.isShuttingDown()) {
            return this.terminationFuture();
        }
        boolean bl3 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return this.terminationFuture();
            }
            bl2 = true;
            n3 = this.state;
            if (bl3) {
                n2 = 3;
                continue;
            }
            switch (n3) {
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = n3;
                    bl2 = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n3, n2));
        this.gracefulShutdownQuietPeriod = timeUnit.toNanos(l2);
        this.gracefulShutdownTimeout = timeUnit.toNanos(l3);
        if (this.ensureThreadStarted(n3)) {
            return this.terminationFuture;
        }
        if (bl2) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(bl3);
            }
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        boolean bl2;
        int n2;
        int n3;
        if (this.isShutdown()) {
            return;
        }
        boolean bl3 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return;
            }
            bl2 = true;
            n3 = this.state;
            if (bl3) {
                n2 = 4;
                continue;
            }
            switch (n3) {
                case 1: 
                case 2: 
                case 3: {
                    n2 = 4;
                    break;
                }
                default: {
                    n2 = n3;
                    bl2 = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n3, n2));
        if (this.ensureThreadStarted(n3)) {
            return;
        }
        if (bl2) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(bl3);
            }
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 3;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 5;
    }

    protected boolean confirmShutdown() {
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelScheduledTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = this.getCurrentTimeNanos();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            if (this.gracefulShutdownQuietPeriod == 0L) {
                return true;
            }
            this.taskQueue.offer(WAKEUP_TASK);
            return false;
        }
        long l2 = this.getCurrentTimeNanos();
        if (this.isShutdown() || l2 - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (l2 - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.taskQueue.offer(WAKEUP_TASK);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        this.threadLock.await(l2, timeUnit);
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable runnable) {
        this.execute0(runnable);
    }

    @Override
    public void lazyExecute(Runnable runnable) {
        this.lazyExecute0(runnable);
    }

    private void execute0(@Async.Schedule Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "task");
        this.execute(runnable, this.wakesUpForTask(runnable));
    }

    private void lazyExecute0(@Async.Schedule Runnable runnable) {
        this.execute(ObjectUtil.checkNotNull(runnable, "task"), false);
    }

    private void execute(Runnable runnable, boolean bl2) {
        boolean bl3 = this.inEventLoop();
        this.addTask(runnable);
        if (!bl3) {
            this.startThread();
            if (this.isShutdown()) {
                boolean bl4 = false;
                try {
                    if (this.removeTask(runnable)) {
                        bl4 = true;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (bl4) {
                    SingleThreadEventExecutor.reject();
                }
            }
        }
        if (!this.addTaskWakesUp && bl2) {
            this.wakeup(bl3);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection, l2, timeUnit);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection, l2, timeUnit);
    }

    private void throwIfInEventLoop(String string) {
        if (this.inEventLoop()) {
            throw new RejectedExecutionException("Calling " + string + " from within the EventLoop is not allowed");
        }
    }

    protected boolean wakesUpForTask(Runnable runnable) {
        return true;
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    protected final void reject(Runnable runnable) {
        this.rejectedExecutionHandler.rejected(runnable, this);
    }

    private void startThread() {
        if (this.state == 1 && STATE_UPDATER.compareAndSet(this, 1, 2)) {
            boolean bl2 = false;
            try {
                this.doStartThread();
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    STATE_UPDATER.compareAndSet(this, 2, 1);
                }
            }
        }
    }

    private boolean ensureThreadStarted(int n2) {
        if (n2 == 1) {
            try {
                this.doStartThread();
            }
            catch (Throwable throwable) {
                STATE_UPDATER.set(this, 5);
                this.terminationFuture.tryFailure(throwable);
                if (!(throwable instanceof Exception)) {
                    PlatformDependent.throwException(throwable);
                }
                return true;
            }
        }
        return false;
    }

    private void doStartThread() {
        assert (this.thread == null);
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SingleThreadEventExecutor.this.thread = Thread.currentThread();
                if (SingleThreadEventExecutor.this.interrupted) {
                    SingleThreadEventExecutor.this.thread.interrupt();
                }
                boolean bl2 = false;
                SingleThreadEventExecutor.this.updateLastExecutionTime();
                try {
                    SingleThreadEventExecutor.this.run();
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    logger.warn("Unexpected exception from an event executor: ", throwable);
                }
                finally {
                    int n2;
                    while ((n2 = SingleThreadEventExecutor.this.state) < 3 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n2, 3)) {
                    }
                    if (bl2 && SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                        logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                    }
                    while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                    }
                    while ((n2 = SingleThreadEventExecutor.this.state) < 4 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n2, 4)) {
                    }
                    SingleThreadEventExecutor.this.confirmShutdown();
                }
            }
        });
    }

    final int drainTasks() {
        Runnable runnable;
        int n2 = 0;
        while ((runnable = this.taskQueue.poll()) != null) {
            if (WAKEUP_TASK == runnable) continue;
            ++n2;
        }
        return n2;
    }

    static /* synthetic */ CountDownLatch access$700(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.threadLock;
    }

    static /* synthetic */ Promise access$800(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.terminationFuture;
    }
}

