/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie;

import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.PublicSuffixMatcher;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.Cookie;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.CookieOrigin;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.MalformedCookieException;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.SetCookie;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PublicSuffixDomainFilter
implements CommonCookieAttributeHandler {
    private final CommonCookieAttributeHandler handler;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final Map<String, Boolean> localDomainMap;

    private static Map<String, Boolean> createLocalDomainMap() {
        ConcurrentHashMap<String, Boolean> concurrentHashMap = new ConcurrentHashMap<String, Boolean>();
        concurrentHashMap.put(".localhost.", Boolean.TRUE);
        concurrentHashMap.put(".test.", Boolean.TRUE);
        concurrentHashMap.put(".local.", Boolean.TRUE);
        concurrentHashMap.put(".local", Boolean.TRUE);
        concurrentHashMap.put(".localdomain", Boolean.TRUE);
        return concurrentHashMap;
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler commonCookieAttributeHandler, PublicSuffixMatcher publicSuffixMatcher) {
        this.handler = Args.notNull(commonCookieAttributeHandler, "Cookie handler");
        this.publicSuffixMatcher = Args.notNull(publicSuffixMatcher, "Public suffix matcher");
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        String string;
        String string2 = cookie.getDomain();
        if (string2 == null) {
            return false;
        }
        int n2 = string2.indexOf(46);
        if (n2 >= 0 ? !this.localDomainMap.containsKey(string = string2.substring(n2)) && this.publicSuffixMatcher.matches(string2) : !string2.equalsIgnoreCase(cookieOrigin.getHost()) && this.publicSuffixMatcher.matches(string2)) {
            return false;
        }
        return this.handler.match(cookie, cookieOrigin);
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        this.handler.parse(setCookie, string);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        this.handler.validate(cookie, cookieOrigin);
    }

    @Override
    public String getAttributeName() {
        return this.handler.getAttributeName();
    }

    public static CommonCookieAttributeHandler decorate(CommonCookieAttributeHandler commonCookieAttributeHandler, PublicSuffixMatcher publicSuffixMatcher) {
        Args.notNull(commonCookieAttributeHandler, "Cookie attribute handler");
        return publicSuffixMatcher != null ? new PublicSuffixDomainFilter(commonCookieAttributeHandler, publicSuffixMatcher) : commonCookieAttributeHandler;
    }
}

