/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.CollectionFactory;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ConversionUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class ArrayToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public ArrayToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        int n2 = Array.getLength(object);
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        Collection<Object> collection = CollectionFactory.createCollection(typeDescriptor2.getType(), typeDescriptor3 != null ? typeDescriptor3.getType() : null, n2);
        if (typeDescriptor3 == null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = Array.get(object, i2);
                collection.add(object2);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object3 = Array.get(object, i3);
                Object object4 = this.conversionService.convert(object3, typeDescriptor.elementTypeDescriptor(object3), typeDescriptor3);
                collection.add(object4);
            }
        }
        return collection;
    }
}

