/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ConversionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class CollectionToArrayConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public CollectionToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        Collection collection = (Collection)object;
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        Assert.state(typeDescriptor3 != null, "No target element type");
        Object object2 = Array.newInstance(typeDescriptor3.getType(), collection.size());
        int n2 = 0;
        for (Object e2 : collection) {
            Object object3 = this.conversionService.convert(e2, typeDescriptor.elementTypeDescriptor(e2), typeDescriptor3);
            Array.set(object2, n2++, object3);
        }
        return object2;
    }
}

