/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.ClassWriter;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Opcodes;
import com.gradle.maven.extension.internal.dep.org.springframework.util.CollectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class CodeFlow
implements Opcodes {
    private final String className;
    private final ClassWriter classWriter;
    private final Deque<List<String>> compilationScopes;
    private List<FieldAdder> fieldAdders;
    private List<ClinitAdder> clinitAdders;
    private int nextFieldId = 1;
    private int nextFreeVariableId = 1;

    public CodeFlow(String string, ClassWriter classWriter) {
        this.className = string;
        this.classWriter = classWriter;
        this.compilationScopes = new ArrayDeque<List<String>>();
        this.compilationScopes.add(new ArrayList());
    }

    public void loadTarget(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, 1);
    }

    public void loadEvaluationContext(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, 2);
    }

    public void pushDescriptor(String string) {
        if (string != null) {
            this.compilationScopes.element().add(string);
        }
    }

    public void enterCompilationScope() {
        this.compilationScopes.push(new ArrayList());
    }

    public void exitCompilationScope() {
        this.compilationScopes.pop();
    }

    public String lastDescriptor() {
        return CollectionUtils.lastElement(this.compilationScopes.peek());
    }

    public void unboxBooleanIfNecessary(MethodVisitor methodVisitor) {
        if ("Ljava/lang/Boolean".equals(this.lastDescriptor())) {
            methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        }
    }

    public void finish() {
        if (this.fieldAdders != null) {
            for (FieldAdder object : this.fieldAdders) {
                object.generateField(this.classWriter, this);
            }
        }
        if (this.clinitAdders != null) {
            MethodVisitor methodVisitor = this.classWriter.visitMethod(9, "<clinit>", "()V", null, null);
            methodVisitor.visitCode();
            this.nextFreeVariableId = 0;
            for (ClinitAdder clinitAdder : this.clinitAdders) {
                clinitAdder.generateCode(methodVisitor, this);
            }
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
    }

    public void registerNewField(FieldAdder fieldAdder) {
        if (this.fieldAdders == null) {
            this.fieldAdders = new ArrayList<FieldAdder>();
        }
        this.fieldAdders.add(fieldAdder);
    }

    public void registerNewClinit(ClinitAdder clinitAdder) {
        if (this.clinitAdders == null) {
            this.clinitAdders = new ArrayList<ClinitAdder>();
        }
        this.clinitAdders.add(clinitAdder);
    }

    public int nextFieldId() {
        return this.nextFieldId++;
    }

    public String getClassName() {
        return this.className;
    }

    public static void insertUnboxInsns(MethodVisitor methodVisitor, char c2, String string) {
        if (string == null) {
            return;
        }
        switch (c2) {
            case 'Z': {
                if (!string.equals("Ljava/lang/Boolean")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 'B': {
                if (!string.equals("Ljava/lang/Byte")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                break;
            }
            case 'C': {
                if (!string.equals("Ljava/lang/Character")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Character");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 'D': {
                if (!string.equals("Ljava/lang/Double")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Double");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                break;
            }
            case 'F': {
                if (!string.equals("Ljava/lang/Float")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Float");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                break;
            }
            case 'I': {
                if (!string.equals("Ljava/lang/Integer")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                break;
            }
            case 'J': {
                if (!string.equals("Ljava/lang/Long")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Long");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case 'S': {
                if (!string.equals("Ljava/lang/Short")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Short");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unboxing should not be attempted for descriptor '" + c2 + "'");
            }
        }
    }

    public static void insertUnboxNumberInsns(MethodVisitor methodVisitor, char c2, String string) {
        if (string == null) {
            return;
        }
        switch (c2) {
            case 'D': {
                if (string.equals("Ljava/lang/Object")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Number");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D", false);
                break;
            }
            case 'F': {
                if (string.equals("Ljava/lang/Object")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Number");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F", false);
                break;
            }
            case 'J': {
                if (string.equals("Ljava/lang/Object")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Number");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "longValue", "()J", false);
                break;
            }
            case 'I': {
                if (string.equals("Ljava/lang/Object")) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Number");
                }
                methodVisitor.visitMethodInsn(182, "java/lang/Number", "intValue", "()I", false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unboxing should not be attempted for descriptor '" + c2 + "'");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void insertAnyNecessaryTypeConversionBytecodes(MethodVisitor methodVisitor, char c2, String string) {
        if (!CodeFlow.isPrimitive(string)) return;
        char c3 = string.charAt(0);
        if (c3 == 'I' || c3 == 'B' || c3 == 'S' || c3 == 'C') {
            if (c2 == 'D') {
                methodVisitor.visitInsn(135);
                return;
            }
            if (c2 == 'F') {
                methodVisitor.visitInsn(134);
                return;
            }
            if (c2 == 'J') {
                methodVisitor.visitInsn(133);
                return;
            }
            if (c2 != 'I') throw new IllegalStateException("Cannot get from " + c3 + " to " + c2);
            return;
        }
        if (c3 == 'J') {
            if (c2 == 'D') {
                methodVisitor.visitInsn(138);
                return;
            }
            if (c2 == 'F') {
                methodVisitor.visitInsn(137);
                return;
            }
            if (c2 == 'J') {
                return;
            }
            if (c2 != 'I') throw new IllegalStateException("Cannot get from " + c3 + " to " + c2);
            methodVisitor.visitInsn(136);
            return;
        }
        if (c3 == 'F') {
            if (c2 == 'D') {
                methodVisitor.visitInsn(141);
                return;
            }
            if (c2 == 'F') {
                return;
            }
            if (c2 == 'J') {
                methodVisitor.visitInsn(140);
                return;
            }
            if (c2 != 'I') throw new IllegalStateException("Cannot get from " + c3 + " to " + c2);
            methodVisitor.visitInsn(139);
            return;
        }
        if (c3 != 'D') return;
        if (c2 == 'D') {
            return;
        }
        if (c2 == 'F') {
            methodVisitor.visitInsn(144);
            return;
        }
        if (c2 == 'J') {
            methodVisitor.visitInsn(143);
            return;
        }
        if (c2 != 'I') throw new IllegalStateException("Cannot get from " + string + " to " + c2);
        methodVisitor.visitInsn(142);
    }

    public static String createSignatureDescriptor(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> clazz : classArray) {
            stringBuilder.append(CodeFlow.toJvmDescriptor(clazz));
        }
        stringBuilder.append(')');
        stringBuilder.append(CodeFlow.toJvmDescriptor(method.getReturnType()));
        return stringBuilder.toString();
    }

    public static String createSignatureDescriptor(Constructor<?> constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> clazz : classArray) {
            stringBuilder.append(CodeFlow.toJvmDescriptor(clazz));
        }
        stringBuilder.append(")V");
        return stringBuilder.toString();
    }

    public static String toJvmDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        if (clazz.isArray()) {
            while (clazz.isArray()) {
                stringBuilder.append('[');
                clazz = clazz.getComponentType();
            }
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                stringBuilder.append('Z');
            } else if (clazz == Byte.TYPE) {
                stringBuilder.append('B');
            } else if (clazz == Character.TYPE) {
                stringBuilder.append('C');
            } else if (clazz == Double.TYPE) {
                stringBuilder.append('D');
            } else if (clazz == Float.TYPE) {
                stringBuilder.append('F');
            } else if (clazz == Integer.TYPE) {
                stringBuilder.append('I');
            } else if (clazz == Long.TYPE) {
                stringBuilder.append('J');
            } else if (clazz == Short.TYPE) {
                stringBuilder.append('S');
            } else if (clazz == Void.TYPE) {
                stringBuilder.append('V');
            }
        } else {
            stringBuilder.append('L');
            stringBuilder.append(clazz.getName().replace('.', '/'));
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public static String toDescriptorFromObject(Object object) {
        if (object == null) {
            return "Ljava/lang/Object";
        }
        return CodeFlow.toDescriptor(object.getClass());
    }

    public static boolean isBooleanCompatible(String string) {
        return string != null && (string.equals("Z") || string.equals("Ljava/lang/Boolean"));
    }

    public static boolean isPrimitive(String string) {
        return string != null && string.length() == 1;
    }

    public static boolean isPrimitiveArray(String string) {
        if (string == null) {
            return false;
        }
        boolean bl2 = true;
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '[') continue;
            bl2 = c2 != 'L';
            break;
        }
        return bl2;
    }

    public static boolean areBoxingCompatible(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (string.length() == 1) {
            if (string.equals("Z")) {
                return string2.equals("Ljava/lang/Boolean");
            }
            if (string.equals("D")) {
                return string2.equals("Ljava/lang/Double");
            }
            if (string.equals("F")) {
                return string2.equals("Ljava/lang/Float");
            }
            if (string.equals("I")) {
                return string2.equals("Ljava/lang/Integer");
            }
            if (string.equals("J")) {
                return string2.equals("Ljava/lang/Long");
            }
        } else if (string2.length() == 1) {
            if (string2.equals("Z")) {
                return string.equals("Ljava/lang/Boolean");
            }
            if (string2.equals("D")) {
                return string.equals("Ljava/lang/Double");
            }
            if (string2.equals("F")) {
                return string.equals("Ljava/lang/Float");
            }
            if (string2.equals("I")) {
                return string.equals("Ljava/lang/Integer");
            }
            if (string2.equals("J")) {
                return string.equals("Ljava/lang/Long");
            }
        }
        return false;
    }

    public static boolean isPrimitiveOrUnboxableSupportedNumberOrBoolean(String string) {
        if (string == null) {
            return false;
        }
        if (CodeFlow.isPrimitiveOrUnboxableSupportedNumber(string)) {
            return true;
        }
        return "Z".equals(string) || string.equals("Ljava/lang/Boolean");
    }

    public static boolean isPrimitiveOrUnboxableSupportedNumber(String string) {
        String string2;
        if (string == null) {
            return false;
        }
        if (string.length() == 1) {
            return "DFIJ".contains(string);
        }
        return string.startsWith("Ljava/lang/") && ((string2 = string.substring("Ljava/lang/".length())).equals("Double") || string2.equals("Float") || string2.equals("Integer") || string2.equals("Long"));
    }

    public static boolean isIntegerForNumericOp(Number number) {
        return number instanceof Integer || number instanceof Short || number instanceof Byte;
    }

    public static char toPrimitiveTargetDesc(String string) {
        if (string.length() == 1) {
            return string.charAt(0);
        }
        if (string.equals("Ljava/lang/Boolean")) {
            return 'Z';
        }
        if (string.equals("Ljava/lang/Byte")) {
            return 'B';
        }
        if (string.equals("Ljava/lang/Character")) {
            return 'C';
        }
        if (string.equals("Ljava/lang/Double")) {
            return 'D';
        }
        if (string.equals("Ljava/lang/Float")) {
            return 'F';
        }
        if (string.equals("Ljava/lang/Integer")) {
            return 'I';
        }
        if (string.equals("Ljava/lang/Long")) {
            return 'J';
        }
        if (string.equals("Ljava/lang/Short")) {
            return 'S';
        }
        throw new IllegalStateException("No primitive for '" + string + "'");
    }

    public static void insertCheckCast(MethodVisitor methodVisitor, String string) {
        if (string != null && string.length() != 1) {
            if (string.charAt(0) == '[') {
                if (CodeFlow.isPrimitiveArray(string)) {
                    methodVisitor.visitTypeInsn(192, string);
                } else {
                    methodVisitor.visitTypeInsn(192, string + ";");
                }
            } else if (!string.equals("Ljava/lang/Object")) {
                methodVisitor.visitTypeInsn(192, string.substring(1));
            }
        }
    }

    public static void insertBoxIfNecessary(MethodVisitor methodVisitor, String string) {
        if (string != null && string.length() == 1) {
            CodeFlow.insertBoxIfNecessary(methodVisitor, string.charAt(0));
        }
    }

    public static void insertBoxIfNecessary(MethodVisitor methodVisitor, char c2) {
        switch (c2) {
            case 'Z': {
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 'B': {
                methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 'C': {
                methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 'D': {
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            case 'F': {
                methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 'I': {
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 'J': {
                methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 'S': {
                methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 'L': 
            case 'V': 
            case '[': {
                break;
            }
            default: {
                throw new IllegalArgumentException("Boxing should not be attempted for descriptor '" + c2 + "'");
            }
        }
    }

    public static String toDescriptor(Class<?> clazz) {
        String string = clazz.getName();
        if (clazz.isPrimitive()) {
            switch (string.length()) {
                case 3: {
                    return "I";
                }
                case 4: {
                    if (string.equals("byte")) {
                        return "B";
                    }
                    if (string.equals("char")) {
                        return "C";
                    }
                    if (string.equals("long")) {
                        return "J";
                    }
                    if (!string.equals("void")) break;
                    return "V";
                }
                case 5: {
                    if (string.equals("float")) {
                        return "F";
                    }
                    if (!string.equals("short")) break;
                    return "S";
                }
                case 6: {
                    if (!string.equals("double")) break;
                    return "D";
                }
                case 7: {
                    if (!string.equals("boolean")) break;
                    return "Z";
                }
            }
        } else {
            if (string.charAt(0) != '[') {
                return "L" + clazz.getName().replace('.', '/');
            }
            if (string.endsWith(";")) {
                return string.substring(0, string.length() - 1).replace('.', '/');
            }
            return string;
        }
        return "";
    }

    public static String[] toDescriptors(Class<?>[] classArray) {
        int n2 = classArray.length;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = CodeFlow.toDescriptor(classArray[i2]);
        }
        return stringArray;
    }

    public static void insertOptimalLoad(MethodVisitor methodVisitor, int n2) {
        if (n2 < 6) {
            methodVisitor.visitInsn(3 + n2);
        } else if (n2 < 127) {
            methodVisitor.visitIntInsn(16, n2);
        } else if (n2 < Short.MAX_VALUE) {
            methodVisitor.visitIntInsn(17, n2);
        } else {
            methodVisitor.visitLdcInsn(n2);
        }
    }

    public static void insertArrayStore(MethodVisitor methodVisitor, String string) {
        block11: {
            block10: {
                if (string.length() != 1) break block10;
                switch (string.charAt(0)) {
                    case 'I': {
                        methodVisitor.visitInsn(79);
                        break block11;
                    }
                    case 'J': {
                        methodVisitor.visitInsn(80);
                        break block11;
                    }
                    case 'F': {
                        methodVisitor.visitInsn(81);
                        break block11;
                    }
                    case 'D': {
                        methodVisitor.visitInsn(82);
                        break block11;
                    }
                    case 'B': {
                        methodVisitor.visitInsn(84);
                        break block11;
                    }
                    case 'C': {
                        methodVisitor.visitInsn(85);
                        break block11;
                    }
                    case 'S': {
                        methodVisitor.visitInsn(86);
                        break block11;
                    }
                    case 'Z': {
                        methodVisitor.visitInsn(84);
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected arraytype " + string.charAt(0));
                    }
                }
            }
            methodVisitor.visitInsn(83);
        }
    }

    public static int arrayCodeFor(String string) {
        switch (string.charAt(0)) {
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
            case 'F': {
                return 6;
            }
            case 'D': {
                return 7;
            }
            case 'B': {
                return 8;
            }
            case 'C': {
                return 5;
            }
            case 'S': {
                return 9;
            }
            case 'Z': {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unexpected arraytype " + string.charAt(0));
    }

    public static boolean isReferenceTypeArray(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '[') continue;
            return c2 == 'L';
        }
        return false;
    }

    public static void insertNewArrayCode(MethodVisitor methodVisitor, int n2, String string) {
        CodeFlow.insertOptimalLoad(methodVisitor, n2);
        if (string.length() == 1) {
            methodVisitor.visitIntInsn(188, CodeFlow.arrayCodeFor(string));
        } else if (string.charAt(0) == '[') {
            if (CodeFlow.isReferenceTypeArray(string)) {
                methodVisitor.visitTypeInsn(189, string + ";");
            } else {
                methodVisitor.visitTypeInsn(189, string);
            }
        } else {
            methodVisitor.visitTypeInsn(189, string.substring(1));
        }
    }

    public static void insertNumericUnboxOrPrimitiveTypeCoercion(MethodVisitor methodVisitor, String string, char c2) {
        if (!CodeFlow.isPrimitive(string)) {
            CodeFlow.insertUnboxNumberInsns(methodVisitor, c2, string);
        } else {
            CodeFlow.insertAnyNecessaryTypeConversionBytecodes(methodVisitor, c2, string);
        }
    }

    public static String toBoxedDescriptor(String string) {
        switch (string.charAt(0)) {
            case 'I': {
                return "Ljava/lang/Integer";
            }
            case 'J': {
                return "Ljava/lang/Long";
            }
            case 'F': {
                return "Ljava/lang/Float";
            }
            case 'D': {
                return "Ljava/lang/Double";
            }
            case 'B': {
                return "Ljava/lang/Byte";
            }
            case 'C': {
                return "Ljava/lang/Character";
            }
            case 'S': {
                return "Ljava/lang/Short";
            }
            case 'Z': {
                return "Ljava/lang/Boolean";
            }
        }
        throw new IllegalArgumentException("Unexpected non primitive descriptor " + string);
    }

    @FunctionalInterface
    public static interface ClinitAdder {
        public void generateCode(MethodVisitor var1, CodeFlow var2);
    }

    @FunctionalInterface
    public static interface FieldAdder {
        public void generateField(ClassWriter var1, CodeFlow var2);
    }
}

