/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.Label;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ExpressionInvocationTargetException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.MethodExecutor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.MethodResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.FormatHelper;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectiveMethodExecutor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectiveMethodResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

public class MethodReference
extends SpelNodeImpl {
    private final String name;
    private final boolean nullSafe;
    private String originalPrimitiveExitTypeDescriptor;
    private volatile CachedMethodExecutor cachedExecutor;

    public MethodReference(boolean bl2, String string, int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(n2, n3, spelNodeImplArray);
        this.name = string;
        this.nullSafe = bl2;
    }

    @Override
    protected ValueRef getValueRef(ExpressionState expressionState) throws EvaluationException {
        Object[] objectArray = this.getArguments(expressionState);
        if (expressionState.getActiveContextObject().getValue() == null) {
            this.throwIfNotNullSafe(this.getArgumentTypes(objectArray));
            return ValueRef.NullValueRef.INSTANCE;
        }
        return new MethodValueRef(expressionState, objectArray);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        EvaluationContext evaluationContext = expressionState.getEvaluationContext();
        Object object = expressionState.getActiveContextObject().getValue();
        TypeDescriptor typeDescriptor = expressionState.getActiveContextObject().getTypeDescriptor();
        Object[] objectArray = this.getArguments(expressionState);
        TypedValue typedValue = this.getValueInternal(evaluationContext, object, typeDescriptor, objectArray);
        this.updateExitTypeDescriptor();
        return typedValue;
    }

    private TypedValue getValueInternal(EvaluationContext evaluationContext, Object object, TypeDescriptor typeDescriptor, Object[] objectArray) {
        List<TypeDescriptor> list = this.getArgumentTypes(objectArray);
        if (object == null) {
            this.throwIfNotNullSafe(list);
            return TypedValue.NULL;
        }
        MethodExecutor methodExecutor = this.getCachedExecutor(evaluationContext, object, typeDescriptor, list);
        if (methodExecutor != null) {
            try {
                return methodExecutor.execute(evaluationContext, object, objectArray);
            }
            catch (AccessException accessException) {
                this.throwSimpleExceptionIfPossible(object, accessException);
                this.cachedExecutor = null;
            }
        }
        methodExecutor = this.findAccessorForMethod(list, object, evaluationContext);
        this.cachedExecutor = new CachedMethodExecutor(methodExecutor, object instanceof Class ? (Class)object : null, typeDescriptor, list);
        try {
            return methodExecutor.execute(evaluationContext, object, objectArray);
        }
        catch (AccessException accessException) {
            this.throwSimpleExceptionIfPossible(object, accessException);
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)accessException, SpelMessage.EXCEPTION_DURING_METHOD_INVOCATION, this.name, object.getClass().getName(), accessException.getMessage());
        }
    }

    private void throwIfNotNullSafe(List<TypeDescriptor> list) {
        if (!this.nullSafe) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_CALL_ON_NULL_OBJECT_NOT_ALLOWED, FormatHelper.formatMethodForMessage(this.name, list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getArguments(ExpressionState expressionState) {
        Object[] objectArray = new Object[this.getChildCount()];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                expressionState.pushActiveContextObject(expressionState.getScopeRootContextObject());
                objectArray[i2] = this.children[i2].getValueInternal(expressionState).getValue();
                continue;
            }
            finally {
                expressionState.popActiveContextObject();
            }
        }
        return objectArray;
    }

    private List<TypeDescriptor> getArgumentTypes(Object ... objectArray) {
        ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>(objectArray.length);
        for (Object object : objectArray) {
            arrayList.add(TypeDescriptor.forObject(object));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private MethodExecutor getCachedExecutor(EvaluationContext evaluationContext, Object object, TypeDescriptor typeDescriptor, List<TypeDescriptor> list) {
        List<MethodResolver> list2 = evaluationContext.getMethodResolvers();
        if (list2.size() != 1 || !(list2.get(0) instanceof ReflectiveMethodResolver)) {
            return null;
        }
        CachedMethodExecutor cachedMethodExecutor = this.cachedExecutor;
        if (cachedMethodExecutor != null && cachedMethodExecutor.isSuitable(object, typeDescriptor, list)) {
            return cachedMethodExecutor.get();
        }
        this.cachedExecutor = null;
        return null;
    }

    private MethodExecutor findAccessorForMethod(List<TypeDescriptor> list, Object object, EvaluationContext evaluationContext) throws SpelEvaluationException {
        AccessException accessException = null;
        for (MethodResolver object22 : evaluationContext.getMethodResolvers()) {
            try {
                MethodExecutor accessException2 = object22.resolve(evaluationContext, object, this.name, list);
                if (accessException2 == null) continue;
                return accessException2;
            }
            catch (AccessException accessException2) {
                accessException = accessException2;
                break;
            }
        }
        String string = FormatHelper.formatMethodForMessage(this.name, list);
        String string2 = FormatHelper.formatClassNameForMessage(object instanceof Class ? (Class<?>)object : object.getClass());
        if (accessException != null) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)accessException, SpelMessage.PROBLEM_LOCATING_METHOD, string, string2);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_NOT_FOUND, string, string2);
    }

    private void throwSimpleExceptionIfPossible(Object object, AccessException accessException) {
        if (accessException.getCause() instanceof InvocationTargetException) {
            Throwable throwable = accessException.getCause().getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ExpressionInvocationTargetException(this.getStartPosition(), "A problem occurred when trying to execute method '" + this.name + "' on object of type [" + object.getClass().getName() + "]", throwable);
        }
    }

    private void updateExitTypeDescriptor() {
        CachedMethodExecutor cachedMethodExecutor = this.cachedExecutor;
        if (cachedMethodExecutor != null && cachedMethodExecutor.get() instanceof ReflectiveMethodExecutor) {
            Method method = ((ReflectiveMethodExecutor)cachedMethodExecutor.get()).getMethod();
            String string = CodeFlow.toDescriptor(method.getReturnType());
            if (this.nullSafe && CodeFlow.isPrimitive(string)) {
                this.originalPrimitiveExitTypeDescriptor = string;
                this.exitTypeDescriptor = CodeFlow.toBoxedDescriptor(string);
            } else {
                this.exitTypeDescriptor = string;
            }
        }
    }

    @Override
    public String toStringAST() {
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            stringJoiner.add(this.getChild(i2).toStringAST());
        }
        return this.name + stringJoiner;
    }

    @Override
    public boolean isCompilable() {
        CachedMethodExecutor cachedMethodExecutor = this.cachedExecutor;
        if (cachedMethodExecutor == null || cachedMethodExecutor.hasProxyTarget() || !(cachedMethodExecutor.get() instanceof ReflectiveMethodExecutor)) {
            return false;
        }
        for (SpelNodeImpl spelNodeImpl : this.children) {
            if (spelNodeImpl.isCompilable()) continue;
            return false;
        }
        ReflectiveMethodExecutor reflectiveMethodExecutor = (ReflectiveMethodExecutor)cachedMethodExecutor.get();
        if (reflectiveMethodExecutor.didArgumentConversionOccur()) {
            return false;
        }
        Class<?> clazz = reflectiveMethodExecutor.getMethod().getDeclaringClass();
        return Modifier.isPublic(clazz.getModifiers()) || reflectiveMethodExecutor.getPublicDeclaringClass() != null;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        Object object;
        CachedMethodExecutor cachedMethodExecutor = this.cachedExecutor;
        if (cachedMethodExecutor == null || !(cachedMethodExecutor.get() instanceof ReflectiveMethodExecutor)) {
            throw new IllegalStateException("No applicable cached executor found: " + cachedMethodExecutor);
        }
        ReflectiveMethodExecutor reflectiveMethodExecutor = (ReflectiveMethodExecutor)cachedMethodExecutor.get();
        Method method = reflectiveMethodExecutor.getMethod();
        boolean bl2 = Modifier.isStatic(method.getModifiers());
        String string = codeFlow.lastDescriptor();
        Label label = null;
        if (string == null && !bl2) {
            codeFlow.loadTarget(methodVisitor);
        }
        if ((string != null || !bl2) && this.nullSafe) {
            methodVisitor.visitInsn(89);
            label = new Label();
            object = new Label();
            methodVisitor.visitJumpInsn(199, (Label)object);
            CodeFlow.insertCheckCast(methodVisitor, this.exitTypeDescriptor);
            methodVisitor.visitJumpInsn(167, label);
            methodVisitor.visitLabel((Label)object);
        }
        if (string != null && bl2) {
            methodVisitor.visitInsn(87);
        }
        if (CodeFlow.isPrimitive(string)) {
            CodeFlow.insertBoxIfNecessary(methodVisitor, string.charAt(0));
        }
        if (Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            object = method.getDeclaringClass().getName().replace('.', '/');
        } else {
            Class<?> clazz = reflectiveMethodExecutor.getPublicDeclaringClass();
            Assert.state(clazz != null, "No public declaring class");
            object = clazz.getName().replace('.', '/');
        }
        if (!(bl2 || string != null && string.substring(1).equals(object))) {
            CodeFlow.insertCheckCast(methodVisitor, "L" + (String)object);
        }
        MethodReference.generateCodeForArguments(methodVisitor, codeFlow, method, this.children);
        methodVisitor.visitMethodInsn(bl2 ? 184 : (method.isDefault() ? 185 : 182), (String)object, method.getName(), CodeFlow.createSignatureDescriptor(method), method.getDeclaringClass().isInterface());
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
        if (this.originalPrimitiveExitTypeDescriptor != null) {
            CodeFlow.insertBoxIfNecessary(methodVisitor, this.originalPrimitiveExitTypeDescriptor);
        }
        if (label != null) {
            methodVisitor.visitLabel(label);
        }
    }

    private static class CachedMethodExecutor {
        private final MethodExecutor methodExecutor;
        private final Class<?> staticClass;
        private final TypeDescriptor target;
        private final List<TypeDescriptor> argumentTypes;

        public CachedMethodExecutor(MethodExecutor methodExecutor, Class<?> clazz, TypeDescriptor typeDescriptor, List<TypeDescriptor> list) {
            this.methodExecutor = methodExecutor;
            this.staticClass = clazz;
            this.target = typeDescriptor;
            this.argumentTypes = list;
        }

        public boolean isSuitable(Object object, TypeDescriptor typeDescriptor, List<TypeDescriptor> list) {
            return (this.staticClass == null || this.staticClass == object) && ObjectUtils.nullSafeEquals(this.target, typeDescriptor) && this.argumentTypes.equals(list);
        }

        public boolean hasProxyTarget() {
            return this.target != null && Proxy.isProxyClass(this.target.getType());
        }

        public MethodExecutor get() {
            return this.methodExecutor;
        }
    }

    private class MethodValueRef
    implements ValueRef {
        private final EvaluationContext evaluationContext;
        private final Object value;
        private final TypeDescriptor targetType;
        private final Object[] arguments;

        public MethodValueRef(ExpressionState expressionState, Object[] objectArray) {
            this.evaluationContext = expressionState.getEvaluationContext();
            this.value = expressionState.getActiveContextObject().getValue();
            this.targetType = expressionState.getActiveContextObject().getTypeDescriptor();
            this.arguments = objectArray;
        }

        @Override
        public TypedValue getValue() {
            TypedValue typedValue = MethodReference.this.getValueInternal(this.evaluationContext, this.value, this.targetType, this.arguments);
            MethodReference.this.updateExitTypeDescriptor();
            return typedValue;
        }

        @Override
        public void setValue(Object object) {
            throw new IllegalAccessError();
        }
    }
}

