package com.gradle.develocity.agent.maven.api;

import com.gradle.nullability.Nullable;
import org.apache.maven.execution.MavenSession;

/**
 * Allows to interact with the Develocity Maven extension.
 *
 * @since 1.21
 */
public interface DevelocityListener {

    /**
     * Allows configuring the Develocity Maven extension via the Develocity API. This callback is guaranteed to be taken into account by the Develocity Maven extension,
     * even in case of catastrophic build failures, such as a very early unexpected exception.
     *
     * @param api     the Develocity API
     * @param session the Maven session. Can be {@code null} in case of a very early error, before the Maven session is started
     */
    void configure(DevelocityApi api, @Nullable MavenSession session) throws Exception;

}
