package com.gradle.develocity.agent.maven.api.cache;

import javax.annotation.Nullable;

/**
 * Configures the credentials when accessing the remote build cache.
 * <p>
 * The specified values will take precedence over the values defined in the {@code develocity.xml}.
 *
 * @since 1.21
 */
public interface Credentials {

    /**
     * Gets the remote build cache username.
     *
     * @return the remote build cache username or {@code null}
     */
    @Nullable
    String getUsername();

    /**
     * Sets the remote build cache username.
     * <p>
     * Configuration via the {@code develocity.cache.remote.username} system property will always take precedence.
     *
     * @param username the remote build cache username or {@code null}
     */
    void setUsername(@Nullable String username);

    /**
     * Gets the remote build cache password.
     *
     * @return the remote build cache password or {@code null}
     */
    @Nullable
    String getPassword();

    /**
     * Sets the remote build cache password.
     * <p>
     * Configuration via the {@code develocity.cache.remote.password} system property will always take precedence.
     *
     * @param password the remote build cache password or {@code null}
     */
    void setPassword(@Nullable String password);

}
