package com.gradle.develocity.agent.maven.api.cache;

/**
 * Configures the remote build cache.
 * <p>
 * The specified values will take precedence over the values defined in the {@code develocity.xml}.
 *
 * @since 1.21
 */
public interface RemoteBuildCache {

    /**
     * Whether the remote build cache is enabled.
     *
     * @return {@code true} if the remote build cache is enabled, {@code false} otherwise
     */
    boolean isEnabled();

    /**
     * Sets whether to enable the remote build cache.
     * <p>
     * Configuration via the {@code develocity.cache.remote.enabled} system property will always take precedence.
     *
     * @param enabled whether to enable the remote build cache
     */
    void setEnabled(boolean enabled);

    /**
     * Whether storing build cache entries is enabled.
     *
     * @return {@code true} if storing build cache entries is enabled, {@code false} otherwise
     */
    boolean isStoreEnabled();

    /**
     * Sets whether to store build cache entries.
     * <p>
     * Configuration via the {@code develocity.cache.remote.storeEnabled} system property will always take precedence.
     *
     * @param storeEnabled whether to enable storing build cache entries
     */
    void setStoreEnabled(boolean storeEnabled);

    /**
     * Gets the server configuration.
     *
     * @return the server configuration
     */
    Server getServer();

}
