/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.DefaultPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;

public class DefaultChannelPromise
extends DefaultPromise<Void>
implements ChannelPromise {
    private final Channel channel;

    public DefaultChannelPromise(Channel channel) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    public DefaultChannelPromise(Channel channel, EventExecutor eventExecutor) {
        super(eventExecutor);
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    @Override
    protected EventExecutor executor() {
        EventExecutor eventExecutor = super.executor();
        if (eventExecutor == null) {
            return this.channel().eventLoop();
        }
        return eventExecutor;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPromise setSuccess() {
        return this.setSuccess(null);
    }

    @Override
    public ChannelPromise setSuccess(Void void_) {
        super.setSuccess(void_);
        return this;
    }

    @Override
    public boolean trySuccess() {
        return this.trySuccess(null);
    }

    @Override
    public ChannelPromise setFailure(Throwable throwable) {
        super.setFailure(throwable);
        return this;
    }

    @Override
    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        super.addListener(genericFutureListener);
        return this;
    }

    @Override
    public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        super.removeListener(genericFutureListener);
        return this;
    }

    @Override
    public ChannelPromise sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public ChannelPromise syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public ChannelPromise await() throws InterruptedException {
        super.await();
        return this;
    }

    public ChannelPromise awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    protected void checkDeadLock() {
        if (this.channel().isRegistered()) {
            super.checkDeadLock();
        }
    }

    @Override
    public ChannelPromise unvoid() {
        return this;
    }

    @Override
    public boolean isVoid() {
        return false;
    }
}

