/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.PemEncoded;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.PemValue;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;

public final class PemX509Certificate
extends X509Certificate
implements PemEncoded {
    private static final byte[] BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
    private static final byte[] END_CERT = "\n-----END CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
    private final ByteBuf content;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PemEncoded toPEM(ByteBufAllocator byteBufAllocator, boolean bl2, X509Certificate ... x509CertificateArray) throws CertificateEncodingException {
        X509Certificate x509Certificate;
        ObjectUtil.checkNonEmpty(x509CertificateArray, "chain");
        if (x509CertificateArray.length == 1 && (x509Certificate = x509CertificateArray[0]) instanceof PemEncoded) {
            return ((PemEncoded)((Object)x509Certificate)).retain();
        }
        boolean bl3 = false;
        ReferenceCounted referenceCounted = null;
        try {
            for (X509Certificate x509Certificate2 : x509CertificateArray) {
                if (x509Certificate2 == null) {
                    throw new IllegalArgumentException("Null element in chain: " + Arrays.toString(x509CertificateArray));
                }
                referenceCounted = x509Certificate2 instanceof PemEncoded ? PemX509Certificate.append(byteBufAllocator, bl2, (PemEncoded)((Object)x509Certificate2), x509CertificateArray.length, (ByteBuf)referenceCounted) : PemX509Certificate.append(byteBufAllocator, bl2, x509Certificate2, x509CertificateArray.length, (ByteBuf)referenceCounted);
            }
            PemValue pemValue = new PemValue((ByteBuf)referenceCounted, false);
            bl3 = true;
            PemValue pemValue2 = pemValue;
            return pemValue2;
        }
        finally {
            if (!bl3 && referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    private static ByteBuf append(ByteBufAllocator byteBufAllocator, boolean bl2, PemEncoded pemEncoded, int n2, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = pemEncoded.content();
        if (byteBuf == null) {
            byteBuf = PemX509Certificate.newBuffer(byteBufAllocator, bl2, byteBuf2.readableBytes() * n2);
        }
        byteBuf.writeBytes(byteBuf2.slice());
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf append(ByteBufAllocator byteBufAllocator, boolean bl2, X509Certificate x509Certificate, int n2, ByteBuf byteBuf) throws CertificateEncodingException {
        ByteBuf byteBuf2 = Unpooled.wrappedBuffer(x509Certificate.getEncoded());
        try {
            ByteBuf byteBuf3 = SslUtils.toBase64(byteBufAllocator, byteBuf2);
            try {
                if (byteBuf == null) {
                    byteBuf = PemX509Certificate.newBuffer(byteBufAllocator, bl2, (BEGIN_CERT.length + byteBuf3.readableBytes() + END_CERT.length) * n2);
                }
                byteBuf.writeBytes(BEGIN_CERT);
                byteBuf.writeBytes(byteBuf3);
                byteBuf.writeBytes(END_CERT);
            }
            finally {
                byteBuf3.release();
            }
        }
        finally {
            byteBuf2.release();
        }
        return byteBuf;
    }

    private static ByteBuf newBuffer(ByteBufAllocator byteBufAllocator, boolean bl2, int n2) {
        return bl2 ? byteBufAllocator.directBuffer(n2) : byteBufAllocator.buffer(n2);
    }

    @Override
    public boolean isSensitive() {
        return false;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public ByteBuf content() {
        int n2 = this.refCnt();
        if (n2 <= 0) {
            throw new IllegalReferenceCountException(n2);
        }
        return this.content;
    }

    @Override
    public PemX509Certificate retain() {
        this.content.retain();
        return this;
    }

    @Override
    public PemX509Certificate touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getExtensionValue(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkValidity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkValidity(Date date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getSerialNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal getIssuerDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal getSubjectDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getNotBefore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getNotAfter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getTBSCertificate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getSignature() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSigAlgName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSigAlgOID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getSigAlgParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getKeyUsage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBasicConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verify(PublicKey publicKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verify(PublicKey publicKey, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PublicKey getPublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PemX509Certificate)) {
            return false;
        }
        PemX509Certificate pemX509Certificate = (PemX509Certificate)object;
        return this.content.equals(pemX509Certificate.content);
    }

    @Override
    public int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public String toString() {
        return this.content.toString(CharsetUtil.UTF_8);
    }
}

