/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core;

import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.NativeDetector;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

final class SerializableTypeWrapper {
    private static final Class<?>[] SUPPORTED_SERIALIZABLE_TYPES = new Class[]{GenericArrayType.class, ParameterizedType.class, TypeVariable.class, WildcardType.class};
    static final ConcurrentReferenceHashMap<Type, Type> cache = new ConcurrentReferenceHashMap(256);

    public static <T extends Type> T unwrap(T t2) {
        Type type = null;
        if (t2 instanceof SerializableTypeProxy) {
            type = ((SerializableTypeProxy)((Object)t2)).getTypeProvider().getType();
        }
        return (T)(type != null ? type : (Type)t2);
    }

    static Type forTypeProvider(TypeProvider typeProvider) {
        Type type = typeProvider.getType();
        if (type == null || type instanceof Serializable) {
            return type;
        }
        if (NativeDetector.inNativeImage() || !Serializable.class.isAssignableFrom(Class.class)) {
            return type;
        }
        Type type2 = cache.get(type);
        if (type2 != null) {
            return type2;
        }
        for (Class<?> clazz : SUPPORTED_SERIALIZABLE_TYPES) {
            if (!clazz.isInstance(type)) continue;
            ClassLoader classLoader = typeProvider.getClass().getClassLoader();
            Class[] classArray = new Class[]{clazz, SerializableTypeProxy.class, Serializable.class};
            TypeProxyInvocationHandler typeProxyInvocationHandler = new TypeProxyInvocationHandler(typeProvider);
            type2 = (Type)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)typeProxyInvocationHandler);
            cache.put(type, type2);
            return type2;
        }
        throw new IllegalArgumentException("Unsupported Type class: " + type.getClass().getName());
    }

    static class MethodInvokeTypeProvider
    implements TypeProvider {
        private final TypeProvider provider;
        private final String methodName;
        private final Class<?> declaringClass;
        private final int index;
        private transient Method method;
        private volatile transient Object result;

        public MethodInvokeTypeProvider(TypeProvider typeProvider, Method method, int n2) {
            this.provider = typeProvider;
            this.methodName = method.getName();
            this.declaringClass = method.getDeclaringClass();
            this.index = n2;
            this.method = method;
        }

        @Override
        public Type getType() {
            Object object = this.result;
            if (object == null) {
                this.result = object = ReflectionUtils.invokeMethod(this.method, this.provider.getType());
            }
            return object instanceof Type[] ? ((Type[])object)[this.index] : (Type)object;
        }
    }

    static class MethodParameterTypeProvider
    implements TypeProvider {
        private final String methodName;
        private final Class<?>[] parameterTypes;
        private final Class<?> declaringClass;
        private final int parameterIndex;
        private transient MethodParameter methodParameter;

        public MethodParameterTypeProvider(MethodParameter methodParameter) {
            this.methodName = methodParameter.getMethod() != null ? methodParameter.getMethod().getName() : null;
            this.parameterTypes = methodParameter.getExecutable().getParameterTypes();
            this.declaringClass = methodParameter.getDeclaringClass();
            this.parameterIndex = methodParameter.getParameterIndex();
            this.methodParameter = methodParameter;
        }

        @Override
        public Type getType() {
            return this.methodParameter.getGenericParameterType();
        }
    }

    static class FieldTypeProvider
    implements TypeProvider {
        private final String fieldName;
        private final Class<?> declaringClass;
        private transient Field field;

        public FieldTypeProvider(Field field) {
            this.fieldName = field.getName();
            this.declaringClass = field.getDeclaringClass();
            this.field = field;
        }

        @Override
        public Type getType() {
            return this.field.getGenericType();
        }
    }

    private static class TypeProxyInvocationHandler
    implements Serializable,
    InvocationHandler {
        private final TypeProvider provider;

        public TypeProxyInvocationHandler(TypeProvider typeProvider) {
            this.provider = typeProvider;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    Object object2 = objectArray[0];
                    if (object2 instanceof Type) {
                        object2 = SerializableTypeWrapper.unwrap((Type)object2);
                    }
                    return ObjectUtils.nullSafeEquals(this.provider.getType(), object2);
                }
                case "hashCode": {
                    return ObjectUtils.nullSafeHashCode(this.provider.getType());
                }
                case "getTypeProvider": {
                    return this.provider;
                }
            }
            if (Type.class == method.getReturnType() && ObjectUtils.isEmpty(objectArray)) {
                return SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, -1));
            }
            if (Type[].class == method.getReturnType() && ObjectUtils.isEmpty(objectArray)) {
                Object object3 = ReflectionUtils.invokeMethod(method, this.provider.getType());
                if (object3 == null) {
                    return null;
                }
                Type[] typeArray = new Type[((Type[])object3).length];
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    typeArray[i2] = SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, i2));
                }
                return typeArray;
            }
            return ReflectionUtils.invokeMethod(method, this.provider.getType(), objectArray);
        }
    }

    static interface TypeProvider
    extends Serializable {
        public Type getType();
    }

    static interface SerializableTypeProxy {
        public TypeProvider getTypeProvider();
    }
}

