/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.InputConfigFlags;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ParsingErrorMsgs;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.MinimalDTDReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.ent.EntityDecl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.ent.IntEntity;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxEOFException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxLazyException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxParsingException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxUnexpectedCharException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxValidationException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.DefaultInputResolver;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputData;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputLocation;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputSource;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputProblemReporter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ExceptionUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.SymbolTable;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.TextBuffer;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLReporter2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamLocation2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationProblem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;

public abstract class StreamScanner
extends WstxInputData
implements InputConfigFlags,
ParsingErrorMsgs,
InputProblemReporter {
    public static final char CHAR_CR_LF_OR_NULL = '\r';
    public static final int INT_CR_LF_OR_NULL = 13;
    protected static final char CHAR_FIRST_PURE_TEXT = '?';
    protected static final char CHAR_LOWEST_LEGAL_LOCALNAME_CHAR = '-';
    private static final int VALID_CHAR_COUNT = 256;
    private static final byte NAME_CHAR_INVALID_B = 0;
    private static final byte NAME_CHAR_ALL_VALID_B = 1;
    private static final byte NAME_CHAR_VALID_NONFIRST_B = -1;
    private static final byte[] sCharValidity;
    private static final int VALID_PUBID_CHAR_COUNT = 128;
    private static final byte[] sPubidValidity;
    private static final byte PUBID_CHAR_VALID_B = 1;
    protected final ReaderConfig mConfig;
    protected final boolean mCfgNsEnabled;
    protected boolean mCfgReplaceEntities;
    final SymbolTable mSymbols;
    protected String mCurrName;
    protected WstxInputSource mInput;
    protected final WstxInputSource mRootInput;
    protected XMLResolver mEntityResolver = null;
    protected int mCurrDepth;
    protected int mInputTopDepth;
    protected int mEntityExpansionCount;
    protected boolean mNormalizeLFs;
    protected boolean mAllowXml11EscapedCharsInXml10;
    protected char[] mNameBuffer = null;
    protected long mTokenInputTotal = 0L;
    protected int mTokenInputRow = 1;
    protected int mTokenInputCol = 0;
    protected String mDocInputEncoding = null;
    protected String mDocXmlEncoding = null;
    protected int mDocXmlVersion = 0;
    protected Map<String, IntEntity> mCachedEntities;
    protected boolean mCfgTreatCharRefsAsEntities;
    protected EntityDecl mCurrEntity;

    protected StreamScanner(WstxInputSource wstxInputSource, ReaderConfig readerConfig, XMLResolver xMLResolver) {
        this.mInput = wstxInputSource;
        this.mRootInput = wstxInputSource;
        this.mConfig = readerConfig;
        this.mSymbols = readerConfig.getSymbols();
        int n2 = readerConfig.getConfigFlags();
        this.mCfgNsEnabled = (n2 & 1) != 0;
        this.mCfgReplaceEntities = (n2 & 4) != 0;
        this.mAllowXml11EscapedCharsInXml10 = this.mConfig.willAllowXml11EscapedCharsInXml10();
        this.mNormalizeLFs = this.mConfig.willNormalizeLFs();
        this.mInputBuffer = null;
        this.mInputEnd = 0;
        this.mInputPtr = 0;
        this.mEntityResolver = xMLResolver;
        this.mCfgTreatCharRefsAsEntities = this.mConfig.willTreatCharRefsAsEnts();
        this.mCachedEntities = this.mCfgTreatCharRefsAsEntities ? new HashMap<String, IntEntity>() : Collections.emptyMap();
    }

    public ReaderConfig getConfig() {
        return this.mConfig;
    }

    protected WstxInputLocation getLastCharLocation() {
        return this.mInput.getLocation(this.mCurrInputProcessed + (long)this.mInputPtr - 1L, this.mCurrInputRow, this.mInputPtr - this.mCurrInputRowStart);
    }

    protected URL getSource() throws IOException {
        return this.mInput.getSource();
    }

    protected String getSystemId() {
        return this.mInput.getSystemId();
    }

    @Override
    public abstract Location getLocation();

    public XMLStreamLocation2 getStartLocation() {
        return this.mInput.getLocation(this.mTokenInputTotal, this.mTokenInputRow, this.mTokenInputCol + 1);
    }

    public XMLStreamLocation2 getCurrentLocation() {
        return this.mInput.getLocation(this.mCurrInputProcessed + (long)this.mInputPtr, this.mCurrInputRow, this.mInputPtr - this.mCurrInputRowStart + 1);
    }

    public WstxException throwWfcException(String string, boolean bl2) throws WstxException {
        WstxException wstxException = this.constructWfcException(string);
        if (!bl2) {
            throw wstxException;
        }
        return wstxException;
    }

    @Override
    public void throwParseError(String string) throws XMLStreamException {
        this.throwParseError(string, null, null);
    }

    @Override
    public void throwParseError(String string, Object object, Object object2) throws XMLStreamException {
        String string2 = object == null && object2 == null ? string : MessageFormat.format(string, object, object2);
        throw this.constructWfcException(string2);
    }

    public void reportProblem(String string, String string2, Object object, Object object2) throws XMLStreamException {
        XMLReporter xMLReporter = this.mConfig.getXMLReporter();
        if (xMLReporter != null) {
            this._reportProblem(xMLReporter, string, MessageFormat.format(string2, object, object2), null);
        }
    }

    @Override
    public void reportProblem(Location location, String string, String string2, Object object, Object object2) throws XMLStreamException {
        XMLReporter xMLReporter = this.mConfig.getXMLReporter();
        if (xMLReporter != null) {
            String string3 = object != null || object2 != null ? MessageFormat.format(string2, object, object2) : string2;
            this._reportProblem(xMLReporter, string, string3, location);
        }
    }

    protected void _reportProblem(XMLReporter xMLReporter, String string, String string2, Location location) throws XMLStreamException {
        if (location == null) {
            location = this.getLastCharLocation();
        }
        this._reportProblem(xMLReporter, new XMLValidationProblem(location, string2, 2, string));
    }

    protected void _reportProblem(XMLReporter xMLReporter, XMLValidationProblem xMLValidationProblem) throws XMLStreamException {
        if (xMLReporter != null) {
            Location location = xMLValidationProblem.getLocation();
            if (location == null) {
                location = this.getLastCharLocation();
                xMLValidationProblem.setLocation(location);
            }
            if (xMLValidationProblem.getType() == null) {
                xMLValidationProblem.setType(ErrorConsts.WT_VALIDATION);
            }
            if (xMLReporter instanceof XMLReporter2) {
                ((XMLReporter2)xMLReporter).report(xMLValidationProblem);
            } else {
                xMLReporter.report(xMLValidationProblem.getMessage(), xMLValidationProblem.getType(), xMLValidationProblem, location);
            }
        }
    }

    @Override
    public void reportValidationProblem(XMLValidationProblem xMLValidationProblem) throws XMLStreamException {
        if (xMLValidationProblem.getSeverity() > 2) {
            throw WstxValidationException.create(xMLValidationProblem);
        }
        XMLReporter xMLReporter = this.mConfig.getXMLReporter();
        if (xMLReporter != null) {
            this._reportProblem(xMLReporter, xMLValidationProblem);
        } else if (xMLValidationProblem.getSeverity() >= 2) {
            throw WstxValidationException.create(xMLValidationProblem);
        }
    }

    public void reportValidationProblem(String string, int n2) throws XMLStreamException {
        this.reportValidationProblem(new XMLValidationProblem(this.getLastCharLocation(), string, n2));
    }

    @Override
    public void reportValidationProblem(String string) throws XMLStreamException {
        this.reportValidationProblem(new XMLValidationProblem(this.getLastCharLocation(), string, 2));
    }

    public void reportValidationProblem(Location location, String string) throws XMLStreamException {
        this.reportValidationProblem(new XMLValidationProblem(location, string));
    }

    @Override
    public void reportValidationProblem(String string, Object object, Object object2) throws XMLStreamException {
        this.reportValidationProblem(MessageFormat.format(string, object, object2));
    }

    protected WstxException constructWfcException(String string) {
        return new WstxParsingException(string, this.getLastCharLocation());
    }

    protected WstxException constructFromIOE(IOException iOException) {
        return new WstxIOException(iOException);
    }

    protected WstxException constructNullCharException() {
        return new WstxUnexpectedCharException("Illegal character (NULL, unicode 0) encountered: not valid in any content", (Location)this.getLastCharLocation(), '\u0000');
    }

    protected void throwUnexpectedChar(int n2, String string) throws WstxException {
        char c2 = (char)n2;
        String string2 = "Unexpected character " + StreamScanner.getCharDesc(c2) + string;
        throw new WstxUnexpectedCharException(string2, (Location)this.getLastCharLocation(), c2);
    }

    protected void throwNullChar() throws WstxException {
        throw this.constructNullCharException();
    }

    protected void throwInvalidSpace(int n2) throws WstxException {
        this.throwInvalidSpace(n2, false);
    }

    protected WstxException throwInvalidSpace(int n2, boolean bl2) throws WstxException {
        WstxException wstxException;
        char c2 = (char)n2;
        if (c2 == '\u0000') {
            wstxException = this.constructNullCharException();
        } else {
            String string = "Illegal character (" + StreamScanner.getCharDesc(c2) + ")";
            if (this.mXml11) {
                string = string + " [note: in XML 1.1, it could be included via entity expansion]";
            }
            wstxException = new WstxUnexpectedCharException(string, (Location)this.getLastCharLocation(), c2);
        }
        if (!bl2) {
            throw wstxException;
        }
        return wstxException;
    }

    protected void throwUnexpectedEOF(String string) throws WstxException {
        throw new WstxEOFException("Unexpected EOF" + (string == null ? "" : string), this.getLastCharLocation());
    }

    protected void throwUnexpectedEOB(String string) throws WstxException {
        throw new WstxEOFException("Unexpected end of input block" + (string == null ? "" : string), this.getLastCharLocation());
    }

    protected void throwFromIOE(IOException iOException) throws WstxException {
        throw new WstxIOException(iOException);
    }

    protected void throwFromStrE(XMLStreamException xMLStreamException) throws WstxException {
        if (xMLStreamException instanceof WstxException) {
            throw (WstxException)xMLStreamException;
        }
        throw new WstxException(xMLStreamException);
    }

    protected void throwLazyError(Exception exception) {
        if (exception instanceof XMLStreamException) {
            WstxLazyException.throwLazily((XMLStreamException)exception);
        }
        ExceptionUtil.throwRuntimeException(exception);
    }

    protected String tokenTypeDesc(int n2) {
        return ErrorConsts.tokenTypeDesc(n2);
    }

    public final WstxInputSource getCurrentInput() {
        return this.mInput;
    }

    protected final int inputInBuffer() {
        return this.mInputEnd - this.mInputPtr;
    }

    protected final int getNext() throws XMLStreamException {
        if (this.mInputPtr >= this.mInputEnd && !this.loadMore()) {
            return -1;
        }
        return this.mInputBuffer[this.mInputPtr++];
    }

    protected final int peekNext() throws XMLStreamException {
        if (this.mInputPtr >= this.mInputEnd && !this.loadMoreFromCurrent()) {
            return -1;
        }
        return this.mInputBuffer[this.mInputPtr];
    }

    protected final char getNextChar(String string) throws XMLStreamException {
        if (this.mInputPtr >= this.mInputEnd) {
            this.loadMore(string);
        }
        return this.mInputBuffer[this.mInputPtr++];
    }

    protected final char getNextCharFromCurrent(String string) throws XMLStreamException {
        if (this.mInputPtr >= this.mInputEnd) {
            this.loadMoreFromCurrent(string);
        }
        return this.mInputBuffer[this.mInputPtr++];
    }

    protected final int getNextAfterWS() throws XMLStreamException {
        if (this.mInputPtr >= this.mInputEnd && !this.loadMore()) {
            return -1;
        }
        char c2 = this.mInputBuffer[this.mInputPtr++];
        while (c2 <= ' ') {
            if (c2 == '\n' || c2 == '\r') {
                this.skipCRLF(c2);
            } else if (c2 != ' ' && c2 != '\t') {
                this.throwInvalidSpace(c2);
            }
            if (this.mInputPtr >= this.mInputEnd && !this.loadMore()) {
                return -1;
            }
            c2 = this.mInputBuffer[this.mInputPtr++];
        }
        return c2;
    }

    protected final char getNextCharAfterWS(String string) throws XMLStreamException {
        if (this.mInputPtr >= this.mInputEnd) {
            this.loadMore(string);
        }
        char c2 = this.mInputBuffer[this.mInputPtr++];
        while (c2 <= ' ') {
            if (c2 == '\n' || c2 == '\r') {
                this.skipCRLF(c2);
            } else if (c2 != ' ' && c2 != '\t') {
                this.throwInvalidSpace(c2);
            }
            if (this.mInputPtr >= this.mInputEnd) {
                this.loadMore(string);
            }
            c2 = this.mInputBuffer[this.mInputPtr++];
        }
        return c2;
    }

    protected final char getNextInCurrAfterWS(String string) throws XMLStreamException {
        return this.getNextInCurrAfterWS(string, this.getNextCharFromCurrent(string));
    }

    protected final char getNextInCurrAfterWS(String string, char c2) throws XMLStreamException {
        while (c2 <= ' ') {
            if (c2 == '\n' || c2 == '\r') {
                this.skipCRLF(c2);
            } else if (c2 != ' ' && c2 != '\t') {
                this.throwInvalidSpace(c2);
            }
            if (this.mInputPtr >= this.mInputEnd) {
                this.loadMoreFromCurrent(string);
            }
            c2 = this.mInputBuffer[this.mInputPtr++];
        }
        return c2;
    }

    protected final boolean skipCRLF(char c2) throws XMLStreamException {
        boolean bl2;
        if (c2 == '\r' && this.peekNext() == 10) {
            ++this.mInputPtr;
            bl2 = true;
        } else {
            bl2 = false;
        }
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = this.mInputPtr;
        return bl2;
    }

    protected final void markLF() {
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = this.mInputPtr;
    }

    protected final void markLF(int n2) {
        ++this.mCurrInputRow;
        this.mCurrInputRowStart = n2;
    }

    protected final void pushback() {
        --this.mInputPtr;
    }

    protected void initInputSource(WstxInputSource wstxInputSource, boolean bl2, String string) throws XMLStreamException {
        this.mInputPtr = 0;
        this.mInputEnd = 0;
        this.mInputTopDepth = this.mCurrDepth;
        int n2 = this.mInput.getEntityDepth() + 1;
        this.verifyLimit("Maximum entity expansion depth", this.mConfig.getMaxEntityDepth(), n2);
        this.mInput = wstxInputSource;
        this.mInput.initInputLocation(this, this.mCurrDepth, n2);
        this.mNormalizeLFs = bl2;
    }

    protected boolean loadMore() throws XMLStreamException {
        WstxInputSource wstxInputSource = this.mInput;
        do {
            this.mCurrInputProcessed += (long)this.mInputEnd;
            this.verifyLimit("Maximum document characters", this.mConfig.getMaxCharacters(), this.mCurrInputProcessed);
            this.mCurrInputRowStart -= this.mInputEnd;
            try {
                int n2 = wstxInputSource.readInto(this);
                if (n2 > 0) {
                    return true;
                }
                wstxInputSource.close();
            }
            catch (IOException iOException) {
                throw this.constructFromIOE(iOException);
            }
            if (wstxInputSource == this.mRootInput) {
                return false;
            }
            WstxInputSource wstxInputSource2 = wstxInputSource.getParent();
            if (wstxInputSource2 == null) {
                this.throwNullParent(wstxInputSource);
            }
            if (this.mCurrDepth != wstxInputSource.getScopeId()) {
                this.handleIncompleteEntityProblem(wstxInputSource);
            }
            this.mInput = wstxInputSource = wstxInputSource2;
            wstxInputSource.restoreContext(this);
            this.mInputTopDepth = wstxInputSource.getScopeId();
            if (this.mNormalizeLFs) continue;
            boolean bl2 = this.mNormalizeLFs = !wstxInputSource.fromInternalEntity();
        } while (this.mInputPtr >= this.mInputEnd);
        return true;
    }

    protected final boolean loadMore(String string) throws XMLStreamException {
        if (!this.loadMore()) {
            this.throwUnexpectedEOF(string);
        }
        return true;
    }

    protected boolean loadMoreFromCurrent() throws XMLStreamException {
        this.mCurrInputProcessed += (long)this.mInputEnd;
        this.mCurrInputRowStart -= this.mInputEnd;
        this.verifyLimit("Maximum document characters", this.mConfig.getMaxCharacters(), this.mCurrInputProcessed);
        try {
            int n2 = this.mInput.readInto(this);
            return n2 > 0;
        }
        catch (IOException iOException) {
            throw this.constructFromIOE(iOException);
        }
    }

    protected final boolean loadMoreFromCurrent(String string) throws XMLStreamException {
        if (!this.loadMoreFromCurrent()) {
            this.throwUnexpectedEOB(string);
        }
        return true;
    }

    protected boolean ensureInput(int n2) throws XMLStreamException {
        int n3 = this.mInputEnd - this.mInputPtr;
        if (n3 >= n2) {
            return true;
        }
        try {
            return this.mInput.readMore(this, n2);
        }
        catch (IOException iOException) {
            throw this.constructFromIOE(iOException);
        }
    }

    protected void closeAllInput(boolean bl2) throws XMLStreamException {
        WstxInputSource wstxInputSource = this.mInput;
        while (true) {
            try {
                if (bl2) {
                    wstxInputSource.closeCompletely();
                } else {
                    wstxInputSource.close();
                }
            }
            catch (IOException iOException) {
                throw this.constructFromIOE(iOException);
            }
            if (wstxInputSource == this.mRootInput) break;
            WstxInputSource wstxInputSource2 = wstxInputSource.getParent();
            if (wstxInputSource2 == null) {
                this.throwNullParent(wstxInputSource);
            }
            this.mInput = wstxInputSource = wstxInputSource2;
        }
    }

    protected void throwNullParent(WstxInputSource wstxInputSource) {
        throw new IllegalStateException(ErrorConsts.ERR_INTERNAL);
    }

    protected int resolveSimpleEntity(boolean bl2) throws XMLStreamException {
        char c2;
        char[] cArray = this.mInputBuffer;
        int n2 = this.mInputPtr;
        if ((c2 = cArray[n2++]) == '#') {
            c2 = cArray[n2++];
            int n3 = 0;
            int n4 = this.mInputEnd;
            if (c2 == 'x') {
                while (n2 < n4 && (c2 = cArray[n2++]) != ';') {
                    n3 <<= 4;
                    if (c2 <= '9' && c2 >= '0') {
                        n3 += c2 - 48;
                    } else if (c2 >= 'a' && c2 <= 'f') {
                        n3 += 10 + (c2 - 97);
                    } else if (c2 >= 'A' && c2 <= 'F') {
                        n3 += 10 + (c2 - 65);
                    } else {
                        this.mInputPtr = n2;
                        this.throwUnexpectedChar(c2, "; expected a hex digit (0-9a-fA-F).");
                    }
                    if (n3 <= 0x10FFFF) continue;
                    this.reportUnicodeOverflow();
                }
            } else {
                while (c2 != ';') {
                    if (c2 <= '9' && c2 >= '0') {
                        if ((n3 = n3 * 10 + (c2 - 48)) > 0x10FFFF) {
                            this.reportUnicodeOverflow();
                        }
                    } else {
                        this.mInputPtr = n2;
                        this.throwUnexpectedChar(c2, "; expected a decimal number.");
                    }
                    if (n2 < n4) {
                        c2 = cArray[n2++];
                        continue;
                    }
                    break;
                }
            }
            if (c2 == ';') {
                this.mInputPtr = n2;
                this.validateChar(n3);
                return n3;
            }
        } else if (bl2) {
            int n5;
            if (c2 == 'a') {
                int n6;
                if ((c2 = cArray[n2++]) == 'm') {
                    if (cArray[n2++] == 'p' && n2 < this.mInputEnd && cArray[n2++] == ';') {
                        this.mInputPtr = n2;
                        return 38;
                    }
                } else if (c2 == 'p' && cArray[n2++] == 'o' && n2 < (n6 = this.mInputEnd) && cArray[n2++] == 's' && n2 < n6 && cArray[n2++] == ';') {
                    this.mInputPtr = n2;
                    return 39;
                }
            } else if (c2 == 'g') {
                if (cArray[n2++] == 't' && cArray[n2++] == ';') {
                    this.mInputPtr = n2;
                    return 62;
                }
            } else if (c2 == 'l') {
                if (cArray[n2++] == 't' && cArray[n2++] == ';') {
                    this.mInputPtr = n2;
                    return 60;
                }
            } else if (c2 == 'q' && cArray[n2++] == 'u' && cArray[n2++] == 'o' && n2 < (n5 = this.mInputEnd) && cArray[n2++] == 't' && n2 < n5 && cArray[n2++] == ';') {
                this.mInputPtr = n2;
                return 34;
            }
        }
        return 0;
    }

    protected int resolveCharOnlyEntity(boolean bl2) throws XMLStreamException {
        char c2;
        int n2 = this.mInputEnd - this.mInputPtr;
        if (n2 < 6) {
            --this.mInputPtr;
            if (!this.ensureInput(6)) {
                n2 = this.inputInBuffer();
                if (n2 < 3) {
                    this.throwUnexpectedEOF(" in entity reference");
                }
            } else {
                n2 = 6;
            }
            ++this.mInputPtr;
        }
        if ((c2 = this.mInputBuffer[this.mInputPtr]) == '#') {
            ++this.mInputPtr;
            return this.resolveCharEnt(null);
        }
        if (bl2) {
            if (c2 == 'a') {
                char c3 = this.mInputBuffer[this.mInputPtr + 1];
                if (c3 == 'm') {
                    if (n2 >= 4 && this.mInputBuffer[this.mInputPtr + 2] == 'p' && this.mInputBuffer[this.mInputPtr + 3] == ';') {
                        this.mInputPtr += 4;
                        return 38;
                    }
                } else if (c3 == 'p' && n2 >= 5 && this.mInputBuffer[this.mInputPtr + 2] == 'o' && this.mInputBuffer[this.mInputPtr + 3] == 's' && this.mInputBuffer[this.mInputPtr + 4] == ';') {
                    this.mInputPtr += 5;
                    return 39;
                }
            } else if (c2 == 'l') {
                if (this.mInputBuffer[this.mInputPtr + 1] == 't' && this.mInputBuffer[this.mInputPtr + 2] == ';') {
                    this.mInputPtr += 3;
                    return 60;
                }
            } else if (c2 == 'g') {
                if (this.mInputBuffer[this.mInputPtr + 1] == 't' && this.mInputBuffer[this.mInputPtr + 2] == ';') {
                    this.mInputPtr += 3;
                    return 62;
                }
            } else if (c2 == 'q' && n2 >= 5 && this.mInputBuffer[this.mInputPtr + 1] == 'u' && this.mInputBuffer[this.mInputPtr + 2] == 'o' && this.mInputBuffer[this.mInputPtr + 3] == 't' && this.mInputBuffer[this.mInputPtr + 4] == ';') {
                this.mInputPtr += 5;
                return 34;
            }
        }
        return 0;
    }

    protected EntityDecl resolveNonCharEntity() throws XMLStreamException {
        String string;
        char c2;
        char c3;
        int n2 = this.mInputEnd - this.mInputPtr;
        if (n2 < 6) {
            --this.mInputPtr;
            if (!this.ensureInput(6)) {
                n2 = this.inputInBuffer();
                if (n2 < 3) {
                    this.throwUnexpectedEOF(" in entity reference");
                }
            } else {
                n2 = 6;
            }
            ++this.mInputPtr;
        }
        if ((c3 = this.mInputBuffer[this.mInputPtr]) == '#') {
            return null;
        }
        if (c3 == 'a' ? ((c2 = this.mInputBuffer[this.mInputPtr + 1]) == 'm' ? n2 >= 4 && this.mInputBuffer[this.mInputPtr + 2] == 'p' && this.mInputBuffer[this.mInputPtr + 3] == ';' : c2 == 'p' && n2 >= 5 && this.mInputBuffer[this.mInputPtr + 2] == 'o' && this.mInputBuffer[this.mInputPtr + 3] == 's' && this.mInputBuffer[this.mInputPtr + 4] == ';') : (c3 == 'l' ? this.mInputBuffer[this.mInputPtr + 1] == 't' && this.mInputBuffer[this.mInputPtr + 2] == ';' : (c3 == 'g' ? this.mInputBuffer[this.mInputPtr + 1] == 't' && this.mInputBuffer[this.mInputPtr + 2] == ';' : c3 == 'q' && n2 >= 5 && this.mInputBuffer[this.mInputPtr + 1] == 'u' && this.mInputBuffer[this.mInputPtr + 2] == 'o' && this.mInputBuffer[this.mInputPtr + 3] == 't' && this.mInputBuffer[this.mInputPtr + 4] == ';'))) {
            return null;
        }
        ++this.mInputPtr;
        this.mCurrName = string = this.parseEntityName(c3);
        return this.findEntity(string, null);
    }

    protected int fullyResolveEntity(boolean bl2) throws XMLStreamException {
        char c2 = this.getNextCharFromCurrent(" in entity reference");
        if (c2 == '#') {
            StringBuffer stringBuffer = new StringBuffer("#");
            int n2 = this.resolveCharEnt(stringBuffer);
            if (this.mCfgTreatCharRefsAsEntities) {
                char[] cArray = new char[stringBuffer.length()];
                stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
                this.mCurrEntity = this.getIntEntity(n2, cArray);
                return 0;
            }
            return n2;
        }
        String string = this.parseEntityName(c2);
        c2 = string.charAt(0);
        int n3 = 0;
        if (c2 == 'a') {
            if (string.equals("amp")) {
                n3 = 38;
            } else if (string.equals("apos")) {
                n3 = 39;
            }
        } else if (c2 == 'g') {
            if (string.length() == 2 && string.charAt(1) == 't') {
                n3 = 62;
            }
        } else if (c2 == 'l') {
            if (string.length() == 2 && string.charAt(1) == 't') {
                n3 = 60;
            }
        } else if (c2 == 'q' && string.equals("quot")) {
            n3 = 34;
        }
        if (n3 != 0) {
            if (this.mCfgTreatCharRefsAsEntities) {
                char[] cArray = new char[string.length()];
                string.getChars(0, string.length(), cArray, 0);
                this.mCurrEntity = this.getIntEntity(n3, cArray);
                return 0;
            }
            return n3;
        }
        EntityDecl entityDecl = this.expandEntity(string, bl2, null);
        if (this.mCfgTreatCharRefsAsEntities) {
            this.mCurrEntity = entityDecl;
        }
        return 0;
    }

    protected EntityDecl getIntEntity(int n2, char[] cArray) {
        String string = new String(cArray);
        IntEntity intEntity = this.mCachedEntities.get(string);
        if (intEntity == null) {
            String string2;
            if (n2 <= 65535) {
                string2 = Character.toString((char)n2);
            } else {
                StringBuffer stringBuffer = new StringBuffer(2);
                stringBuffer.append((char)(((n2 -= 65536) >> 10) + 55296));
                stringBuffer.append((char)((n2 & 0x3FF) + 56320));
                string2 = stringBuffer.toString();
            }
            intEntity = IntEntity.create(new String(cArray), string2);
            this.mCachedEntities.put(string, intEntity);
        }
        return intEntity;
    }

    protected EntityDecl expandEntity(String string, boolean bl2, Object object) throws XMLStreamException {
        this.mCurrName = string;
        EntityDecl entityDecl = this.findEntity(string, object);
        if (entityDecl == null) {
            if (this.mCfgReplaceEntities) {
                this.mCurrEntity = this.expandUnresolvedEntity(string);
            }
            return null;
        }
        if (!this.mCfgTreatCharRefsAsEntities || this instanceof MinimalDTDReader) {
            this.expandEntity(entityDecl, bl2);
        }
        return entityDecl;
    }

    private void expandEntity(EntityDecl entityDecl, boolean bl2) throws XMLStreamException {
        boolean bl3;
        String string = entityDecl.getName();
        if (this.mInput.isOrIsExpandedFrom(string)) {
            this.throwRecursionError(string);
        }
        if (!entityDecl.isParsed()) {
            this.throwParseError("Illegal reference to unparsed external entity \"{0}\"", string, null);
        }
        if (bl3 = entityDecl.isExternal()) {
            if (!bl2) {
                this.throwParseError("Encountered a reference to external parsed entity \"{0}\" when expanding attribute value: not legal as per XML 1.0/1.1 #3.1", string, null);
            }
            if (!this.mConfig.willSupportExternalEntities()) {
                this.throwParseError("Encountered a reference to external entity \"{0}\", but stream reader has feature \"{1}\" disabled", string, "javax.xml.stream.isSupportingExternalEntities");
            }
        }
        this.verifyLimit("Maximum entity expansion count", this.mConfig.getMaxEntityCount(), ++this.mEntityExpansionCount);
        WstxInputSource wstxInputSource = this.mInput;
        wstxInputSource.saveContext(this);
        WstxInputSource wstxInputSource2 = null;
        try {
            wstxInputSource2 = entityDecl.expand(wstxInputSource, this.mEntityResolver, this.mConfig, this.mDocXmlVersion);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.throwParseError("(was {0}) {1}", fileNotFoundException.getClass().getName(), fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw this.constructFromIOE(iOException);
        }
        this.initInputSource(wstxInputSource2, bl3, string);
    }

    private EntityDecl expandUnresolvedEntity(String string) throws XMLStreamException {
        XMLResolver xMLResolver = this.mConfig.getUndeclaredEntityResolver();
        if (xMLResolver != null) {
            WstxInputSource wstxInputSource;
            if (this.mInput.isOrIsExpandedFrom(string)) {
                this.throwRecursionError(string);
            }
            WstxInputSource wstxInputSource2 = this.mInput;
            wstxInputSource2.saveContext(this);
            int n2 = this.mDocXmlVersion;
            if (n2 == 0) {
                n2 = 256;
            }
            try {
                wstxInputSource = DefaultInputResolver.resolveEntityUsing(wstxInputSource2, string, null, null, xMLResolver, this.mConfig, n2);
                if (this.mCfgTreatCharRefsAsEntities) {
                    return new IntEntity(WstxInputLocation.getEmptyLocation(), wstxInputSource.getEntityId(), wstxInputSource.getSource(), new char[0], WstxInputLocation.getEmptyLocation());
                }
            }
            catch (IOException iOException) {
                throw this.constructFromIOE(iOException);
            }
            if (wstxInputSource != null) {
                this.initInputSource(wstxInputSource, true, string);
                return null;
            }
        }
        this.handleUndeclaredEntity(string);
        return null;
    }

    protected abstract EntityDecl findEntity(String var1, Object var2) throws XMLStreamException;

    protected abstract void handleUndeclaredEntity(String var1) throws XMLStreamException;

    protected abstract void handleIncompleteEntityProblem(WstxInputSource var1) throws XMLStreamException;

    protected String parseLocalName(char n2) throws XMLStreamException {
        if (!this.isNameStartChar((char)n2)) {
            if (n2 == 58) {
                this.throwUnexpectedChar(n2, " (missing namespace prefix?)");
            }
            this.throwUnexpectedChar(n2, " (expected a name start character)");
        }
        int n3 = this.mInputPtr;
        int n4 = n2;
        int n5 = this.mInputEnd;
        int n6 = n3 - 1;
        char[] cArray = this.mInputBuffer;
        while (true) {
            if (n3 >= n5) {
                this.mInputPtr = n3;
                return this.parseLocalName2(n6, n4);
            }
            n2 = cArray[n3];
            if (n2 < 45 || !this.isNameChar((char)n2)) break;
            n4 = n4 * 31 + n2;
            ++n3;
        }
        this.mInputPtr = n3;
        return this.mSymbols.findSymbol(this.mInputBuffer, n6, n3 - n6, n4);
    }

    protected String parseLocalName2(int n2, int n3) throws XMLStreamException {
        char c2;
        int n4 = this.mInputEnd - n2;
        char[] cArray = this.getNameBuffer(n4 + 8);
        if (n4 > 0) {
            System.arraycopy(this.mInputBuffer, n2, cArray, 0, n4);
        }
        int n5 = cArray.length;
        while ((this.mInputPtr < this.mInputEnd || this.loadMoreFromCurrent()) && (c2 = this.mInputBuffer[this.mInputPtr]) >= '-' && this.isNameChar(c2)) {
            ++this.mInputPtr;
            if (n4 >= n5) {
                cArray = this.expandBy50Pct(cArray);
                this.mNameBuffer = cArray;
                n5 = cArray.length;
            }
            cArray[n4++] = c2;
            n3 = n3 * 31 + c2;
        }
        return this.mSymbols.findSymbol(cArray, 0, n4, n3);
    }

    protected String parseFullName() throws XMLStreamException {
        if (this.mInputPtr >= this.mInputEnd) {
            this.loadMoreFromCurrent();
        }
        return this.parseFullName(this.mInputBuffer[this.mInputPtr++]);
    }

    protected String parseFullName(char n2) throws XMLStreamException {
        if (!this.isNameStartChar((char)n2)) {
            if (n2 == 58) {
                if (this.mCfgNsEnabled) {
                    this.throwNsColonException(this.parseFNameForError());
                }
            } else {
                if (n2 <= 32) {
                    this.throwUnexpectedChar(n2, " (missing name?)");
                }
                this.throwUnexpectedChar(n2, " (expected a name start character)");
            }
        }
        int n3 = this.mInputPtr;
        int n4 = n2;
        int n5 = this.mInputEnd;
        int n6 = n3 - 1;
        while (true) {
            if (n3 >= n5) {
                this.mInputPtr = n3;
                return this.parseFullName2(n6, n4);
            }
            n2 = this.mInputBuffer[n3];
            if (n2 == 58) {
                if (this.mCfgNsEnabled) {
                    this.mInputPtr = n3;
                    this.throwNsColonException(new String(this.mInputBuffer, n6, n3 - n6) + this.parseFNameForError());
                }
            } else if (n2 < 45 || !this.isNameChar((char)n2)) break;
            n4 = n4 * 31 + n2;
            ++n3;
        }
        this.mInputPtr = n3;
        return this.mSymbols.findSymbol(this.mInputBuffer, n6, n3 - n6, n4);
    }

    protected String parseFullName2(int n2, int n3) throws XMLStreamException {
        int n4 = this.mInputEnd - n2;
        char[] cArray = this.getNameBuffer(n4 + 8);
        if (n4 > 0) {
            System.arraycopy(this.mInputBuffer, n2, cArray, 0, n4);
        }
        int n5 = cArray.length;
        while (this.mInputPtr < this.mInputEnd || this.loadMoreFromCurrent()) {
            char c2 = this.mInputBuffer[this.mInputPtr];
            if (c2 == ':') {
                if (this.mCfgNsEnabled) {
                    this.throwNsColonException(new String(cArray, 0, n4) + c2 + this.parseFNameForError());
                }
            } else if (c2 < '-' || !this.isNameChar(c2)) break;
            ++this.mInputPtr;
            if (n4 >= n5) {
                cArray = this.expandBy50Pct(cArray);
                this.mNameBuffer = cArray;
                n5 = cArray.length;
            }
            cArray[n4++] = c2;
            n3 = n3 * 31 + c2;
        }
        return this.mSymbols.findSymbol(cArray, 0, n4, n3);
    }

    protected String parseFNameForError() throws XMLStreamException {
        StringBuilder stringBuilder = new StringBuilder(100);
        while (true) {
            char c2;
            if (this.mInputPtr < this.mInputEnd) {
                c2 = this.mInputBuffer[this.mInputPtr++];
            } else {
                int n2 = this.getNext();
                if (n2 < 0) break;
                c2 = (char)n2;
            }
            if (c2 != ':' && !this.isNameChar(c2)) {
                --this.mInputPtr;
                break;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    protected final String parseEntityName(char c2) throws XMLStreamException {
        String string = this.parseFullName(c2);
        if (this.mInputPtr >= this.mInputEnd && !this.loadMoreFromCurrent()) {
            this.throwParseError("Missing semicolon after reference for entity \"{0}\"", string, null);
        }
        if ((c2 = this.mInputBuffer[this.mInputPtr++]) != ';') {
            this.throwUnexpectedChar(c2, "; expected a semi-colon after the reference for entity '" + string + "'");
        }
        return string;
    }

    protected int skipFullName(char c2) throws XMLStreamException {
        if (!this.isNameStartChar(c2)) {
            --this.mInputPtr;
            return 0;
        }
        int n2 = 1;
        while (true) {
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar("; expected an identifier");
            if (c2 != ':' && !this.isNameChar(c2)) break;
            ++n2;
        }
        return n2;
    }

    protected final String parseSystemId(char c2, boolean bl2, String string) throws XMLStreamException {
        char[] cArray = this.getNameBuffer(-1);
        int n2 = 0;
        while (true) {
            char c3;
            char c4 = c3 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(string);
            if (c3 == c2) break;
            if (c3 == '\n') {
                this.markLF();
            } else if (c3 == '\r') {
                if (this.peekNext() == 10) {
                    ++this.mInputPtr;
                    if (!bl2) {
                        if (n2 >= cArray.length) {
                            cArray = this.expandBy50Pct(cArray);
                        }
                        cArray[n2++] = 13;
                    }
                    c3 = '\n';
                } else if (bl2) {
                    c3 = '\n';
                }
            }
            if (n2 >= cArray.length) {
                cArray = this.expandBy50Pct(cArray);
            }
            cArray[n2++] = c3;
        }
        return n2 == 0 ? "" : new String(cArray, 0, n2);
    }

    protected final String parsePublicId(char c2, String string) throws XMLStreamException {
        char[] cArray = this.getNameBuffer(-1);
        int n2 = 0;
        boolean bl2 = false;
        while (true) {
            char c3;
            char c4 = c3 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(string);
            if (c3 == c2) break;
            if (c3 == '\n') {
                this.markLF();
                bl2 = true;
                continue;
            }
            if (c3 == '\r') {
                if (this.peekNext() == 10) {
                    ++this.mInputPtr;
                }
                bl2 = true;
                continue;
            }
            if (c3 == ' ') {
                bl2 = true;
                continue;
            }
            if (c3 >= '\u0080' || sPubidValidity[c3] != 1) {
                this.throwUnexpectedChar(c3, " in public identifier");
            }
            if (n2 >= cArray.length) {
                cArray = this.expandBy50Pct(cArray);
            }
            if (bl2) {
                bl2 = false;
                if (n2 > 0) {
                    cArray[n2++] = 32;
                    if (n2 >= cArray.length) {
                        cArray = this.expandBy50Pct(cArray);
                    }
                }
            }
            cArray[n2++] = c3;
        }
        return n2 == 0 ? "" : new String(cArray, 0, n2);
    }

    protected final void parseUntil(TextBuffer textBuffer, char c2, boolean bl2, String string) throws XMLStreamException {
        if (this.mInputPtr >= this.mInputEnd) {
            this.loadMore(string);
        }
        while (true) {
            int n2;
            int n3;
            char[] cArray = this.mInputBuffer;
            int n4 = this.mInputEnd;
            int n5 = n3 = this.mInputPtr;
            while (n3 < n4) {
                int n6;
                if ((n2 = cArray[n3++]) == c2) {
                    n6 = n3 - n5 - 1;
                    if (n6 > 0) {
                        textBuffer.append(cArray, n5, n6);
                    }
                    this.mInputPtr = n3;
                    return;
                }
                if (n2 == 10) {
                    this.mInputPtr = n3;
                    this.markLF();
                    continue;
                }
                if (n2 != 13) continue;
                if (!bl2 && n3 < n4) {
                    if (cArray[n3] == '\n') {
                        // empty if block
                    }
                    this.mInputPtr = ++n3;
                    this.markLF();
                    continue;
                }
                n6 = n3 - n5 - 1;
                if (n6 > 0) {
                    textBuffer.append(cArray, n5, n6);
                }
                this.mInputPtr = n3;
                n2 = this.getNextChar(string);
                if (n2 != 10) {
                    --this.mInputPtr;
                    textBuffer.append(bl2 ? (char)'\n' : '\r');
                } else if (bl2) {
                    textBuffer.append('\n');
                } else {
                    textBuffer.append('\r');
                    textBuffer.append('\n');
                }
                n5 = n3 = this.mInputPtr;
                this.markLF();
            }
            n2 = n3 - n5;
            if (n2 > 0) {
                textBuffer.append(cArray, n5, n2);
            }
            this.loadMore(string);
            n5 = n3 = this.mInputPtr;
            cArray = this.mInputBuffer;
            n4 = this.mInputEnd;
        }
    }

    private int resolveCharEnt(StringBuffer stringBuffer) throws XMLStreamException {
        int n2 = 0;
        char c2 = this.getNextChar(" in entity reference");
        if (stringBuffer != null) {
            stringBuffer.append(c2);
        }
        if (c2 == 'x') {
            while (true) {
                char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.getNextCharFromCurrent(" in entity reference");
                if (c2 != ';') {
                    if (stringBuffer != null) {
                        stringBuffer.append(c2);
                    }
                    n2 <<= 4;
                    if (c2 <= '9' && c2 >= '0') {
                        n2 += c2 - 48;
                    } else if (c2 >= 'a' && c2 <= 'f') {
                        n2 += 10 + (c2 - 97);
                    } else if (c2 >= 'A' && c2 <= 'F') {
                        n2 += 10 + (c2 - 65);
                    } else {
                        this.throwUnexpectedChar(c2, "; expected a hex digit (0-9a-fA-F).");
                    }
                    if (n2 <= 0x10FFFF) continue;
                    this.reportUnicodeOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (c2 != ';') {
                if (c2 <= '9' && c2 >= '0') {
                    if ((n2 = n2 * 10 + (c2 - 48)) > 0x10FFFF) {
                        this.reportUnicodeOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(c2, "; expected a decimal number.");
                }
                char c4 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.getNextCharFromCurrent(" in entity reference");
                if (stringBuffer == null || c2 == ';') continue;
                stringBuffer.append(c2);
            }
        }
        this.validateChar(n2);
        return n2;
    }

    private final void validateChar(int n2) throws XMLStreamException {
        if (n2 >= 55296) {
            if (n2 < 57344) {
                this.reportIllegalChar(n2);
            }
            if (n2 > 65535) {
                if (n2 > 0x10FFFF) {
                    this.reportUnicodeOverflow();
                }
            } else if (n2 >= 65534) {
                this.reportIllegalChar(n2);
            }
        } else if (n2 < 32) {
            if (n2 == 0) {
                this.throwParseError("Invalid character reference: null character not allowed in XML content.");
            }
            if (!this.mXml11 && !this.mAllowXml11EscapedCharsInXml10 && n2 != 9 && n2 != 10 && n2 != 13) {
                this.reportIllegalChar(n2);
            }
        }
    }

    protected final char[] getNameBuffer(int n2) {
        char[] cArray = this.mNameBuffer;
        if (cArray == null) {
            this.mNameBuffer = cArray = new char[n2 > 48 ? n2 + 16 : 64];
        } else if (n2 >= cArray.length) {
            int n3 = cArray.length;
            this.mNameBuffer = cArray = new char[n2 >= (n3 += n3 >> 1) ? n2 + 16 : n3];
        }
        return cArray;
    }

    protected final char[] expandBy50Pct(char[] cArray) {
        int n2 = cArray.length;
        char[] cArray2 = new char[n2 + (n2 >> 1)];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return cArray2;
    }

    private void throwNsColonException(String string) throws XMLStreamException {
        this.throwParseError("Illegal name \"{0}\" (PI target, entity/notation name): can not contain a colon (XML Namespaces 1.0#6)", string, null);
    }

    private void throwRecursionError(String string) throws XMLStreamException {
        this.throwParseError("Illegal entity expansion: entity \"{0}\" expands itself recursively.", string, null);
    }

    private void reportUnicodeOverflow() throws XMLStreamException {
        this.throwParseError("Illegal character entity: value higher than max allowed (0x{0})", Integer.toHexString(0x10FFFF), null);
    }

    private void reportIllegalChar(int n2) throws XMLStreamException {
        this.throwParseError("Illegal character entity: expansion character (code 0x{0}", Integer.toHexString(n2), null);
    }

    protected void verifyLimit(String string, long l2, long l3) throws XMLStreamException {
        if (l3 > l2) {
            throw this.constructLimitViolation(string, l2);
        }
    }

    protected XMLStreamException constructLimitViolation(String string, long l2) throws XMLStreamException {
        return new XMLStreamException(string + " limit (" + l2 + ") exceeded");
    }

    static {
        int n2;
        sCharValidity = new byte[256];
        StreamScanner.sCharValidity[95] = 1;
        int n3 = 25;
        for (n2 = 0; n2 <= n3; ++n2) {
            StreamScanner.sCharValidity[65 + n2] = 1;
            StreamScanner.sCharValidity[97 + n2] = 1;
        }
        for (n2 = 192; n2 < 246; ++n2) {
            StreamScanner.sCharValidity[n2] = 1;
        }
        StreamScanner.sCharValidity[215] = 0;
        StreamScanner.sCharValidity[247] = 0;
        StreamScanner.sCharValidity[45] = -1;
        StreamScanner.sCharValidity[46] = -1;
        StreamScanner.sCharValidity[183] = -1;
        for (n2 = 48; n2 <= 57; ++n2) {
            StreamScanner.sCharValidity[n2] = -1;
        }
        sPubidValidity = new byte[128];
        n3 = 25;
        for (n2 = 0; n2 <= n3; ++n2) {
            StreamScanner.sPubidValidity[65 + n2] = 1;
            StreamScanner.sPubidValidity[97 + n2] = 1;
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            StreamScanner.sPubidValidity[n2] = 1;
        }
        StreamScanner.sPubidValidity[10] = 1;
        StreamScanner.sPubidValidity[13] = 1;
        StreamScanner.sPubidValidity[32] = 1;
        StreamScanner.sPubidValidity[45] = 1;
        StreamScanner.sPubidValidity[39] = 1;
        StreamScanner.sPubidValidity[40] = 1;
        StreamScanner.sPubidValidity[41] = 1;
        StreamScanner.sPubidValidity[43] = 1;
        StreamScanner.sPubidValidity[44] = 1;
        StreamScanner.sPubidValidity[46] = 1;
        StreamScanner.sPubidValidity[47] = 1;
        StreamScanner.sPubidValidity[58] = 1;
        StreamScanner.sPubidValidity[61] = 1;
        StreamScanner.sPubidValidity[63] = 1;
        StreamScanner.sPubidValidity[59] = 1;
        StreamScanner.sPubidValidity[33] = 1;
        StreamScanner.sPubidValidity[42] = 1;
        StreamScanner.sPubidValidity[35] = 1;
        StreamScanner.sPubidValidity[64] = 1;
        StreamScanner.sPubidValidity[36] = 1;
        StreamScanner.sPubidValidity[95] = 1;
        StreamScanner.sPubidValidity[37] = 1;
    }
}

