/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.CipherSuiteFilter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ClientAuth;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSsl;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslClientSessionCache;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslEngineMap;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslSessionContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslSessionTicketKey;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.SslContextOption;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.CertificateCallback;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.CertificateVerifier;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSLContext;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class ReferenceCountedOpenSslClientContext
extends ReferenceCountedOpenSslContext {
    private static final Set<String> SUPPORTED_KEY_TYPES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("RSA", "DH_RSA", "EC", "EC_RSA", "EC_EC")));
    private final OpenSslSessionContext sessionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslClientContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, String[] stringArray, long l2, long l3, boolean bl2, String string2, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        super(iterable, cipherSuiteFilter, ReferenceCountedOpenSslClientContext.toNegotiator(applicationProtocolConfig), 0, x509CertificateArray2, ClientAuth.NONE, stringArray, false, bl2, true, entryArray);
        boolean bl3 = false;
        try {
            this.sessionContext = ReferenceCountedOpenSslClientContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2, l2, l3);
            bl3 = true;
        }
        finally {
            if (!bl3) {
                this.release();
            }
        }
    }

    @Override
    public OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OpenSslSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2, long l3, long l4) throws SSLException {
        if (privateKey == null && x509CertificateArray2 != null || privateKey != null && x509CertificateArray2 == null) {
            throw new IllegalArgumentException("Either both keyCertChain and key needs to be null or none of them");
        }
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object;
            Object object2;
            try {
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    if (x509CertificateArray2 != null) {
                        ReferenceCountedOpenSslClientContext.setKeyMaterial(l2, x509CertificateArray2, privateKey, string);
                    }
                } else {
                    if (keyManagerFactory == null && x509CertificateArray2 != null) {
                        object2 = ReferenceCountedOpenSslClientContext.keyStorePassword(string);
                        object = ReferenceCountedOpenSslClientContext.buildKeyStore(x509CertificateArray2, privateKey, object2, string2);
                        keyManagerFactory = ((KeyStore)object).aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init((KeyStore)object, (char[])object2);
                        openSslKeyMaterialProvider = ReferenceCountedOpenSslClientContext.providerFor(keyManagerFactory, string);
                    } else if (keyManagerFactory != null) {
                        openSslKeyMaterialProvider = ReferenceCountedOpenSslClientContext.providerFor(keyManagerFactory, string);
                    }
                    if (openSslKeyMaterialProvider != null) {
                        object2 = new OpenSslKeyMaterialManager(openSslKeyMaterialProvider);
                        SSLContext.setCertificateCallback((long)l2, (CertificateCallback)new OpenSslClientCertificateCallback(openSslEngineMap, (OpenSslKeyMaterialManager)object2));
                    }
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            SSLContext.setVerify((long)l2, (int)1, (int)10);
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslClientContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object2 = ReferenceCountedOpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                ReferenceCountedOpenSslClientContext.setVerifyCallback(l2, openSslEngineMap, (X509TrustManager)object2);
            }
            catch (Exception exception) {
                if (openSslKeyMaterialProvider != null) {
                    openSslKeyMaterialProvider.destroy();
                }
                throw new SSLException("unable to setup trustmanager", exception);
            }
            object2 = new OpenSslClientSessionContext(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
            object2.setSessionCacheEnabled(CLIENT_ENABLE_SESSION_CACHE);
            if (l3 > 0L) {
                object2.setSessionCacheSize((int)Math.min(l3, Integer.MAX_VALUE));
            }
            if (l4 > 0L) {
                object2.setSessionTimeout((int)Math.min(l4, Integer.MAX_VALUE));
            }
            if (CLIENT_ENABLE_SESSION_TICKET) {
                object2.setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            openSslKeyMaterialProvider = null;
            object = object2;
            return object;
        }
        finally {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
        }
    }

    private static void setVerifyCallback(long l2, OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
        if (ReferenceCountedOpenSslClientContext.useExtendedTrustManager(x509TrustManager)) {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)x509TrustManager));
        } else {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new TrustManagerVerifyCallback(openSslEngineMap, x509TrustManager));
        }
    }

    private static final class OpenSslClientCertificateCallback
    implements CertificateCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslClientCertificateCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engineMap = openSslEngineMap;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(openSslEngineMap);
            this.manager = x509ExtendedTrustManager;
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
            super(openSslEngineMap);
            this.manager = x509TrustManager;
        }
    }

    static final class OpenSslClientSessionContext
    extends OpenSslSessionContext {
        OpenSslClientSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
            super(referenceCountedOpenSslContext, openSslKeyMaterialProvider, SSL.SSL_SESS_CACHE_CLIENT, new OpenSslClientSessionCache(referenceCountedOpenSslContext.engineMap));
        }
    }
}

