/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.DefaultRegularFileSnapshotContext;
import org.gradle.api.internal.changedetection.state.IgnoringResourceHasher;
import org.gradle.api.internal.changedetection.state.LineEndingNormalizingResourceHasher;
import org.gradle.api.internal.changedetection.state.MetaInfAwareClasspathResourceHasher;
import org.gradle.api.internal.changedetection.state.PropertiesFileAwareClasspathResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.RuntimeClasspathResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipHasher;
import org.gradle.internal.RelativePathSupplier;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class ClasspathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    private final NonJarFingerprintingStrategy nonZipFingerprintingStrategy;
    private final ResourceSnapshotterCacheService cacheService;
    private final ResourceHasher classpathResourceHasher;
    private final ZipHasher zipHasher;
    private final Interner<String> stringInterner;
    private final HashCode zipHasherConfigurationHash;

    private ClasspathFingerprintingStrategy(String string, NonJarFingerprintingStrategy nonJarFingerprintingStrategy, ResourceHasher resourceHasher, ZipHasher zipHasher, ResourceSnapshotterCacheService resourceSnapshotterCacheService, Interner<String> interner) {
        super(string, zipHasher);
        this.nonZipFingerprintingStrategy = nonJarFingerprintingStrategy;
        this.classpathResourceHasher = resourceHasher;
        this.cacheService = resourceSnapshotterCacheService;
        this.stringInterner = interner;
        this.zipHasher = zipHasher;
        Hasher hasher = Hashing.newHasher();
        zipHasher.appendConfigurationToHasher(hasher);
        this.zipHasherConfigurationHash = hasher.hash();
    }

    public static ClasspathFingerprintingStrategy runtimeClasspath(ResourceFilter resourceFilter, ResourceEntryFilter resourceEntryFilter, Map<String, ResourceEntryFilter> map, RuntimeClasspathResourceHasher runtimeClasspathResourceHasher, ResourceSnapshotterCacheService resourceSnapshotterCacheService, Interner<String> interner, LineEndingSensitivity lineEndingSensitivity) {
        ResourceHasher resourceHasher = ClasspathFingerprintingStrategy.runtimeClasspathResourceHasher(runtimeClasspathResourceHasher, lineEndingSensitivity, map, resourceEntryFilter, resourceFilter);
        ZipHasher zipHasher = new ZipHasher(resourceHasher);
        return new ClasspathFingerprintingStrategy("CLASSPATH", NonJarFingerprintingStrategy.USE_FILE_HASH, resourceHasher, zipHasher, resourceSnapshotterCacheService, interner);
    }

    public static ClasspathFingerprintingStrategy compileClasspath(ResourceHasher resourceHasher, ResourceSnapshotterCacheService resourceSnapshotterCacheService, Interner<String> interner) {
        ZipHasher zipHasher = new ZipHasher(resourceHasher);
        return new ClasspathFingerprintingStrategy("COMPILE_CLASSPATH", NonJarFingerprintingStrategy.IGNORE, resourceHasher, zipHasher, resourceSnapshotterCacheService, interner);
    }

    public static ResourceHasher runtimeClasspathResourceHasher(RuntimeClasspathResourceHasher runtimeClasspathResourceHasher, LineEndingSensitivity lineEndingSensitivity, Map<String, ResourceEntryFilter> map, ResourceEntryFilter resourceEntryFilter, ResourceFilter resourceFilter) {
        ResourceHasher resourceHasher = LineEndingNormalizingResourceHasher.wrap(runtimeClasspathResourceHasher, lineEndingSensitivity);
        resourceHasher = ClasspathFingerprintingStrategy.propertiesFileHasher(resourceHasher, map);
        resourceHasher = ClasspathFingerprintingStrategy.metaInfAwareClasspathResourceHasher(resourceHasher, resourceEntryFilter);
        return ClasspathFingerprintingStrategy.ignoringResourceHasher(resourceHasher, resourceFilter);
    }

    private static ResourceHasher ignoringResourceHasher(ResourceHasher resourceHasher, ResourceFilter resourceFilter) {
        return new IgnoringResourceHasher(resourceHasher, resourceFilter);
    }

    private static ResourceHasher propertiesFileHasher(ResourceHasher resourceHasher, Map<String, ResourceEntryFilter> map) {
        return new PropertiesFileAwareClasspathResourceHasher(resourceHasher, map);
    }

    private static ResourceHasher metaInfAwareClasspathResourceHasher(ResourceHasher resourceHasher, ResourceEntryFilter resourceEntryFilter) {
        return new MetaInfAwareClasspathResourceHasher(resourceHasher, resourceEntryFilter);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot fileSystemSnapshot) {
        ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder = ImmutableMap.builder();
        HashSet<String> hashSet = new HashSet<String>();
        fileSystemSnapshot.accept(new RelativePathTracker(), new ClasspathFingerprintingVisitor(hashSet, builder));
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.KEEP_ORDER;
    }

    private class ClasspathFingerprintingVisitor
    implements RelativePathTrackingFileSystemSnapshotHierarchyVisitor {
        private final HashSet<String> processedEntries;
        private final ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder;

        public ClasspathFingerprintingVisitor(HashSet<String> hashSet, ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder) {
            this.processedEntries = hashSet;
            this.builder = builder;
        }

        @Override
        public SnapshotVisitResult visitEntry(final FileSystemLocationSnapshot fileSystemLocationSnapshot, final RelativePathSupplier relativePathSupplier) {
            fileSystemLocationSnapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                @Override
                public void visitRegularFile(RegularFileSnapshot regularFileSnapshot) {
                    FileSystemLocationFingerprint fileSystemLocationFingerprint;
                    HashCode hashCode = ClasspathFingerprintingVisitor.this.hashContent(regularFileSnapshot, relativePathSupplier);
                    if (hashCode == null) {
                        return;
                    }
                    String string = fileSystemLocationSnapshot.getAbsolutePath();
                    if (!ClasspathFingerprintingVisitor.this.processedEntries.add(string)) {
                        return;
                    }
                    if (relativePathSupplier.isRoot()) {
                        fileSystemLocationFingerprint = IgnoredPathFileSystemLocationFingerprint.create(fileSystemLocationSnapshot.getType(), hashCode);
                    } else {
                        String string2 = ClasspathFingerprintingStrategy.this.stringInterner.intern(relativePathSupplier.toRelativePath());
                        fileSystemLocationFingerprint = new DefaultFileSystemLocationFingerprint(string2, FileType.RegularFile, hashCode);
                    }
                    ClasspathFingerprintingVisitor.this.builder.put(string, fileSystemLocationFingerprint);
                }

                @Override
                public void visitMissing(MissingFileSnapshot missingFileSnapshot) {
                    if (!relativePathSupplier.isRoot()) {
                        throw new RuntimeException(String.format("Couldn't read file content: '%s'.", missingFileSnapshot.getAbsolutePath()));
                    }
                }
            });
            return SnapshotVisitResult.CONTINUE;
        }

        private HashCode hashContent(RegularFileSnapshot regularFileSnapshot, RelativePathSupplier relativePathSupplier) {
            DefaultRegularFileSnapshotContext defaultRegularFileSnapshotContext = new DefaultRegularFileSnapshotContext(() -> Iterables.toArray(relativePathSupplier.getSegments(), String.class), regularFileSnapshot);
            try {
                if (ZipHasher.isZipFile(defaultRegularFileSnapshotContext.getSnapshot().getName())) {
                    return ClasspathFingerprintingStrategy.this.cacheService.hashFile(defaultRegularFileSnapshotContext, ClasspathFingerprintingStrategy.this.zipHasher, ClasspathFingerprintingStrategy.this.zipHasherConfigurationHash);
                }
                if (relativePathSupplier.isRoot()) {
                    return ClasspathFingerprintingStrategy.this.nonZipFingerprintingStrategy.determineNonJarFingerprint(regularFileSnapshot.getHash());
                }
                return ClasspathFingerprintingStrategy.this.classpathResourceHasher.hash(defaultRegularFileSnapshotContext);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(this.failedToNormalize(regularFileSnapshot), iOException);
            }
            catch (UncheckedIOException uncheckedIOException) {
                throw new UncheckedIOException(this.failedToNormalize(regularFileSnapshot), uncheckedIOException.getCause());
            }
        }

        private String failedToNormalize(RegularFileSnapshot regularFileSnapshot) {
            return String.format("Failed to normalize content of '%s'.", regularFileSnapshot.getAbsolutePath());
        }
    }

    public static enum NonJarFingerprintingStrategy {
        IGNORE{

            @Override
            public HashCode determineNonJarFingerprint(HashCode hashCode) {
                return null;
            }
        }
        ,
        USE_FILE_HASH{

            @Override
            public HashCode determineNonJarFingerprint(HashCode hashCode) {
                return hashCode;
            }
        };


        public abstract HashCode determineNonJarFingerprint(HashCode var1);
    }
}

