package com.gradle.develocity.agent.maven.api.scan;

import java.util.function.Predicate;

/**
 * Allows configuring whether a build scan should be published at the end of the build
 *
 * @see BuildScanApi#getPublishing()
 * @since 1.21
 */
public interface BuildScanPublishing {

    /**
     * Specify a condition for when a build scan should be published at the end of the build.
     * <p>
     * You may add multiple such predicates. A build scan will be published if any of the predicates return true.
     *
     * @param onlyIf the condition
     * @return this object
     */
    BuildScanPublishing onlyIf(Predicate<PublishingContext> onlyIf);

    /**
     * The context for evaluating conditions that determine whether a build scan should be published at the end of the build.
     *
     * @see #onlyIf(Predicate)
     */
    interface PublishingContext {

        BuildResult getBuildResult();

        boolean isAuthenticated();

    }
}
