/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;
import java.io.InvalidObjectException;
import java.io.Serializable;

public abstract class WhiteSpaceProcessor
implements Serializable {
    public static final WhiteSpaceProcessor thePreserve = new Preserve();
    public static final WhiteSpaceProcessor theReplace = new Replace();
    public static final WhiteSpaceProcessor theCollapse = new Collapse();
    private static final WhiteSpaceProcessor backwardCompatibiliyHook1 = new WhiteSpaceProcessor(){

        public String process(String string) {
            throw new UnsupportedOperationException();
        }

        int tightness() {
            return 0;
        }

        public String getName() {
            return "preserve";
        }
    };
    private static final WhiteSpaceProcessor backwardCompatibiliyHook2 = new WhiteSpaceProcessor(){

        public String process(String string) {
            throw new UnsupportedOperationException();
        }

        int tightness() {
            return 2;
        }

        public String getName() {
            return "collapse";
        }
    };
    private static final WhiteSpaceProcessor backwardCompatibiliyHook3 = new WhiteSpaceProcessor(){

        public String process(String string) {
            throw new UnsupportedOperationException();
        }

        int tightness() {
            return 1;
        }

        public String getName() {
            return "replace";
        }
    };
    private static final long serialVersionUID = 1L;

    public abstract String process(String var1);

    abstract int tightness();

    public abstract String getName();

    protected static WhiteSpaceProcessor get(String string) throws DatatypeException {
        if ((string = theCollapse.process(string)).equals("preserve")) {
            return thePreserve;
        }
        if (string.equals("collapse")) {
            return theCollapse;
        }
        if (string.equals("replace")) {
            return theReplace;
        }
        throw new DatatypeException(XSDatatypeImpl.localize("WhiteSpaceProcessor.InvalidWhiteSpaceValue", string));
    }

    protected static final boolean isWhiteSpace(char c2) {
        return c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == ' ';
    }

    protected Object readResolve() throws InvalidObjectException {
        try {
            if (this.getClass() == backwardCompatibiliyHook1.getClass()) {
                return thePreserve;
            }
            if (this.getClass() == backwardCompatibiliyHook2.getClass()) {
                return theCollapse;
            }
            if (this.getClass() == backwardCompatibiliyHook3.getClass()) {
                return theReplace;
            }
            return WhiteSpaceProcessor.get(this.getName());
        }
        catch (DatatypeException datatypeException) {
            throw new InvalidObjectException("Unknown Processing Mode");
        }
    }

    public static String replace(String string) {
        return theReplace.process(string);
    }

    public static String collapse(String string) {
        return theCollapse.process(string);
    }

    private static class Collapse
    extends WhiteSpaceProcessor {
        private static final long serialVersionUID = 1L;

        private Collapse() {
        }

        public String process(String string) {
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n2);
            boolean bl2 = true;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                boolean bl3 = WhiteSpaceProcessor.isWhiteSpace(c2);
                if (bl2 && bl3) continue;
                bl2 = bl3;
                if (bl2) {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(c2);
            }
            n2 = stringBuffer.length();
            if (n2 > 0 && stringBuffer.charAt(n2 - 1) == ' ') {
                stringBuffer.setLength(n2 - 1);
            }
            return stringBuffer.toString();
        }

        int tightness() {
            return 2;
        }

        public String getName() {
            return "collapse";
        }
    }

    private static class Replace
    extends WhiteSpaceProcessor {
        private static final long serialVersionUID = 1L;

        private Replace() {
        }

        public String process(String string) {
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (WhiteSpaceProcessor.isWhiteSpace(c2)) {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(c2);
            }
            return stringBuffer.toString();
        }

        int tightness() {
            return 1;
        }

        public String getName() {
            return "replace";
        }
    }

    private static class Preserve
    extends WhiteSpaceProcessor {
        private static final long serialVersionUID = 1L;

        private Preserve() {
        }

        public String process(String string) {
            return string;
        }

        int tightness() {
            return 0;
        }

        public String getName() {
            return "preserve";
        }
    }
}

