/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ClassUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class ArrayUtils {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    public static int getLength(Object object) {
        return object != null ? Array.getLength(object) : 0;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        return ArrayUtils.indexOf(objectArray, object, 0);
    }

    public static int indexOf(Object[] objectArray, Object object, int n2) {
        if (objectArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (object == null) {
            for (int i2 = n2; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < objectArray.length; ++i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    private static boolean isArrayEmpty(Object object) {
        return ArrayUtils.getLength(object) == 0;
    }

    public static boolean isEmpty(Object[] objectArray) {
        return ArrayUtils.isArrayEmpty(objectArray);
    }

    public static <T> boolean isNotEmpty(T[] TArray) {
        return !ArrayUtils.isEmpty(TArray);
    }

    public static boolean isSameLength(Object[] objectArray, Object[] objectArray2) {
        return ArrayUtils.getLength(objectArray) == ArrayUtils.getLength(objectArray2);
    }

    public static Class<?>[] nullToEmpty(Class<?>[] classArray) {
        return ArrayUtils.isEmpty(classArray) ? EMPTY_CLASS_ARRAY : classArray;
    }

    public static Object[] nullToEmpty(Object[] objectArray) {
        return ArrayUtils.isEmpty(objectArray) ? EMPTY_OBJECT_ARRAY : objectArray;
    }

    public static boolean[] toPrimitive(Boolean[] booleanArray) {
        return ArrayUtils.toPrimitive(booleanArray, false);
    }

    public static boolean[] toPrimitive(Boolean[] booleanArray, boolean bl2) {
        if (booleanArray == null) {
            return null;
        }
        if (booleanArray.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[booleanArray.length];
        for (int i2 = 0; i2 < booleanArray.length; ++i2) {
            Boolean bl3 = booleanArray[i2];
            blArray[i2] = bl3 == null ? bl2 : bl3;
        }
        return blArray;
    }

    public static byte[] toPrimitive(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            byArray[i2] = byteArray[i2];
        }
        return byArray;
    }

    public static char[] toPrimitive(Character[] characterArray) {
        if (characterArray == null) {
            return null;
        }
        if (characterArray.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[characterArray.length];
        for (int i2 = 0; i2 < characterArray.length; ++i2) {
            cArray[i2] = characterArray[i2].charValue();
        }
        return cArray;
    }

    public static double[] toPrimitive(Double[] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        if (doubleArray.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[doubleArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            dArray[i2] = doubleArray[i2];
        }
        return dArray;
    }

    public static float[] toPrimitive(Float[] floatArray) {
        if (floatArray == null) {
            return null;
        }
        if (floatArray.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[floatArray.length];
        for (int i2 = 0; i2 < floatArray.length; ++i2) {
            fArray[i2] = floatArray[i2].floatValue();
        }
        return fArray;
    }

    public static int[] toPrimitive(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        if (integerArray.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return nArray;
    }

    public static long[] toPrimitive(Long[] longArray) {
        if (longArray == null) {
            return null;
        }
        if (longArray.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[longArray.length];
        for (int i2 = 0; i2 < longArray.length; ++i2) {
            lArray[i2] = longArray[i2];
        }
        return lArray;
    }

    public static Object toPrimitive(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass().getComponentType();
        Class<?> clazz2 = ClassUtils.wrapperToPrimitive(clazz);
        if (Boolean.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Boolean[])object);
        }
        if (Character.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Character[])object);
        }
        if (Byte.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Byte[])object);
        }
        if (Integer.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Integer[])object);
        }
        if (Long.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Long[])object);
        }
        if (Short.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Short[])object);
        }
        if (Double.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Double[])object);
        }
        if (Float.TYPE.equals(clazz2)) {
            return ArrayUtils.toPrimitive((Float[])object);
        }
        return object;
    }

    public static short[] toPrimitive(Short[] shortArray) {
        if (shortArray == null) {
            return null;
        }
        if (shortArray.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[shortArray.length];
        for (int i2 = 0; i2 < shortArray.length; ++i2) {
            sArray[i2] = shortArray[i2];
        }
        return sArray;
    }
}

