/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.version;

import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion
implements Comparable<JavaVersion> {
    public static final JavaVersion JAVA_SPECIFICATION_VERSION = JavaVersion.parse(System.getProperty("java.specification.version"));
    public static final JavaVersion JAVA_VERSION = JavaVersion.parse(System.getProperty("java.version"));
    private static final Pattern startingDigits = Pattern.compile("(\\d+)(.*)");
    private final String rawVersion;
    private final boolean isMajor;

    private JavaVersion(String string, boolean bl2) {
        this.rawVersion = string;
        this.isMajor = bl2;
    }

    public static JavaVersion parse(String string) {
        return new JavaVersion(string, !string.startsWith("1."));
    }

    @Override
    public int compareTo(JavaVersion javaVersion) {
        String[] stringArray = this.rawVersion.split("\\.");
        String[] stringArray2 = javaVersion.rawVersion.split("\\.");
        int n2 = Math.min(stringArray.length, stringArray2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            Matcher matcher;
            int n3;
            Matcher matcher2 = startingDigits.matcher(stringArray[i2]);
            int n4 = matcher2.find() ? Integer.parseInt(matcher2.group(1)) : -1;
            int n5 = Integer.compare(n4, n3 = (matcher = startingDigits.matcher(stringArray2[i2])).find() ? Integer.parseInt(matcher.group(1)) : -1);
            if (n5 != 0) {
                return n5;
            }
            n5 = this.suffixRate(matcher2.group(2)) - this.suffixRate(matcher.group(2));
            if (n5 != 0) {
                return n5;
            }
            n5 = matcher2.group(2).compareTo(matcher.group(2));
            if (n5 == 0) continue;
            return n5;
        }
        return stringArray.length - stringArray2.length;
    }

    private int suffixRate(String string) {
        if ("-ea".equals(string)) {
            return -100;
        }
        if ("".equals(string)) {
            return 0;
        }
        return 10;
    }

    public JavaVersion asMajor() {
        if (!this.isMajor) {
            return new JavaVersion(this.rawVersion.substring(2), true);
        }
        return this;
    }

    public String getValue(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(this.rawVersion, ".");
        stringBuilder.append(stringTokenizer.nextToken());
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append('.');
            if (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuilder.append("0");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.rawVersion;
    }

    public int hashCode() {
        return Objects.hashCode(this.rawVersion);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaVersion javaVersion = (JavaVersion)object;
        if (this.isMajor != javaVersion.isMajor) {
            String string;
            String string2;
            if (this.isMajor) {
                string2 = "1." + this.rawVersion;
                string = javaVersion.rawVersion;
            } else {
                string2 = this.rawVersion;
                string = "1." + javaVersion.rawVersion;
            }
            if (!Objects.equals(string2, string)) {
                return false;
            }
        } else if (!Objects.equals(this.rawVersion, javaVersion.rawVersion)) {
            return false;
        }
        return true;
    }
}

