/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;

public class BooleanLiteral
extends Literal {
    private final BooleanTypedValue value;

    public BooleanLiteral(String string, int n2, int n3, boolean bl2) {
        super(string, n2, n3);
        this.value = BooleanTypedValue.forValue(bl2);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        if (this.value == BooleanTypedValue.TRUE) {
            methodVisitor.visitLdcInsn(1);
        } else {
            methodVisitor.visitLdcInsn(0);
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

