/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime.TimeZone;
import java.math.BigInteger;
import java.util.SimpleTimeZone;

abstract class AbstractCalendarParser {
    private final String format;
    private final String value;
    private final int flen;
    private final int vlen;
    private int fidx;
    protected int vidx;

    protected AbstractCalendarParser(String string, String string2) {
        this.format = string;
        this.value = string2;
        this.flen = string.length();
        this.vlen = string2.length();
    }

    public void parse() throws IllegalArgumentException {
        block9: while (this.fidx < this.flen) {
            char c2;
            if ((c2 = this.format.charAt(this.fidx++)) != '%') {
                this.skip(c2);
                continue;
            }
            switch (this.format.charAt(this.fidx++)) {
                case 'Y': {
                    int n2 = 1;
                    if (this.peek() == '-') {
                        ++this.vidx;
                        n2 = -1;
                    }
                    this.setYear(n2 * this.parseInt(4, Integer.MAX_VALUE));
                    continue block9;
                }
                case 'M': {
                    this.setMonth(this.parseInt(2, 2));
                    continue block9;
                }
                case 'D': {
                    this.setDay(this.parseInt(2, 2));
                    continue block9;
                }
                case 'h': {
                    this.setHours(this.parseInt(2, 2));
                    continue block9;
                }
                case 'm': {
                    this.setMinutes(this.parseInt(2, 2));
                    continue block9;
                }
                case 's': {
                    this.setSeconds(this.parseInt(2, 2));
                    if (this.peek() != '.') continue block9;
                    ++this.vidx;
                    this.parseFractionSeconds();
                    continue block9;
                }
                case 'z': {
                    char c3 = this.peek();
                    if (c3 == 'Z') {
                        ++this.vidx;
                        this.setTimeZone(TimeZone.ZERO);
                        continue block9;
                    }
                    if (c3 == '+' || c3 == '-') {
                        ++this.vidx;
                        int n3 = this.parseInt(2, 2);
                        this.skip(':');
                        int n4 = this.parseInt(2, 2);
                        this.setTimeZone(new SimpleTimeZone((n3 * 60 + n4) * (c3 == '+' ? 1 : -1) * 60 * 1000, ""));
                        continue block9;
                    }
                    this.setTimeZone(TimeZone.MISSING);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        if (this.vidx != this.vlen) {
            throw new IllegalArgumentException(this.value);
        }
    }

    private char peek() throws IllegalArgumentException {
        if (this.vidx == this.vlen) {
            return '\uffff';
        }
        return this.value.charAt(this.vidx);
    }

    private char read() throws IllegalArgumentException {
        if (this.vidx == this.vlen) {
            throw new IllegalArgumentException(this.value);
        }
        return this.value.charAt(this.vidx++);
    }

    private void skip(char c2) throws IllegalArgumentException {
        if (this.read() != c2) {
            throw new IllegalArgumentException(this.value);
        }
    }

    protected final void skipDigits() {
        while (AbstractCalendarParser.isDigit(this.peek())) {
            ++this.vidx;
        }
    }

    protected final int parseInt(int n2, int n3) throws IllegalArgumentException {
        int n4 = this.vidx;
        while (AbstractCalendarParser.isDigit(this.peek()) && this.vidx - n4 < n3) {
            ++this.vidx;
        }
        if (this.vidx - n4 < n2) {
            throw new IllegalArgumentException(this.value);
        }
        return Integer.parseInt(this.value.substring(n4, this.vidx));
    }

    protected final BigInteger parseBigInteger(int n2, int n3) throws IllegalArgumentException {
        int n4 = this.vidx;
        while (AbstractCalendarParser.isDigit(this.peek()) && this.vidx - n4 <= n3) {
            ++this.vidx;
        }
        if (this.vidx - n4 < n2) {
            throw new IllegalArgumentException(this.value);
        }
        return new BigInteger(this.value.substring(n4, this.vidx));
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    protected abstract void parseFractionSeconds();

    protected abstract void setTimeZone(java.util.TimeZone var1);

    protected abstract void setSeconds(int var1);

    protected abstract void setMinutes(int var1);

    protected abstract void setHours(int var1);

    protected abstract void setDay(int var1);

    protected abstract void setMonth(int var1);

    protected abstract void setYear(int var1);
}

