/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.DTDEventListener;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.DTDHandlerBase;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.EndOfInputException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.ExternalEntity;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.InputEntity;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.InternalEntity;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.MessageCatalog;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.Resolver;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.SimpleHashtable;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.XmlChars;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DTDParser {
    public static final String TYPE_CDATA = "CDATA";
    public static final String TYPE_ID = "ID";
    public static final String TYPE_IDREF = "IDREF";
    public static final String TYPE_IDREFS = "IDREFS";
    public static final String TYPE_ENTITY = "ENTITY";
    public static final String TYPE_ENTITIES = "ENTITIES";
    public static final String TYPE_NMTOKEN = "NMTOKEN";
    public static final String TYPE_NMTOKENS = "NMTOKENS";
    public static final String TYPE_NOTATION = "NOTATION";
    public static final String TYPE_ENUMERATION = "ENUMERATION";
    private InputEntity in;
    private StringBuffer strTmp;
    private char[] nameTmp;
    private NameCache nameCache;
    private char[] charTmp = new char[2];
    private boolean doLexicalPE;
    protected final Set<String> declaredElements = new HashSet<String>();
    private SimpleHashtable params = new SimpleHashtable(7);
    Hashtable<String, Object> notations = new Hashtable(7);
    SimpleHashtable entities = new SimpleHashtable(17);
    private SimpleHashtable ids = new SimpleHashtable();
    private DTDEventListener dtdHandler;
    private EntityResolver resolver;
    private Locale locale;
    static final String strANY = "ANY";
    static final String strEMPTY = "EMPTY";
    private static final String XmlLang = "xml:lang";
    static final Catalog messages = new Catalog();

    public void setLocale(Locale locale) throws SAXException {
        if (locale != null && !messages.isLocaleSupported(locale.toString())) {
            throw new SAXException(messages.getMessage(this.locale, "P-078", new Object[]{locale}));
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale chooseLocale(String[] stringArray) throws SAXException {
        Locale locale = messages.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setDtdHandler(DTDEventListener dTDEventListener) {
        this.dtdHandler = dTDEventListener;
        if (dTDEventListener != null) {
            dTDEventListener.setDocumentLocator(new Locator(){

                @Override
                public String getPublicId() {
                    return DTDParser.this.getPublicId();
                }

                @Override
                public String getSystemId() {
                    return DTDParser.this.getSystemId();
                }

                @Override
                public int getLineNumber() {
                    return DTDParser.this.getLineNumber();
                }

                @Override
                public int getColumnNumber() {
                    return DTDParser.this.getColumnNumber();
                }
            });
        }
    }

    public DTDEventListener getDtdHandler() {
        return this.dtdHandler;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.init();
        this.parseInternal(inputSource);
    }

    public void parse(String string) throws IOException, SAXException {
        this.init();
        InputSource inputSource = this.resolver.resolveEntity(null, string);
        if (inputSource == null) {
            inputSource = Resolver.createInputSource(new URL(string), false);
        } else if (inputSource.getSystemId() == null) {
            this.warning("P-065", null);
            inputSource.setSystemId(string);
        }
        this.parseInternal(inputSource);
    }

    private void init() {
        this.in = null;
        this.strTmp = new StringBuffer();
        this.nameTmp = new char[20];
        this.nameCache = new NameCache();
        this.doLexicalPE = false;
        this.entities.clear();
        this.notations.clear();
        this.params.clear();
        this.declaredElements.clear();
        this.builtin("amp", "&#38;");
        this.builtin("lt", "&#60;");
        this.builtin("gt", ">");
        this.builtin("quot", "\"");
        this.builtin("apos", "'");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.resolver == null) {
            this.resolver = new Resolver();
        }
        if (this.dtdHandler == null) {
            this.dtdHandler = new DTDHandlerBase();
        }
    }

    private void builtin(String string, String string2) {
        InternalEntity internalEntity = new InternalEntity(string, string2.toCharArray());
        this.entities.put(string, internalEntity);
    }

    private void parseInternal(InputSource inputSource) throws IOException, SAXException {
        if (inputSource == null) {
            this.fatal("P-000");
        }
        try {
            this.in = InputEntity.getInputEntity(this.dtdHandler, this.locale);
            this.in.init(inputSource, null, null, false);
            this.dtdHandler.startDTD(this.in);
            ExternalEntity externalEntity = new ExternalEntity(this.in);
            this.externalParameterEntity(externalEntity);
            if (!this.in.isEOF()) {
                this.fatal("P-001", new Object[]{Integer.toHexString(this.getc())});
            }
            this.afterRoot();
            this.dtdHandler.endDTD();
        }
        catch (EndOfInputException endOfInputException) {
            if (!this.in.isDocument()) {
                String string = this.in.getName();
                do {
                    this.in = this.in.pop();
                } while (this.in.isInternal());
                this.fatal("P-002", new Object[]{string});
            } else {
                this.fatal("P-003", null);
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.print("Internal DTD parser error: ");
            runtimeException.printStackTrace();
            throw new SAXParseException(runtimeException.getMessage() != null ? runtimeException.getMessage() : runtimeException.getClass().getName(), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        }
        finally {
            this.strTmp = null;
            this.nameTmp = null;
            this.nameCache = null;
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            this.params.clear();
            this.entities.clear();
            this.notations.clear();
            this.declaredElements.clear();
            this.ids.clear();
        }
    }

    void afterRoot() throws SAXException {
        Enumeration<Object> enumeration = this.ids.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Boolean bl2 = (Boolean)this.ids.get(string);
            if (Boolean.FALSE != bl2) continue;
            this.error("V-024", new Object[]{string});
        }
    }

    private void whitespace(String string) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            this.fatal("P-004", new Object[]{messages.getMessage(this.locale, string)});
        }
    }

    private boolean maybeWhitespace() throws IOException, SAXException {
        if (!this.doLexicalPE) {
            return this.in.maybeWhitespace();
        }
        char c2 = this.getc();
        boolean bl2 = false;
        while (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
            bl2 = true;
            if (this.in.isEOF() && !this.in.isInternal()) {
                return bl2;
            }
            c2 = this.getc();
        }
        this.ungetc();
        return bl2;
    }

    private String maybeGetName() throws IOException, SAXException {
        NameCacheEntry nameCacheEntry = this.maybeGetNameCacheEntry();
        return nameCacheEntry == null ? null : nameCacheEntry.name;
    }

    private NameCacheEntry maybeGetNameCacheEntry() throws IOException, SAXException {
        char c2 = this.getc();
        if (!XmlChars.isLetter(c2) && c2 != ':' && c2 != '_') {
            this.ungetc();
            return null;
        }
        return this.nameCharString(c2);
    }

    private String getNmtoken() throws IOException, SAXException {
        char c2 = this.getc();
        if (!XmlChars.isNameChar(c2)) {
            this.fatal("P-006", new Object[]{new Character(c2)});
        }
        return this.nameCharString((char)c2).name;
    }

    private NameCacheEntry nameCharString(char c2) throws IOException, SAXException {
        int n2 = 1;
        this.nameTmp[0] = c2;
        while ((c2 = this.in.getNameChar()) != '\u0000') {
            if (n2 >= this.nameTmp.length) {
                char[] cArray = new char[this.nameTmp.length + 10];
                System.arraycopy(this.nameTmp, 0, cArray, 0, this.nameTmp.length);
                this.nameTmp = cArray;
            }
            this.nameTmp[n2++] = c2;
        }
        return this.nameCache.lookupEntry(this.nameTmp, n2);
    }

    private void parseLiteral(boolean bl2) throws IOException, SAXException {
        char c2 = this.getc();
        InputEntity inputEntity = this.in;
        if (c2 != '\'' && c2 != '\"') {
            this.fatal("P-007");
        }
        this.strTmp = new StringBuffer();
        while (true) {
            String string;
            if (this.in != inputEntity && this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            char c3 = this.getc();
            if (c3 == c2 && this.in == inputEntity) break;
            if (c3 == '&') {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-020", string);
                    if (bl2) {
                        this.strTmp.append('&');
                        this.strTmp.append(string);
                        this.strTmp.append(';');
                        continue;
                    }
                    this.expandEntityInLiteral(string, this.entities, bl2);
                    continue;
                }
                c3 = this.getc();
                if (c3 == '#') {
                    int n2 = this.parseCharNumber();
                    if (n2 > 65535) {
                        n2 = this.surrogatesToCharTmp(n2);
                        this.strTmp.append(this.charTmp[0]);
                        if (n2 != 2) continue;
                        this.strTmp.append(this.charTmp[1]);
                        continue;
                    }
                    this.strTmp.append((char)n2);
                    continue;
                }
                this.fatal("P-009");
                continue;
            }
            if (c3 == '%' && bl2) {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-021", string);
                    this.expandEntityInLiteral(string, this.params, bl2);
                    continue;
                }
                this.fatal("P-011");
            }
            if (!bl2) {
                if (c3 == ' ' || c3 == '\t' || c3 == '\n' || c3 == '\r') {
                    this.strTmp.append(' ');
                    continue;
                }
                if (c3 == '<') {
                    this.fatal("P-012");
                }
            }
            this.strTmp.append(c3);
        }
    }

    private void expandEntityInLiteral(String string, SimpleHashtable simpleHashtable, boolean bl2) throws IOException, SAXException {
        Object object = simpleHashtable.get(string);
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            this.pushReader(internalEntity.buf, string, !internalEntity.isPE);
        } else if (object instanceof ExternalEntity) {
            if (!bl2) {
                this.fatal("P-013", new Object[]{string});
            }
            this.pushReader((ExternalEntity)object);
        } else if (object == null) {
            this.fatal(simpleHashtable == this.params ? "V-022" : "P-014", new Object[]{string});
        }
    }

    private String getQuotedString(String string, String string2) throws IOException, SAXException {
        char c2;
        char c3 = this.in.getc();
        if (c3 != '\'' && c3 != '\"') {
            this.fatal("P-015", new Object[]{messages.getMessage(this.locale, string, new Object[]{string2})});
        }
        this.strTmp = new StringBuffer();
        while ((c2 = this.in.getc()) != c3) {
            this.strTmp.append(c2);
        }
        return this.strTmp.toString();
    }

    private String parsePublicId() throws IOException, SAXException {
        String string = this.getQuotedString("F-033", null);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (" \r\n-'()+,./:=?;!*#@$_%0123456789".indexOf(c2) != -1 || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') continue;
            this.fatal("P-016", new Object[]{new Character(c2)});
        }
        this.strTmp = new StringBuffer();
        this.strTmp.append(string);
        return this.normalize(false);
    }

    private boolean maybeComment(boolean bl2) throws IOException, SAXException {
        if (!this.in.peek(bl2 ? "!--" : "<!--", null)) {
            return false;
        }
        boolean bl3 = this.doLexicalPE;
        this.doLexicalPE = false;
        boolean bl4 = false;
        if (bl4) {
            this.strTmp = new StringBuffer();
        }
        block2: while (true) {
            try {
                while (true) {
                    char c2;
                    if ((c2 = this.getc()) == '-') {
                        c2 = this.getc();
                        if (c2 != '-') {
                            if (bl4) {
                                this.strTmp.append('-');
                            }
                            this.ungetc();
                            continue;
                        }
                        this.nextChar('>', "F-022", null);
                        break block2;
                    }
                    if (!bl4) continue;
                    this.strTmp.append(c2);
                }
            }
            catch (EndOfInputException endOfInputException) {
                if (this.in.isInternal()) {
                    this.error("V-021", null);
                }
                this.fatal("P-017");
                continue;
            }
            break;
        }
        this.doLexicalPE = bl3;
        if (bl4) {
            this.dtdHandler.comment(this.strTmp.toString());
        }
        return true;
    }

    private boolean maybePI(boolean bl2) throws IOException, SAXException {
        boolean bl3 = this.doLexicalPE;
        if (!this.in.peek(bl2 ? "?" : "<?", null)) {
            return false;
        }
        this.doLexicalPE = false;
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-018");
        }
        if ("xml".equals(string)) {
            this.fatal("P-019");
        }
        if ("xml".equalsIgnoreCase(string)) {
            this.fatal("P-020", new Object[]{string});
        }
        if (this.maybeWhitespace()) {
            this.strTmp = new StringBuffer();
            try {
                char c2;
                while ((c2 = this.in.getc()) != '?' || !this.in.peekc('>')) {
                    this.strTmp.append(c2);
                }
            }
            catch (EndOfInputException endOfInputException) {
                this.fatal("P-021");
            }
            this.dtdHandler.processingInstruction(string, this.strTmp.toString());
        } else {
            if (!this.in.peek("?>", null)) {
                this.fatal("P-022");
            }
            this.dtdHandler.processingInstruction(string, "");
        }
        this.doLexicalPE = bl3;
        return true;
    }

    private String maybeReadAttribute(String string, boolean bl2) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            if (!bl2) {
                return null;
            }
            this.fatal("P-024", new Object[]{string});
        }
        if (!this.peek(string)) {
            if (bl2) {
                this.fatal("P-024", new Object[]{string});
            } else {
                this.ungetc();
                return null;
            }
        }
        this.maybeWhitespace();
        this.nextChar('=', "F-023", null);
        this.maybeWhitespace();
        return this.getQuotedString("F-035", string);
    }

    private void readVersion(boolean bl2, String string) throws IOException, SAXException {
        String string2 = this.maybeReadAttribute("version", bl2);
        if (bl2 && string2 == null) {
            this.fatal("P-025", new Object[]{string});
        }
        if (string2 != null) {
            int n2 = string2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':' || c2 == '-') continue;
                this.fatal("P-026", new Object[]{string2});
            }
        }
        if (string2 != null && !string2.equals(string)) {
            this.error("P-027", new Object[]{string, string2});
        }
    }

    private String getMarkupDeclname(String string, boolean bl2) throws IOException, SAXException {
        this.whitespace(string);
        String string2 = this.maybeGetName();
        if (string2 == null) {
            this.fatal("P-005", new Object[]{messages.getMessage(this.locale, string)});
        }
        return string2;
    }

    private boolean maybeMarkupDecl() throws IOException, SAXException {
        return this.maybeElementDecl() || this.maybeAttlistDecl() || this.maybeEntityDecl() || this.maybeNotationDecl() || this.maybePI(false) || this.maybeComment(false);
    }

    private boolean isXmlLang(String string) {
        int n2;
        if (string.length() < 2) {
            return false;
        }
        char c2 = string.charAt(1);
        if (c2 == '-') {
            c2 = string.charAt(0);
            if (c2 != 'i' && c2 != 'I' && c2 != 'x' && c2 != 'X') {
                return false;
            }
            n2 = 1;
        } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
            c2 = string.charAt(0);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                return false;
            }
            n2 = 2;
        } else {
            return false;
        }
        while (n2 < string.length() && (c2 = string.charAt(n2)) == '-') {
            while (++n2 < string.length() && ((c2 = string.charAt(n2)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
            }
        }
        return string.length() == n2 && c2 != '-';
    }

    private boolean maybeElementDecl() throws IOException, SAXException {
        short s2;
        InputEntity inputEntity = this.peekDeclaration("!ELEMENT");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-015", true);
        if (this.declaredElements.contains(string)) {
            this.error("V-012", new Object[]{string});
        } else {
            this.declaredElements.add(string);
        }
        this.whitespace("F-000");
        if (this.peek(strEMPTY)) {
            s2 = 0;
            this.dtdHandler.startContentModel(string, (short)0);
        } else if (this.peek(strANY)) {
            s2 = 1;
            this.dtdHandler.startContentModel(string, (short)1);
        } else {
            s2 = this.getMixedOrChildren(string);
        }
        this.dtdHandler.endContentModel(string, s2);
        this.maybeWhitespace();
        char c2 = this.getc();
        if (c2 != '>') {
            this.fatal("P-036", new Object[]{string, new Character(c2)});
        }
        if (inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private short getMixedOrChildren(String string) throws IOException, SAXException {
        short s2;
        this.strTmp = new StringBuffer();
        this.nextChar('(', "F-028", string);
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        this.strTmp.append('(');
        if (this.peek("#PCDATA")) {
            this.strTmp.append("#PCDATA");
            s2 = 2;
            this.dtdHandler.startContentModel(string, (short)2);
            this.getMixed(string, inputEntity);
        } else {
            s2 = 3;
            this.dtdHandler.startContentModel(string, (short)3);
            this.getcps(string, inputEntity);
        }
        return s2;
    }

    private void getcps(String string, InputEntity inputEntity) throws IOException, SAXException {
        boolean bl2 = false;
        char c2 = '\u0000';
        this.dtdHandler.startModelGroup();
        block3: do {
            String string2;
            if ((string2 = this.maybeGetName()) != null) {
                this.strTmp.append(string2);
                this.dtdHandler.childElement(string2, this.getFrequency());
            } else if (this.peek("(")) {
                InputEntity inputEntity2 = this.in;
                this.strTmp.append('(');
                this.maybeWhitespace();
                this.getcps(string, inputEntity2);
            } else {
                this.fatal(c2 == '\u0000' ? "P-039" : (c2 == ',' ? "P-037" : "P-038"), new Object[]{new Character(this.getc())});
            }
            this.maybeWhitespace();
            if (bl2) {
                char c3 = this.getc();
                if (c3 == c2) {
                    this.strTmp.append(c2);
                    this.maybeWhitespace();
                    this.reportConnector(c2);
                    continue;
                }
                if (c3 == ')') {
                    this.ungetc();
                    continue;
                }
                this.fatal(c2 == '\u0000' ? "P-041" : "P-040", new Object[]{new Character(c3), new Character(c2)});
            } else {
                c2 = this.getc();
                switch (c2) {
                    case ',': 
                    case '|': {
                        this.reportConnector(c2);
                        break;
                    }
                    default: {
                        this.ungetc();
                        continue block3;
                    }
                }
                bl2 = true;
                this.strTmp.append(c2);
            }
            this.maybeWhitespace();
        } while (!this.peek(")"));
        if (this.in != inputEntity) {
            this.error("V-014", new Object[]{string});
        }
        this.strTmp.append(')');
        this.dtdHandler.endModelGroup(this.getFrequency());
    }

    private void reportConnector(char c2) throws SAXException {
        switch (c2) {
            case '|': {
                this.dtdHandler.connector((short)0);
                return;
            }
            case ',': {
                this.dtdHandler.connector((short)1);
                return;
            }
        }
        throw new Error();
    }

    private short getFrequency() throws IOException, SAXException {
        char c2 = this.getc();
        if (c2 == '?') {
            this.strTmp.append(c2);
            return 2;
        }
        if (c2 == '+') {
            this.strTmp.append(c2);
            return 1;
        }
        if (c2 == '*') {
            this.strTmp.append(c2);
            return 0;
        }
        this.ungetc();
        return 3;
    }

    private void getMixed(String string, InputEntity inputEntity) throws IOException, SAXException {
        this.maybeWhitespace();
        if (this.peek(")*") || this.peek(")")) {
            if (this.in != inputEntity) {
                this.error("V-014", new Object[]{string});
            }
            this.strTmp.append(')');
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.peek("|")) {
            this.strTmp.append('|');
            this.maybeWhitespace();
            this.doLexicalPE = true;
            String string2 = this.maybeGetName();
            if (string2 == null) {
                this.fatal("P-042", new Object[]{string, Integer.toHexString(this.getc())});
            }
            if (arrayList.contains(string2)) {
                this.error("V-015", new Object[]{string2});
            } else {
                arrayList.add(string2);
                this.dtdHandler.mixedElement(string2);
            }
            this.strTmp.append(string2);
            this.maybeWhitespace();
        }
        if (!this.peek(")*")) {
            this.fatal("P-043", new Object[]{string, new Character(this.getc())});
        }
        if (this.in != inputEntity) {
            this.error("V-014", new Object[]{string});
        }
        this.strTmp.append(')');
    }

    private boolean maybeAttlistDecl() throws IOException, SAXException {
        InputEntity inputEntity = this.peekDeclaration("!ATTLIST");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-016", true);
        while (!this.peek(">")) {
            short s2;
            String string2;
            String string3;
            this.maybeWhitespace();
            char c2 = this.getc();
            if (c2 == '%') {
                string3 = this.maybeGetName();
                if (string3 != null) {
                    this.nextChar(';', "F-021", string3);
                    this.whitespace("F-021");
                    continue;
                }
                this.fatal("P-011");
            }
            this.ungetc();
            string3 = this.maybeGetName();
            if (string3 == null) {
                this.fatal("P-044", new Object[]{new Character(this.getc())});
            }
            this.whitespace("F-001");
            Vector<String> vector = null;
            if (this.peek(TYPE_CDATA)) {
                string2 = TYPE_CDATA;
            } else if (this.peek(TYPE_IDREFS)) {
                string2 = TYPE_IDREFS;
            } else if (this.peek(TYPE_IDREF)) {
                string2 = TYPE_IDREF;
            } else if (this.peek(TYPE_ID)) {
                string2 = TYPE_ID;
            } else if (this.peek(TYPE_ENTITY)) {
                string2 = TYPE_ENTITY;
            } else if (this.peek(TYPE_ENTITIES)) {
                string2 = TYPE_ENTITIES;
            } else if (this.peek(TYPE_NMTOKENS)) {
                string2 = TYPE_NMTOKENS;
            } else if (this.peek(TYPE_NMTOKEN)) {
                string2 = TYPE_NMTOKEN;
            } else if (this.peek(TYPE_NOTATION)) {
                string2 = TYPE_NOTATION;
                this.whitespace("F-002");
                this.nextChar('(', "F-029", null);
                this.maybeWhitespace();
                vector = new Vector();
                do {
                    String string4;
                    if ((string4 = this.maybeGetName()) == null) {
                        this.fatal("P-068");
                    }
                    if (this.notations.get(string4) == null) {
                        this.notations.put(string4, string4);
                    }
                    vector.addElement(string4);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
            } else if (this.peek("(")) {
                string2 = TYPE_ENUMERATION;
                this.maybeWhitespace();
                vector = new Vector<String>();
                do {
                    String string5 = this.getNmtoken();
                    vector.addElement(string5);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
            } else {
                this.fatal("P-045", new Object[]{string3, new Character(this.getc())});
                string2 = null;
            }
            String string6 = null;
            this.whitespace("F-003");
            if (this.peek("#REQUIRED")) {
                s2 = 3;
            } else if (this.peek("#FIXED")) {
                if (string2 == TYPE_ID) {
                    this.error("V-017", new Object[]{string3});
                }
                s2 = 2;
                this.whitespace("F-004");
                this.parseLiteral(false);
                string6 = string2 == TYPE_CDATA ? this.normalize(false) : this.strTmp.toString();
            } else if (!this.peek("#IMPLIED")) {
                s2 = 1;
                if (string2 == TYPE_ID) {
                    this.error("V-018", new Object[]{string3});
                }
                this.parseLiteral(false);
                string6 = string2 == TYPE_CDATA ? this.normalize(false) : this.strTmp.toString();
            } else {
                s2 = 0;
            }
            if (XmlLang.equals(string3) && string6 != null && !this.isXmlLang(string6)) {
                this.error("P-033", new Object[]{string6});
            }
            String[] stringArray = vector != null ? vector.toArray(new String[0]) : null;
            this.dtdHandler.attributeDecl(string, string3, string2, stringArray, s2, string6);
            this.maybeWhitespace();
        }
        if (inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private String normalize(boolean bl2) {
        String string = this.strTmp.toString();
        String string2 = string.trim();
        boolean bl3 = false;
        if (string != string2) {
            string = string2;
            string2 = null;
            bl3 = true;
        }
        this.strTmp = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!XmlChars.isSpace(c2)) {
                this.strTmp.append(c2);
                continue;
            }
            this.strTmp.append(' ');
            while (++i2 < string.length() && XmlChars.isSpace(string.charAt(i2))) {
                bl3 = true;
            }
            --i2;
        }
        if (bl3) {
            return this.strTmp.toString();
        }
        return string;
    }

    private boolean maybeConditionalSect() throws IOException, SAXException {
        if (!this.peek("<![")) {
            return false;
        }
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-046");
        }
        this.maybeWhitespace();
        this.nextChar('[', "F-030", null);
        if ("INCLUDE".equals(string)) {
            while (true) {
                if (this.in.isEOF() && this.in != inputEntity) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.in.isEOF()) {
                    this.error("V-020", null);
                }
                if (!this.peek("]]>")) {
                    this.doLexicalPE = false;
                    if (this.maybeWhitespace() || this.maybePEReference()) continue;
                    this.doLexicalPE = true;
                    if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
                    this.fatal("P-047");
                    continue;
                }
                break;
            }
        } else if ("IGNORE".equals(string)) {
            int n2 = 1;
            this.doLexicalPE = false;
            while (n2 > 0) {
                char c2 = this.getc();
                if (c2 == '<') {
                    if (!this.peek("![")) continue;
                    ++n2;
                    continue;
                }
                if (c2 != ']' || !this.peek("]>")) continue;
                --n2;
            }
        } else {
            this.fatal("P-048", new Object[]{string});
        }
        return true;
    }

    private int parseCharNumber() throws IOException, SAXException {
        int n2 = 0;
        if (this.getc() != 'x') {
            this.ungetc();
            while (true) {
                char c2;
                if ((c2 = this.getc()) >= '0' && c2 <= '9') {
                    n2 *= 10;
                    n2 += c2 - 48;
                    continue;
                }
                if (c2 == ';') {
                    return n2;
                }
                this.fatal("P-049");
            }
        }
        while (true) {
            char c3;
            if ((c3 = this.getc()) >= '0' && c3 <= '9') {
                n2 <<= 4;
                n2 += c3 - 48;
                continue;
            }
            if (c3 >= 'a' && c3 <= 'f') {
                n2 <<= 4;
                n2 += 10 + (c3 - 97);
                continue;
            }
            if (c3 >= 'A' && c3 <= 'F') {
                n2 <<= 4;
                n2 += 10 + (c3 - 65);
                continue;
            }
            if (c3 == ';') {
                return n2;
            }
            this.fatal("P-050");
        }
    }

    private int surrogatesToCharTmp(int n2) throws SAXException {
        if (n2 <= 65535) {
            if (XmlChars.isChar(n2)) {
                this.charTmp[0] = (char)n2;
                return 1;
            }
        } else if (n2 <= 0x10FFFF) {
            this.charTmp[0] = (char)(0xD800 | (n2 -= 65536) >> 10 & 0x3FF);
            this.charTmp[1] = (char)(0xDC00 | n2 & 0x3FF);
            return 2;
        }
        this.fatal("P-051", new Object[]{Integer.toHexString(n2)});
        return -1;
    }

    private boolean maybePEReference() throws IOException, SAXException {
        if (!this.in.peekc('%')) {
            return false;
        }
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-011");
        }
        this.nextChar(';', "F-021", string);
        Object object = this.params.get(string);
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            this.pushReader(internalEntity.buf, string, false);
        } else if (object instanceof ExternalEntity) {
            this.pushReader((ExternalEntity)object);
            this.externalParameterEntity((ExternalEntity)object);
        } else if (object == null) {
            this.error("V-022", new Object[]{string});
        }
        return true;
    }

    private boolean maybeEntityDecl() throws IOException, SAXException {
        boolean bl2;
        SimpleHashtable simpleHashtable;
        InputEntity inputEntity = this.peekDeclaration("!ENTITY");
        if (inputEntity == null) {
            return false;
        }
        this.doLexicalPE = false;
        this.whitespace("F-005");
        if (this.in.peekc('%')) {
            this.whitespace("F-006");
            simpleHashtable = this.params;
        } else {
            simpleHashtable = this.entities;
        }
        this.ungetc();
        this.doLexicalPE = true;
        String string = this.getMarkupDeclname("F-017", false);
        this.whitespace("F-007");
        ExternalEntity externalEntity = this.maybeExternalID();
        boolean bl3 = bl2 = simpleHashtable.get(string) == null;
        if (!bl2 && simpleHashtable == this.entities) {
            this.warning("P-054", new Object[]{string});
        }
        if (externalEntity == null) {
            this.doLexicalPE = false;
            this.parseLiteral(true);
            this.doLexicalPE = true;
            if (bl2) {
                char[] cArray = new char[this.strTmp.length()];
                if (cArray.length != 0) {
                    this.strTmp.getChars(0, cArray.length, cArray, 0);
                }
                InternalEntity internalEntity = new InternalEntity(string, cArray);
                internalEntity.isPE = simpleHashtable == this.params;
                internalEntity.isFromInternalSubset = false;
                simpleHashtable.put(string, internalEntity);
                if (simpleHashtable == this.entities) {
                    this.dtdHandler.internalGeneralEntityDecl(string, new String(cArray));
                }
            }
        } else {
            if (simpleHashtable == this.entities && this.maybeWhitespace() && this.peek("NDATA")) {
                externalEntity.notation = this.getMarkupDeclname("F-018", false);
                if (this.notations.get(externalEntity.notation) == null) {
                    this.notations.put(externalEntity.notation, Boolean.TRUE);
                }
            }
            externalEntity.name = string;
            externalEntity.isPE = simpleHashtable == this.params;
            externalEntity.isFromInternalSubset = false;
            if (bl2) {
                simpleHashtable.put(string, externalEntity);
                if (externalEntity.notation != null) {
                    this.dtdHandler.unparsedEntityDecl(string, externalEntity.publicId, externalEntity.systemId, externalEntity.notation);
                } else if (simpleHashtable == this.entities) {
                    this.dtdHandler.externalGeneralEntityDecl(string, externalEntity.publicId, externalEntity.systemId);
                }
            }
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-031", string);
        if (inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private ExternalEntity maybeExternalID() throws IOException, SAXException {
        String string = null;
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            string = this.parsePublicId();
        } else if (!this.peek("SYSTEM")) {
            return null;
        }
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        externalEntity.publicId = string;
        this.whitespace("F-008");
        externalEntity.systemId = this.parseSystemId();
        return externalEntity;
    }

    private String parseSystemId() throws IOException, SAXException {
        String string = this.getQuotedString("F-034", null);
        int n2 = string.indexOf(58);
        if (n2 == -1 || string.indexOf(47) < n2) {
            String string2 = this.in.getSystemId();
            if (string2 == null) {
                this.fatal("P-055", new Object[]{string});
            }
            if (string.length() == 0) {
                string = ".";
            }
            string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
            if (string.charAt(0) != '/') {
                string = string2 + string;
            } else {
                throw new InternalError();
            }
        }
        if (string.indexOf(35) != -1) {
            this.error("P-056", new Object[]{string});
        }
        return string;
    }

    private void maybeTextDecl() throws IOException, SAXException {
        if (this.peek("<?xml")) {
            this.readVersion(false, "1.0");
            this.readEncoding(true);
            this.maybeWhitespace();
            if (!this.peek("?>")) {
                this.fatal("P-057");
            }
        }
    }

    private void externalParameterEntity(ExternalEntity externalEntity) throws IOException, SAXException {
        InputEntity inputEntity = this.in;
        this.maybeTextDecl();
        while (!inputEntity.isEOF()) {
            if (this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            this.doLexicalPE = false;
            if (this.maybeWhitespace() || this.maybePEReference()) continue;
            this.doLexicalPE = true;
            if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
        }
        if (!inputEntity.isEOF()) {
            this.fatal("P-059", new Object[]{this.in.getName()});
        }
    }

    private void readEncoding(boolean bl2) throws IOException, SAXException {
        String string = this.maybeReadAttribute("encoding", bl2);
        if (string == null) {
            return;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || i2 != 0 && (c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '_' || c2 == '.')) continue;
            this.fatal("P-060", new Object[]{new Character(c2)});
        }
        String string2 = this.in.getEncoding();
        if (string2 != null && !string.equalsIgnoreCase(string2)) {
            this.warning("P-061", new Object[]{string, string2});
        }
    }

    private boolean maybeNotationDecl() throws IOException, SAXException {
        Object object;
        InputEntity inputEntity = this.peekDeclaration("!NOTATION");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-019", false);
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        this.whitespace("F-011");
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            externalEntity.publicId = this.parsePublicId();
            if (this.maybeWhitespace()) {
                if (!this.peek(">")) {
                    externalEntity.systemId = this.parseSystemId();
                } else {
                    this.ungetc();
                }
            }
        } else if (this.peek("SYSTEM")) {
            this.whitespace("F-008");
            externalEntity.systemId = this.parseSystemId();
        } else {
            this.fatal("P-062");
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-032", string);
        if (inputEntity != this.in) {
            this.error("V-013", null);
        }
        if (externalEntity.systemId != null && externalEntity.systemId.indexOf(35) != -1) {
            this.error("P-056", new Object[]{externalEntity.systemId});
        }
        if ((object = this.notations.get(string)) != null && object instanceof ExternalEntity) {
            this.warning("P-063", new Object[]{string});
        } else {
            this.notations.put(string, externalEntity);
            this.dtdHandler.notationDecl(string, externalEntity.publicId, externalEntity.systemId);
        }
        return true;
    }

    private char getc() throws IOException, SAXException {
        if (!this.doLexicalPE) {
            char c2 = this.in.getc();
            return c2;
        }
        while (this.in.isEOF()) {
            if (this.in.isInternal() || this.doLexicalPE && !this.in.isDocument()) {
                this.in = this.in.pop();
                continue;
            }
            this.fatal("P-064", new Object[]{this.in.getName()});
        }
        char c3 = this.in.getc();
        if (c3 == '%' && this.doLexicalPE) {
            String string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-011");
            }
            this.nextChar(';', "F-021", string);
            Object object = this.params.get(string);
            this.pushReader(" ".toCharArray(), null, false);
            if (object instanceof InternalEntity) {
                this.pushReader(((InternalEntity)object).buf, string, false);
            } else if (object instanceof ExternalEntity) {
                this.pushReader((ExternalEntity)object);
            } else if (object == null) {
                this.fatal("V-022");
            } else {
                throw new InternalError();
            }
            this.pushReader(" ".toCharArray(), null, false);
            return this.in.getc();
        }
        return c3;
    }

    private void ungetc() {
        this.in.ungetc();
    }

    private boolean peek(String string) throws IOException, SAXException {
        return this.in.peek(string, null);
    }

    private InputEntity peekDeclaration(String string) throws IOException, SAXException {
        if (!this.in.peekc('<')) {
            return null;
        }
        InputEntity inputEntity = this.in;
        if (this.in.peek(string, null)) {
            return inputEntity;
        }
        this.in.ungetc();
        return null;
    }

    private void nextChar(char c2, String string, String string2) throws IOException, SAXException {
        while (this.in.isEOF() && !this.in.isDocument()) {
            this.in = this.in.pop();
        }
        if (!this.in.peekc(c2)) {
            this.fatal("P-008", new Object[]{new Character(c2), messages.getMessage(this.locale, string), string2 == null ? "" : '\"' + string2 + '\"'});
        }
    }

    private void pushReader(char[] cArray, String string, boolean bl2) throws SAXException {
        InputEntity inputEntity = InputEntity.getInputEntity(this.dtdHandler, this.locale);
        inputEntity.init(cArray, string, this.in, !bl2);
        this.in = inputEntity;
    }

    private boolean pushReader(ExternalEntity externalEntity) throws IOException, SAXException {
        InputSource inputSource;
        InputEntity inputEntity = InputEntity.getInputEntity(this.dtdHandler, this.locale);
        try {
            inputSource = externalEntity.getInputSource(this.resolver);
        }
        catch (IOException iOException) {
            String string = "unable to open the external entity from :" + externalEntity.systemId;
            if (externalEntity.publicId != null) {
                string = string + " (public id:" + externalEntity.publicId + ")";
            }
            SAXParseException sAXParseException = new SAXParseException(string, this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber(), iOException);
            this.dtdHandler.fatalError(sAXParseException);
            throw iOException;
        }
        inputEntity.init(inputSource, externalEntity.name, this.in, externalEntity.isPE);
        this.in = inputEntity;
        return true;
    }

    public String getPublicId() {
        return this.in == null ? null : this.in.getPublicId();
    }

    public String getSystemId() {
        return this.in == null ? null : this.in.getSystemId();
    }

    public int getLineNumber() {
        return this.in == null ? -1 : this.in.getLineNumber();
    }

    public int getColumnNumber() {
        return this.in == null ? -1 : this.in.getColumnNumber();
    }

    private void warning(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        this.dtdHandler.warning(sAXParseException);
    }

    void error(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        this.dtdHandler.error(sAXParseException);
    }

    private void fatal(String string) throws SAXException {
        this.fatal(string, null);
    }

    private void fatal(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        this.dtdHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }

    static final class Catalog
    extends MessageCatalog {
        Catalog() {
            super(DTDParser.class);
        }
    }

    static class NameCache {
        NameCacheEntry[] hashtable = new NameCacheEntry[541];

        NameCache() {
        }

        String lookup(char[] cArray, int n2) {
            return this.lookupEntry((char[])cArray, (int)n2).name;
        }

        NameCacheEntry lookupEntry(char[] cArray, int n2) {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = n3 * 31 + cArray[i2];
            }
            n3 &= Integer.MAX_VALUE;
            NameCacheEntry nameCacheEntry = this.hashtable[n3 %= this.hashtable.length];
            while (nameCacheEntry != null) {
                if (nameCacheEntry.matches(cArray, n2)) {
                    return nameCacheEntry;
                }
                nameCacheEntry = nameCacheEntry.next;
            }
            nameCacheEntry = new NameCacheEntry();
            nameCacheEntry.chars = new char[n2];
            System.arraycopy(cArray, 0, nameCacheEntry.chars, 0, n2);
            nameCacheEntry.name = new String(nameCacheEntry.chars);
            nameCacheEntry.name = nameCacheEntry.name.intern();
            nameCacheEntry.next = this.hashtable[n3];
            this.hashtable[n3] = nameCacheEntry;
            return nameCacheEntry;
        }
    }

    static class NameCacheEntry {
        String name;
        char[] chars;
        NameCacheEntry next;

        NameCacheEntry() {
        }

        boolean matches(char[] cArray, int n2) {
            if (this.chars.length != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (cArray[i2] == this.chars[i2]) continue;
                return false;
            }
            return true;
        }
    }
}

