/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.StringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.driver.textui.Debug;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.IDContextProvider2;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.DatatypeRef;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StringRef;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.AbstractVerifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.Acceptor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.DocumentDeclaration;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.ErrorInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.IVerifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.ValidationUnrecoverableException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.ValidityViolation;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class Verifier
extends AbstractVerifier
implements IVerifier {
    protected Acceptor current;
    Context stack = null;
    private int stringCareLevel = 2;
    private StringBuffer text = new StringBuffer();
    protected ErrorHandler errorHandler;
    protected boolean hadError;
    private boolean isFinished;
    private final StartTagInfo sti = new StartTagInfo(null, null, null, null, (IDContextProvider2)null);
    protected final DocumentDeclaration docDecl;
    protected int panicLevel = 0;
    private int initialPanicLevel = 3;
    private static final int DEFAULT_PANIC_LEVEL = 3;
    private final DatatypeRef characterType = new DatatypeRef();
    private final DatatypeRef attributeType = new DatatypeRef();
    private Set<String> duplicateIds;
    public static final String ERR_UNEXPECTED_TEXT = "Verifier.Error.UnexpectedText";
    public static final String ERR_UNEXPECTED_ATTRIBUTE = "Verifier.Error.UnexpectedAttribute";
    public static final String ERR_MISSING_ATTRIBUTE = "Verifier.Error.MissingAttribute";
    public static final String ERR_UNEXPECTED_STARTTAG = "Verifier.Error.UnexpectedStartTag";
    public static final String ERR_UNCOMPLETED_CONTENT = "Verifier.Error.UncompletedContent";
    public static final String ERR_UNEXPECTED_ELEMENT = "Verifier.Error.UnexpectedElement";
    public static final String ERR_UNSOLD_IDREF = "Verifier.Error.UnsoldIDREF";
    public static final String ERR_DUPLICATE_ID = "Verifier.Error.DuplicateId";

    @Override
    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final boolean isValid() {
        return !this.hadError && this.isFinished;
    }

    @Override
    public final void setPanicMode(boolean bl2) {
        this.initialPanicLevel = bl2 ? 3 : 0;
    }

    public Verifier(DocumentDeclaration documentDeclaration, ErrorHandler errorHandler) {
        this.docDecl = documentDeclaration;
        this.errorHandler = errorHandler;
    }

    @Override
    public Datatype[] getLastCharacterType() {
        return this.characterType.types;
    }

    protected void verifyText() throws SAXException {
        this.characterType.types = null;
        block0 : switch (this.stringCareLevel) {
            case 0: {
                int n2 = this.text.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char c2 = this.text.charAt(i2);
                    if (c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n') continue;
                    this.onError(null, Verifier.localizeMessage(ERR_UNEXPECTED_TEXT, null), new ErrorInfo.BadText(this.text));
                    break block0;
                }
                break;
            }
            case 2: {
                String string = new String(this.text);
                if (this.current.onText2(string, this, null, this.characterType)) break;
                StringRef stringRef = new StringRef();
                this.characterType.types = null;
                this.current.onText2(string, this, stringRef, this.characterType);
                this.onError(stringRef, Verifier.localizeMessage(ERR_UNEXPECTED_TEXT, null), new ErrorInfo.BadText(this.text));
                break;
            }
            case 1: {
                if (this.text.length() != 0) {
                    throw new Error();
                }
                return;
            }
            default: {
                throw new Error();
            }
        }
        if (this.text.length() != 0) {
            this.text = new StringBuffer();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string3;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        super.startElement(string, string2, string3, attributes);
        if (Debug.debug) {
            System.out.println("\n-- startElement(" + string3 + ")" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        }
        this.verifyText();
        this.stack = new Context(this.stack, this.current, this.stringCareLevel, this.panicLevel);
        this.sti.reinit(string, string2, string3, attributes, this);
        Acceptor acceptor = this.current.createChildAcceptor(this.sti, null);
        this.panicLevel = Math.max(this.panicLevel - 1, 0);
        if (acceptor == null) {
            if (Debug.debug) {
                System.out.println("-- no children accepted: error recovery");
            }
            StringRef stringRef = new StringRef();
            acceptor = this.current.createChildAcceptor(this.sti, stringRef);
            ValidityViolation validityViolation = this.onError(stringRef, Verifier.localizeMessage(ERR_UNEXPECTED_STARTTAG, new Object[]{string3}), new ErrorInfo.BadTagName(this.sti));
            if (acceptor == null) {
                if (Debug.debug) {
                    System.out.println("-- unable to recover");
                }
                throw new ValidationUnrecoverableException(validityViolation);
            }
        }
        this.onNextAcceptorReady(this.sti, acceptor);
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.feedAttribute(acceptor, attributes.getURI(i2), attributes.getLocalName(i2), attributes.getQName(i2), attributes.getValue(i2));
        }
        if (!acceptor.onEndAttributes(this.sti, null)) {
            if (Debug.debug) {
                System.out.println("-- required attributes missing: error recovery");
            }
            StringRef stringRef = new StringRef();
            acceptor.onEndAttributes(this.sti, stringRef);
            this.onError(stringRef, Verifier.localizeMessage(ERR_MISSING_ATTRIBUTE, new Object[]{string3}), new ErrorInfo.MissingAttribute(this.sti));
        }
        this.stack.panicLevel = this.panicLevel;
        this.stringCareLevel = acceptor.getStringCareLevel();
        if (this.stringCareLevel == 1) {
            this.characterType.types = new Datatype[]{StringType.theInstance};
        }
        this.current = acceptor;
    }

    protected void onNextAcceptorReady(StartTagInfo startTagInfo, Acceptor acceptor) throws SAXException {
    }

    protected Datatype[] feedAttribute(Acceptor acceptor, String string, String string2, String string3, String string4) throws SAXException {
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string3;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        if (string3.startsWith("xmlns:") || string3.equals("xmlns")) {
            return new Datatype[0];
        }
        if (Debug.debug) {
            System.out.println("-- processing attribute: @" + string3);
        }
        this.attributeType.types = null;
        if (!acceptor.onAttribute2(string, string2, string3, string4, this, null, this.attributeType)) {
            if (Debug.debug) {
                System.out.println("-- bad attribute: error recovery");
            }
            StringRef stringRef = new StringRef();
            acceptor.onAttribute2(string, string2, string3, string4, this, stringRef, null);
            this.onError(stringRef, Verifier.localizeMessage(ERR_UNEXPECTED_ATTRIBUTE, new Object[]{string3}), new ErrorInfo.BadAttribute(this.sti, string3, string, string2, string4));
        }
        return this.attributeType.types;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string3;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        if (Debug.debug) {
            System.out.println("\n-- endElement(" + string3 + ")" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        }
        this.verifyText();
        if (!this.current.isAcceptState(null) && this.panicLevel == 0) {
            object = new StringRef();
            this.current.isAcceptState((StringRef)object);
            this.onError((StringRef)object, Verifier.localizeMessage(ERR_UNCOMPLETED_CONTENT, new Object[]{string3}), new ErrorInfo.IncompleteContentModel(string3, string, string2));
        }
        object = this.current;
        this.current = this.stack.acceptor;
        this.stringCareLevel = this.stack.stringCareLevel;
        this.panicLevel = Math.max(this.panicLevel, this.stack.panicLevel);
        this.stack = this.stack.previous;
        if (!this.current.stepForward((Acceptor)object, null)) {
            StringRef stringRef = new StringRef();
            this.current.stepForward((Acceptor)object, stringRef);
            this.onError(stringRef, Verifier.localizeMessage(ERR_UNEXPECTED_ELEMENT, new Object[]{string3}), null);
        } else {
            this.panicLevel = Math.max(this.panicLevel - 1, 0);
        }
        super.endElement(string, string2, string3);
    }

    protected ValidityViolation onError(StringRef stringRef, String string, ErrorInfo errorInfo) throws SAXException {
        if (stringRef == null) {
            return this.onError(string, errorInfo);
        }
        if (stringRef.str == null) {
            return this.onError(string, errorInfo);
        }
        return this.onError(stringRef.str, errorInfo);
    }

    protected ValidityViolation onError(String string, ErrorInfo errorInfo) throws SAXException {
        ValidityViolation validityViolation = new ValidityViolation(this.locator, string, errorInfo);
        this.hadError = true;
        if (this.errorHandler != null && this.panicLevel == 0) {
            this.errorHandler.error(validityViolation);
        }
        this.panicLevel = this.initialPanicLevel;
        return validityViolation;
    }

    @Override
    public Object getCurrentElementType() {
        return this.current.getOwnerType();
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.stringCareLevel != 1) {
            this.text.append(cArray, n2, n3);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (this.stringCareLevel != 1 && this.stringCareLevel != 0) {
            this.text.append(cArray, n2, n3);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.hadError = false;
        this.isFinished = false;
        this.text = new StringBuffer();
        this.stack = null;
        if (this.duplicateIds != null) {
            this.duplicateIds.clear();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
        this.current = this.docDecl.createAcceptor();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.performIDcheck) {
            if (!this.ids.keySet().containsAll(this.idrefs)) {
                this.hadError = true;
                for (Object object : this.idrefs) {
                    if (this.ids.keySet().contains(object)) continue;
                    this.onError(Verifier.localizeMessage(ERR_UNSOLD_IDREF, new Object[]{object}), null);
                }
            }
            if (this.duplicateIds != null) {
                for (Object object : this.duplicateIds) {
                    this.onError(Verifier.localizeMessage(ERR_DUPLICATE_ID, new Object[]{object}), null);
                }
            }
        }
        this.isFinished = true;
    }

    @Override
    public void onDuplicateId(String string) {
        if (this.duplicateIds == null) {
            this.duplicateIds = new HashSet<String>();
        }
        this.duplicateIds.add(string);
    }

    public static String localizeMessage(String string, Object[] objectArray) {
        String string2 = ResourceBundle.getBundle("com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.Messages").getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    private static final class Context {
        final Context previous;
        final Acceptor acceptor;
        final int stringCareLevel;
        int panicLevel;

        Context(Context context, Acceptor acceptor, int n2, int n3) {
            this.previous = context;
            this.acceptor = acceptor;
            this.stringCareLevel = n2;
            this.panicLevel = n3;
        }
    }
}

