/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.relaxng;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.BinaryExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DifferenceNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionCloner;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Grammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClassVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NamespaceNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SimpleNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util.ExpressionWalker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util.PossibleNamesCollector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StringPair;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.GrammarWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.SAXRuntimeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.XMLWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.relaxng.Context;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.relaxng.NameClassWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.relaxng.PatternWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class RELAXNGWriter
implements GrammarWriter,
Context {
    protected XMLWriter writer = new XMLWriter();
    protected Grammar grammar;
    protected Map<Expression, String> exp2name;
    protected String defaultNs;
    protected NameClassVisitor nameClassWriter;
    protected SmartPatternWriter patternWriter = new SmartPatternWriter(this);

    @Override
    public XMLWriter getWriter() {
        return this.writer;
    }

    @Override
    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.writer.setDocumentHandler(documentHandler);
    }

    @Override
    public void write(Grammar grammar) throws SAXException {
        this.write(grammar, this.sniffDefaultNs(grammar.getTopLevel()));
    }

    public void write(Grammar grammar, String string) throws SAXException {
        Object object;
        this.defaultNs = string;
        this.grammar = grammar;
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        grammar.getTopLevel().visit(new ExpressionWalker(){

            @Override
            public void onElement(ElementExp elementExp) {
                if (hashSet.contains(elementExp)) {
                    hashSet2.add(elementExp);
                    return;
                }
                hashSet.add(elementExp);
                super.onElement(elementExp);
            }

            @Override
            public void onRef(ReferenceExp referenceExp) {
                if (hashSet.contains(referenceExp)) {
                    hashSet2.add(referenceExp);
                    return;
                }
                hashSet.add(referenceExp);
                super.onRef(referenceExp);
            }
        });
        HashMap<String, Expression> hashMap = new HashMap<String, Expression>();
        int n2 = 0;
        for (Expression expression : hashSet2) {
            if (expression instanceof ReferenceExp) {
                object = (ReferenceExp)expression;
                if (((ReferenceExp)object).name == null) {
                    while (hashMap.containsKey("anonymous" + n2)) {
                        ++n2;
                    }
                    hashMap.put("anonymous" + n2, expression);
                    continue;
                }
                if (hashMap.containsKey(((ReferenceExp)object).name)) {
                    int n3 = 2;
                    while (hashMap.containsKey(((ReferenceExp)object).name + n3)) {
                        ++n3;
                    }
                    hashMap.put(((ReferenceExp)object).name + n3, expression);
                    continue;
                }
                hashMap.put(((ReferenceExp)object).name, expression);
                continue;
            }
            if (expression instanceof ElementExp) {
                object = (ElementExp)expression;
                NameClass nameClass = ((ElementExp)object).getNameClass();
                if (nameClass instanceof SimpleNameClass && !hashMap.containsKey(((SimpleNameClass)nameClass).localName)) {
                    hashMap.put(((SimpleNameClass)nameClass).localName, expression);
                    continue;
                }
                while (hashMap.containsKey("element" + n2)) {
                    ++n2;
                }
                hashMap.put("element" + n2, expression);
                continue;
            }
            throw new Error();
        }
        this.exp2name = new HashMap<Expression, String>();
        for (Iterator<Expression> iterator : hashMap.keySet()) {
            Expression expression;
            expression = (Expression)hashMap.get(iterator);
            this.exp2name.put(expression, (String)((Object)iterator));
        }
        this.nameClassWriter = this.createNameClassWriter();
        try {
            DocumentHandler documentHandler = this.writer.getDocumentHandler();
            documentHandler.setDocumentLocator(new LocatorImpl());
            documentHandler.startDocument();
            if (this.defaultNs != null) {
                this.writer.start("grammar", new String[]{"ns", this.defaultNs, "xmlns", "http://relaxng.org/ns/structure/1.0", "datatypeLibrary", "http://www.w3.org/2001/XMLSchema-datatypes"});
            } else {
                this.writer.start("grammar", new String[]{"xmlns", "http://relaxng.org/ns/structure/1.0", "datatypeLibrary", "http://www.w3.org/2001/XMLSchema-datatypes"});
            }
            this.writer.start("start");
            this.writeIsland(grammar.getTopLevel());
            this.writer.end("start");
            for (Expression expression : this.exp2name.keySet()) {
                object = this.exp2name.get(expression);
                if (expression instanceof ReferenceExp) {
                    expression = ((ReferenceExp)expression).exp;
                }
                String string2 = this.cleanName((String)object);
                this.writer.start("define", new String[]{"name", string2});
                this.writeIsland(expression);
                this.writer.end("define");
            }
            this.writer.end("grammar");
            documentHandler.endDocument();
        }
        catch (SAXRuntimeException sAXRuntimeException) {
            throw sAXRuntimeException.e;
        }
    }

    private String cleanName(String string) {
        return string.replaceAll("[():#/]", "_");
    }

    protected void writeIsland(Expression expression) {
        if (expression instanceof ElementExp) {
            this.patternWriter.writeElement((ElementExp)expression);
        } else {
            this.patternWriter.visitUnary(expression);
        }
    }

    protected String sniffDefaultNs(Expression expression) {
        return (String)expression.visit(new ExpressionVisitor(){

            @Override
            public Object onElement(ElementExp elementExp) {
                return this.sniff(elementExp.getNameClass());
            }

            @Override
            public Object onAttribute(AttributeExp attributeExp) {
                return this.sniff(attributeExp.nameClass);
            }

            protected String sniff(NameClass nameClass) {
                if (nameClass instanceof SimpleNameClass) {
                    return ((SimpleNameClass)nameClass).namespaceURI;
                }
                return null;
            }

            @Override
            public Object onChoice(ChoiceExp choiceExp) {
                return this.onBinExp(choiceExp);
            }

            @Override
            public Object onSequence(SequenceExp sequenceExp) {
                return this.onBinExp(sequenceExp);
            }

            @Override
            public Object onInterleave(InterleaveExp interleaveExp) {
                return this.onBinExp(interleaveExp);
            }

            @Override
            public Object onConcur(ConcurExp concurExp) {
                return this.onBinExp(concurExp);
            }

            public Object onBinExp(BinaryExp binaryExp) {
                Object object = binaryExp.exp1.visit(this);
                if (object == null) {
                    object = binaryExp.exp2.visit(this);
                }
                return object;
            }

            @Override
            public Object onMixed(MixedExp mixedExp) {
                return mixedExp.exp.visit(this);
            }

            @Override
            public Object onOneOrMore(OneOrMoreExp oneOrMoreExp) {
                return oneOrMoreExp.exp.visit(this);
            }

            @Override
            public Object onRef(ReferenceExp referenceExp) {
                return referenceExp.exp.visit(this);
            }

            @Override
            public Object onOther(OtherExp otherExp) {
                return otherExp.exp.visit(this);
            }

            @Override
            public Object onNullSet() {
                return null;
            }

            @Override
            public Object onEpsilon() {
                return null;
            }

            @Override
            public Object onAnyString() {
                return null;
            }

            @Override
            public Object onData(DataExp dataExp) {
                return null;
            }

            @Override
            public Object onValue(ValueExp valueExp) {
                return null;
            }

            @Override
            public Object onList(ListExp listExp) {
                return null;
            }
        });
    }

    @Override
    public String getTargetNamespace() {
        return this.defaultNs;
    }

    @Override
    public void writeNameClass(NameClass nameClass) {
        String string = "\u0000";
        Set<StringPair> set = PossibleNamesCollector.calc(nameClass);
        StringPair[] stringPairArray = set.toArray(new StringPair[set.size()]);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < stringPairArray.length; ++i2) {
            hashSet.add(stringPairArray[i2].namespaceURI);
        }
        NameClass nameClass2 = null;
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (stringArray[i3] == "\u0000") continue;
            NameClass nameClass3 = null;
            for (int i4 = 0; i4 < stringPairArray.length; ++i4) {
                if (!stringPairArray[i4].namespaceURI.equals(stringArray[i3]) || stringPairArray[i4].localName == "\u0000" || nameClass.accepts(stringPairArray[i4]) == nameClass.accepts(stringArray[i3], "\u0000")) continue;
                nameClass3 = nameClass3 == null ? new SimpleNameClass(stringPairArray[i4]) : new ChoiceNameClass(nameClass3, new SimpleNameClass(stringPairArray[i4]));
            }
            if (nameClass.accepts(stringArray[i3], "\u0000") != nameClass.accepts("\u0000", "\u0000")) {
                nameClass3 = nameClass3 == null ? new NamespaceNameClass(stringArray[i3]) : new DifferenceNameClass(new NamespaceNameClass(stringArray[i3]), nameClass3);
            }
            nameClass2 = nameClass2 == null ? nameClass3 : new ChoiceNameClass(nameClass2, nameClass3);
        }
        if (nameClass.accepts("\u0000", "\u0000")) {
            nameClass2 = nameClass2 == null ? NameClass.ALL : new DifferenceNameClass(NameClass.ALL, nameClass2);
        } else if (nameClass2 == null) {
            this.writer.element("anyName");
            this.writer.element("notAllowed");
            return;
        }
        nameClass2.visit(this.nameClassWriter);
    }

    protected NameClassVisitor createNameClassWriter() {
        return new NameClassWriter(this);
    }

    class SmartPatternWriter
    extends PatternWriter {
        SmartPatternWriter(Context context) {
            super(context);
        }

        @Override
        public void onOther(OtherExp otherExp) {
            otherExp.exp.visit(this);
        }

        @Override
        public void onRef(ReferenceExp referenceExp) {
            String string = RELAXNGWriter.this.exp2name.get(referenceExp);
            if (string != null) {
                this.writer.element("ref", new String[]{"name", RELAXNGWriter.this.cleanName(string)});
            } else {
                referenceExp.exp.visit(this);
            }
        }

        @Override
        public void onElement(ElementExp elementExp) {
            String string = RELAXNGWriter.this.exp2name.get(elementExp);
            if (string != null) {
                this.writer.element("ref", new String[]{"name", RELAXNGWriter.this.cleanName(string)});
                return;
            }
            this.writeElement(elementExp);
        }

        @Override
        public void onAttribute(AttributeExp attributeExp) {
            if (attributeExp.nameClass instanceof SimpleNameClass && ((SimpleNameClass)attributeExp.nameClass).namespaceURI.equals("")) {
                this.writer.start("attribute", new String[]{"name", ((SimpleNameClass)attributeExp.nameClass).localName});
            } else {
                this.writer.start("attribute");
                this.context.writeNameClass(attributeExp.nameClass);
            }
            if (attributeExp.exp != Expression.anyString) {
                this.visitUnary(attributeExp.exp);
            }
            this.writer.end("attribute");
        }

        protected void writeElement(ElementExp elementExp) {
            NameClass nameClass = elementExp.getNameClass();
            if (nameClass instanceof SimpleNameClass && ((SimpleNameClass)nameClass).namespaceURI.equals(RELAXNGWriter.this.defaultNs)) {
                this.writer.start("element", new String[]{"name", ((SimpleNameClass)nameClass).localName});
            } else {
                this.writer.start("element");
                RELAXNGWriter.this.writeNameClass(elementExp.getNameClass());
            }
            this.visitUnary(this.simplify(elementExp.contentModel));
            this.writer.end("element");
        }

        public Expression simplify(Expression expression) {
            return expression.visit(new ExpressionCloner(RELAXNGWriter.this.grammar.getPool()){

                @Override
                public Expression onRef(ReferenceExp referenceExp) {
                    if (RELAXNGWriter.this.exp2name.containsKey(referenceExp)) {
                        return referenceExp;
                    }
                    return referenceExp.exp.visit(this);
                }

                @Override
                public Expression onOther(OtherExp otherExp) {
                    return otherExp.exp.visit(this);
                }

                @Override
                public Expression onElement(ElementExp elementExp) {
                    return elementExp;
                }

                @Override
                public Expression onAttribute(AttributeExp attributeExp) {
                    return attributeExp;
                }
            });
        }
    }
}

