/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Optional;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import com.gradle.maven.extension.internal.dep.com.google.common.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ByteSource {
    protected ByteSource() {
    }

    public abstract InputStream openStream() throws IOException;

    public Optional<Long> sizeIfKnown() {
        return Optional.absent();
    }

    public long copyTo(OutputStream outputStream) throws IOException {
        Preconditions.checkNotNull(outputStream);
        try (Closer closer = Closer.create();){
            InputStream inputStream = closer.register(this.openStream());
            long l2 = ByteStreams.copy(inputStream, outputStream);
            return l2;
        }
    }

    public byte[] read() throws IOException {
        try (Closer closer = Closer.create();){
            InputStream inputStream = closer.register(this.openStream());
            Optional<Long> optional = this.sizeIfKnown();
            byte[] byArray = optional.isPresent() ? ByteStreams.toByteArray(inputStream, optional.get()) : ByteStreams.toByteArray(inputStream);
            return byArray;
        }
    }
}

