/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.IntsMethodsForWeb;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.Longs;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;

public final class Ints
extends IntsMethodsForWeb {
    public static int hashCode(int n2) {
        return n2;
    }

    public static int saturatedCast(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l2;
    }

    public static int compare(int n2, int n3) {
        return n2 < n3 ? -1 : (n2 > n3 ? 1 : 0);
    }

    private static int indexOf(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = n3; i2 < n4; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = n4 - 1; i2 >= n3; --i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static List<Integer> asList(int ... nArray) {
        if (nArray.length == 0) {
            return Collections.emptyList();
        }
        return new IntArrayAsList(nArray);
    }

    public static Integer tryParse(String string) {
        return Ints.tryParse(string, 10);
    }

    public static Integer tryParse(String string, int n2) {
        Long l2 = Longs.tryParse(string, n2);
        if (l2 == null || l2 != (long)l2.intValue()) {
            return null;
        }
        return l2.intValue();
    }

    private static class IntArrayAsList
    extends AbstractList<Integer>
    implements Serializable,
    RandomAccess {
        final int[] array;
        final int start;
        final int end;

        IntArrayAsList(int[] nArray) {
            this(nArray, 0, nArray.length);
        }

        IntArrayAsList(int[] nArray, int n2, int n3) {
            this.array = nArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Integer get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        public Spliterator.OfInt spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Integer && Ints.indexOf(this.array, (Integer)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Integer && (n2 = Ints.indexOf(this.array, (Integer)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Integer && (n2 = Ints.lastIndexOf(this.array, (Integer)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Integer set(int n2, Integer n3) {
            Preconditions.checkElementIndex(n2, this.size());
            int n4 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(n3);
            return n4;
        }

        @Override
        public List<Integer> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new IntArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayAsList) {
                IntArrayAsList intArrayAsList = (IntArrayAsList)object;
                int n2 = this.size();
                if (intArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == intArrayAsList.array[intArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Ints.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 5);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }
    }
}

