/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DataTypeWithFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DataTypeWithLexicalConstraintFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;

public class TotalDigitsFacet
extends DataTypeWithLexicalConstraintFacet {
    public final int precision;
    private static final long serialVersionUID = 1L;

    public TotalDigitsFacet(String string, String string2, XSDatatypeImpl xSDatatypeImpl, int n2, boolean bl2) throws DatatypeException {
        super(string, string2, xSDatatypeImpl, "totalDigits", bl2);
        this.precision = n2;
        DataTypeWithFacet dataTypeWithFacet = xSDatatypeImpl.getFacetObject("totalDigits");
        if (dataTypeWithFacet != null && ((TotalDigitsFacet)dataTypeWithFacet).precision < this.precision) {
            throw new DatatypeException(TotalDigitsFacet.localize("LoosenedFacet", "totalDigits", dataTypeWithFacet.displayName()));
        }
    }

    @Override
    protected boolean checkLexicalConstraint(String string) {
        return TotalDigitsFacet.countPrecision(string) <= this.precision;
    }

    @Override
    protected void diagnoseByFacet(String string, ValidationContext validationContext) throws DatatypeException {
        int n2 = TotalDigitsFacet.countPrecision(string);
        if (n2 <= this.precision) {
            return;
        }
        throw new DatatypeException(-1, TotalDigitsFacet.localize("DataTypeErrorDiagnosis.TooMuchPrecision", new Integer(n2), new Integer(this.precision)));
    }

    protected static int countPrecision(String string) {
        int n2 = string.length();
        boolean bl2 = true;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '.') {
                bl2 = false;
                bl3 = true;
            }
            if (bl2) {
                if ('1' > c2 || c2 > '9') continue;
                ++n3;
                bl2 = false;
                continue;
            }
            n4 = bl3 && c2 == '0' ? ++n4 : 0;
            if ('0' > c2 || c2 > '9') continue;
            ++n3;
        }
        return n3 - n4;
    }
}

