/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.stax;

import aQute.bnd.annotation.spi.ServiceProvider;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.InputConfigFlags;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dom.WstxDOMWrappingReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDSubset;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.DefaultEventAllocator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt.WstxEventReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BranchingReaderSource;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.DefaultInputResolver;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.InputBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.InputSourceFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.ReaderBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.StreamBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.ReaderCreator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.ValidatingStreamReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DefaultXmlSymbolTable;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.SimpleCache;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.SymbolTable;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.URLUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLEventReader2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLInputFactory2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamReader2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.io.Stax2ByteArraySource;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.io.Stax2Source;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.Stax2FilteredStreamReader;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.Stax2ReaderAdapter;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.Stax2EventReaderAdapter;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.evt.Stax2FilteredEventReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

@ServiceProvider(value=XMLInputFactory.class)
public class WstxInputFactory
extends XMLInputFactory2
implements InputConfigFlags,
ReaderCreator {
    static final int MAX_SYMBOL_TABLE_SIZE = 12000;
    static final int MAX_SYMBOL_TABLE_GENERATIONS = 500;
    protected final ReaderConfig mConfig;
    protected XMLEventAllocator mAllocator = null;
    protected SimpleCache<DTDId, DTDSubset> mDTDCache = null;
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    private SymbolTable mSymbols = mRootSymbols;

    public WstxInputFactory() {
        this.mConfig = ReaderConfig.createFullDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbol(String string) {
        SymbolTable symbolTable = this.mSymbols;
        synchronized (symbolTable) {
            this.mSymbols.findSymbol(string);
        }
    }

    @Override
    public synchronized DTDSubset findCachedDTD(DTDId dTDId) {
        return this.mDTDCache == null ? null : this.mDTDCache.find(dTDId);
    }

    @Override
    public synchronized void updateSymbolTable(SymbolTable symbolTable) {
        SymbolTable symbolTable2 = this.mSymbols;
        if (symbolTable.isDirectChildOf(symbolTable2)) {
            if (symbolTable.size() > 12000 || symbolTable.version() > 500) {
                this.mSymbols = mRootSymbols;
            } else {
                this.mSymbols.mergeChild(symbolTable);
            }
        }
    }

    @Override
    public synchronized void addCachedDTD(DTDId dTDId, DTDSubset dTDSubset) {
        if (this.mDTDCache == null) {
            this.mDTDCache = new SimpleCache(this.mConfig.getDtdCacheSize());
        }
        this.mDTDCache.add(dTDId, dTDSubset);
    }

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader xMLEventReader, EventFilter eventFilter) {
        return new Stax2FilteredEventReader(Stax2EventReaderAdapter.wrapIfNecessary(xMLEventReader), eventFilter);
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader xMLStreamReader, StreamFilter streamFilter) throws XMLStreamException {
        Stax2FilteredStreamReader stax2FilteredStreamReader = new Stax2FilteredStreamReader(xMLStreamReader, streamFilter);
        if (!streamFilter.accept(stax2FilteredStreamReader)) {
            stax2FilteredStreamReader.next();
        }
        return stax2FilteredStreamReader;
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream inputStream) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, inputStream, null, true, false));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream inputStream, String string) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, inputStream, string, true, false));
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, reader, true, false));
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(source, true));
    }

    @Override
    public XMLEventReader createXMLEventReader(String string, InputStream inputStream) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(SystemId.construct(string), inputStream, null, true, false));
    }

    @Override
    public XMLEventReader createXMLEventReader(String string, Reader reader) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(SystemId.construct(string), reader, true, false));
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), Stax2ReaderAdapter.wrapIfNecessary(xMLStreamReader));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return this.createSR(null, inputStream, null, false, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream inputStream, String string) throws XMLStreamException {
        return this.createSR(null, inputStream, string, false, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return this.createSR(null, reader, false, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.createSR(source, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String string, InputStream inputStream) throws XMLStreamException {
        return this.createSR(SystemId.construct(string), inputStream, null, false, false);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String string, Reader reader) throws XMLStreamException {
        return this.createSR(SystemId.construct(string), reader, false, false);
    }

    @Override
    public Object getProperty(String string) {
        Object object = this.mConfig.getProperty(string);
        if (object == null && string.equals("javax.xml.stream.allocator")) {
            return this.getEventAllocator();
        }
        return object;
    }

    @Override
    public void setProperty(String string, Object object) {
        if (!this.mConfig.setProperty(string, object) && "javax.xml.stream.allocator".equals(string)) {
            this.setEventAllocator((XMLEventAllocator)object);
        }
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return this.mAllocator;
    }

    @Override
    public XMLReporter getXMLReporter() {
        return this.mConfig.getXMLReporter();
    }

    @Override
    public XMLResolver getXMLResolver() {
        return this.mConfig.getXMLResolver();
    }

    @Override
    public boolean isPropertySupported(String string) {
        return this.mConfig.isPropertySupported(string);
    }

    @Override
    public void setEventAllocator(XMLEventAllocator xMLEventAllocator) {
        this.mAllocator = xMLEventAllocator;
    }

    @Override
    public void setXMLReporter(XMLReporter xMLReporter) {
        this.mConfig.setXMLReporter(xMLReporter);
    }

    @Override
    public void setXMLResolver(XMLResolver xMLResolver) {
        this.mConfig.setXMLResolver(xMLResolver);
    }

    @Override
    public XMLEventReader2 createXMLEventReader(URL uRL) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(this.createPrivateConfig(), uRL, true, true));
    }

    @Override
    public XMLEventReader2 createXMLEventReader(File file) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(file, true, true));
    }

    @Override
    public XMLStreamReader2 createXMLStreamReader(URL uRL) throws XMLStreamException {
        return this.createSR(this.createPrivateConfig(), uRL, false, true);
    }

    @Override
    public XMLStreamReader2 createXMLStreamReader(File file) throws XMLStreamException {
        return this.createSR(file, false, true);
    }

    @Override
    public void configureForXmlConformance() {
        this.mConfig.configureForXmlConformance();
    }

    @Override
    public void configureForConvenience() {
        this.mConfig.configureForConvenience();
    }

    @Override
    public void configureForSpeed() {
        this.mConfig.configureForSpeed();
    }

    @Override
    public void configureForLowMemUsage() {
        this.mConfig.configureForLowMemUsage();
    }

    @Override
    public void configureForRoundTripping() {
        this.mConfig.configureForRoundTripping();
    }

    public ReaderConfig getConfig() {
        return this.mConfig;
    }

    private XMLStreamReader2 doCreateSR(ReaderConfig readerConfig, SystemId systemId, InputBootstrapper inputBootstrapper, boolean bl2, boolean bl3) throws XMLStreamException {
        Reader reader;
        if (!bl3) {
            bl3 = readerConfig.willAutoCloseInput();
        }
        try {
            reader = inputBootstrapper.bootstrapInput(readerConfig, true, 0);
            if (inputBootstrapper.declaredXml11()) {
                readerConfig.enableXml11(true);
            }
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        BranchingReaderSource branchingReaderSource = InputSourceFactory.constructDocumentSource(readerConfig, inputBootstrapper, null, systemId, reader, bl3);
        return ValidatingStreamReader.createValidatingStreamReader(branchingReaderSource, this, readerConfig, inputBootstrapper, bl2);
    }

    public XMLStreamReader2 createSR(ReaderConfig readerConfig, String string, InputBootstrapper inputBootstrapper, boolean bl2, boolean bl3) throws XMLStreamException {
        URL uRL = readerConfig.getBaseURL();
        if (uRL == null && string != null && string.length() > 0) {
            try {
                uRL = URLUtil.urlFromSystemId(string);
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
        }
        return this.doCreateSR(readerConfig, SystemId.construct(string, uRL), inputBootstrapper, bl2, bl3);
    }

    public XMLStreamReader2 createSR(ReaderConfig readerConfig, SystemId systemId, InputBootstrapper inputBootstrapper, boolean bl2, boolean bl3) throws XMLStreamException {
        return this.doCreateSR(readerConfig, systemId, inputBootstrapper, bl2, bl3);
    }

    protected XMLStreamReader2 createSR(SystemId systemId, InputStream inputStream, String string, boolean bl2, boolean bl3) throws XMLStreamException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Null InputStream is not a valid argument");
        }
        ReaderConfig readerConfig = this.createPrivateConfig();
        if (string == null || string.length() == 0) {
            return this.createSR(readerConfig, systemId, (InputBootstrapper)StreamBootstrapper.getInstance(null, systemId, inputStream), bl2, bl3);
        }
        Reader reader = DefaultInputResolver.constructOptimizedReader(readerConfig, inputStream, false, string);
        return this.createSR(readerConfig, systemId, (InputBootstrapper)ReaderBootstrapper.getInstance(null, systemId, reader, string), bl2, bl3);
    }

    protected XMLStreamReader2 createSR(ReaderConfig readerConfig, URL uRL, boolean bl2, boolean bl3) throws XMLStreamException {
        SystemId systemId = SystemId.construct(uRL);
        try {
            return this.createSR(readerConfig, systemId, URLUtil.inputStreamFromURL(uRL), bl2, bl3);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    private XMLStreamReader2 createSR(ReaderConfig readerConfig, SystemId systemId, InputStream inputStream, boolean bl2, boolean bl3) throws XMLStreamException {
        return this.doCreateSR(readerConfig, systemId, StreamBootstrapper.getInstance(null, systemId, inputStream), bl2, bl3);
    }

    protected XMLStreamReader2 createSR(SystemId systemId, Reader reader, boolean bl2, boolean bl3) throws XMLStreamException {
        return this.createSR(this.createPrivateConfig(), systemId, (InputBootstrapper)ReaderBootstrapper.getInstance(null, systemId, reader, null), bl2, bl3);
    }

    protected XMLStreamReader2 createSR(File file, boolean bl2, boolean bl3) throws XMLStreamException {
        ReaderConfig readerConfig = this.createPrivateConfig();
        try {
            Object object;
            if (!file.isAbsolute() && (object = readerConfig.getBaseURL()) != null) {
                URL uRL = new URL((URL)object, file.getPath());
                return this.createSR(readerConfig, SystemId.construct(uRL), URLUtil.inputStreamFromURL(uRL), bl2, bl3);
            }
            object = SystemId.construct(URLUtil.toURL(file));
            return this.createSR(readerConfig, (SystemId)object, new FileInputStream(file), bl2, bl3);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    protected XMLStreamReader2 createSR(Source source, boolean bl2) throws XMLStreamException {
        boolean bl3;
        Source source2;
        ReaderConfig readerConfig = this.createPrivateConfig();
        Reader reader = null;
        InputStream inputStream = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        InputBootstrapper inputBootstrapper = null;
        if (source instanceof Stax2Source) {
            source2 = (Stax2Source)source;
            string2 = ((Stax2Source)source2).getSystemId();
            string = ((Stax2Source)source2).getPublicId();
            string3 = ((Stax2Source)source2).getEncoding();
            try {
                if (source instanceof Stax2ByteArraySource) {
                    Stax2ByteArraySource stax2ByteArraySource = (Stax2ByteArraySource)source;
                    inputBootstrapper = StreamBootstrapper.getInstance(string, SystemId.construct(string2), stax2ByteArraySource.getBuffer(), stax2ByteArraySource.getBufferStart(), stax2ByteArraySource.getBufferEnd());
                } else {
                    inputStream = ((Stax2Source)source2).constructInputStream();
                    if (inputStream == null) {
                        reader = ((Stax2Source)source2).constructReader();
                    }
                }
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
            bl3 = true;
        } else if (source instanceof StreamSource) {
            source2 = (StreamSource)source;
            string2 = ((StreamSource)source2).getSystemId();
            string = ((StreamSource)source2).getPublicId();
            inputStream = ((StreamSource)source2).getInputStream();
            if (inputStream == null) {
                reader = ((StreamSource)source2).getReader();
            }
            bl3 = readerConfig.willAutoCloseInput();
        } else if (source instanceof SAXSource) {
            source2 = (SAXSource)source;
            string2 = ((SAXSource)source2).getSystemId();
            InputSource inputSource = ((SAXSource)source2).getInputSource();
            if (inputSource != null) {
                string3 = inputSource.getEncoding();
                inputStream = inputSource.getByteStream();
                if (inputStream == null) {
                    reader = inputSource.getCharacterStream();
                }
            }
            bl3 = readerConfig.willAutoCloseInput();
        } else {
            if (source instanceof DOMSource) {
                DOMSource dOMSource = (DOMSource)source;
                return WstxDOMWrappingReader.createFrom(dOMSource, readerConfig);
            }
            throw new IllegalArgumentException("Can not instantiate Stax reader for XML source type " + source.getClass() + " (unrecognized type)");
        }
        if (inputBootstrapper == null) {
            if (reader != null) {
                inputBootstrapper = ReaderBootstrapper.getInstance(string, SystemId.construct(string2), reader, string3);
            } else if (inputStream != null) {
                inputBootstrapper = StreamBootstrapper.getInstance(string, SystemId.construct(string2), inputStream);
            } else {
                if (string2 != null && string2.length() > 0) {
                    bl3 = true;
                    try {
                        return this.createSR(readerConfig, URLUtil.urlFromSystemId(string2), bl2, bl3);
                    }
                    catch (IOException iOException) {
                        throw new WstxIOException(iOException);
                    }
                }
                throw new XMLStreamException("Can not create Stax reader for the Source passed -- neither reader, input stream nor system id was accessible; can not use other types of sources (like embedded SAX streams)");
            }
        }
        return this.createSR(readerConfig, string2, inputBootstrapper, bl2, bl3);
    }

    protected XMLEventAllocator createEventAllocator() {
        if (this.mAllocator != null) {
            return this.mAllocator.newInstance();
        }
        return this.mConfig.willPreserveLocation() ? DefaultEventAllocator.getDefaultInstance() : DefaultEventAllocator.getFastInstance();
    }

    public ReaderConfig createPrivateConfig() {
        return this.mConfig.createNonShared(this.mSymbols.makeChild());
    }

    static {
        mRootSymbols.setInternStrings(true);
    }
}

