/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.EnumResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

@JacksonStdImpl
public class StdKeyDeserializer
extends KeyDeserializer
implements Serializable {
    protected final int _kind;
    protected final Class<?> _keyClass;
    protected final FromStringDeserializer<?> _deser;

    protected StdKeyDeserializer(int n2, Class<?> clazz) {
        this(n2, clazz, null);
    }

    protected StdKeyDeserializer(int n2, Class<?> clazz, FromStringDeserializer<?> fromStringDeserializer) {
        this._kind = n2;
        this._keyClass = clazz;
        this._deser = fromStringDeserializer;
    }

    public static StdKeyDeserializer forType(Class<?> clazz) {
        int n2;
        if (clazz == String.class || clazz == Object.class || clazz == CharSequence.class || clazz == Serializable.class) {
            return StringKD.forType(clazz);
        }
        if (clazz == UUID.class) {
            n2 = 12;
        } else if (clazz == Integer.class) {
            n2 = 5;
        } else if (clazz == Long.class) {
            n2 = 6;
        } else if (clazz == Date.class) {
            n2 = 10;
        } else if (clazz == Calendar.class) {
            n2 = 11;
        } else if (clazz == Boolean.class) {
            n2 = 1;
        } else if (clazz == Byte.class) {
            n2 = 2;
        } else if (clazz == Character.class) {
            n2 = 4;
        } else if (clazz == Short.class) {
            n2 = 3;
        } else if (clazz == Float.class) {
            n2 = 7;
        } else if (clazz == Double.class) {
            n2 = 8;
        } else if (clazz == URI.class) {
            n2 = 13;
        } else if (clazz == URL.class) {
            n2 = 14;
        } else if (clazz == Class.class) {
            n2 = 15;
        } else {
            if (clazz == Locale.class) {
                FromStringDeserializer<Locale> fromStringDeserializer = FromStringDeserializer.findDeserializer(Locale.class);
                return new StdKeyDeserializer(9, clazz, fromStringDeserializer);
            }
            if (clazz == Currency.class) {
                FromStringDeserializer<Currency> fromStringDeserializer = FromStringDeserializer.findDeserializer(Currency.class);
                return new StdKeyDeserializer(16, clazz, fromStringDeserializer);
            }
            if (clazz == byte[].class) {
                n2 = 17;
            } else {
                return null;
            }
        }
        return new StdKeyDeserializer(n2, clazz);
    }

    @Override
    public Object deserializeKey(String string, DeserializationContext deserializationContext) throws IOException {
        if (string == null) {
            return null;
        }
        try {
            Object object = this._parse(string, deserializationContext);
            if (object != null) {
                return object;
            }
        }
        catch (Exception exception) {
            return deserializationContext.handleWeirdKey(this._keyClass, string, "not a valid representation, problem: (%s) %s", exception.getClass().getName(), ClassUtil.exceptionMessage(exception));
        }
        if (ClassUtil.isEnumType(this._keyClass) && deserializationContext.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return null;
        }
        return deserializationContext.handleWeirdKey(this._keyClass, string, "not a valid representation", new Object[0]);
    }

    protected Object _parse(String string, DeserializationContext deserializationContext) throws Exception {
        switch (this._kind) {
            case 1: {
                if ("true".equals(string)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(string)) {
                    return Boolean.FALSE;
                }
                return deserializationContext.handleWeirdKey(this._keyClass, string, "value not 'true' or 'false'", new Object[0]);
            }
            case 2: {
                int n2 = this._parseInt(string);
                if (n2 < -128 || n2 > 255) {
                    return deserializationContext.handleWeirdKey(this._keyClass, string, "overflow, value cannot be represented as 8-bit value", new Object[0]);
                }
                return (byte)n2;
            }
            case 3: {
                int n3 = this._parseInt(string);
                if (n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE) {
                    return deserializationContext.handleWeirdKey(this._keyClass, string, "overflow, value cannot be represented as 16-bit value", new Object[0]);
                }
                return (short)n3;
            }
            case 4: {
                if (string.length() == 1) {
                    return Character.valueOf(string.charAt(0));
                }
                return deserializationContext.handleWeirdKey(this._keyClass, string, "can only convert 1-character Strings", new Object[0]);
            }
            case 5: {
                return this._parseInt(string);
            }
            case 6: {
                return this._parseLong(string);
            }
            case 7: {
                return Float.valueOf((float)this._parseDouble(string));
            }
            case 8: {
                return this._parseDouble(string);
            }
            case 9: {
                try {
                    return this._deser._deserialize(string, deserializationContext);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return this._weirdKey(deserializationContext, string, illegalArgumentException);
                }
            }
            case 16: {
                try {
                    return this._deser._deserialize(string, deserializationContext);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return this._weirdKey(deserializationContext, string, illegalArgumentException);
                }
            }
            case 10: {
                return deserializationContext.parseDate(string);
            }
            case 11: {
                return deserializationContext.constructCalendar(deserializationContext.parseDate(string));
            }
            case 12: {
                try {
                    return UUID.fromString(string);
                }
                catch (Exception exception) {
                    return this._weirdKey(deserializationContext, string, exception);
                }
            }
            case 13: {
                try {
                    return URI.create(string);
                }
                catch (Exception exception) {
                    return this._weirdKey(deserializationContext, string, exception);
                }
            }
            case 14: {
                try {
                    return new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    return this._weirdKey(deserializationContext, string, malformedURLException);
                }
            }
            case 15: {
                try {
                    return deserializationContext.findClass(string);
                }
                catch (Exception exception) {
                    return deserializationContext.handleWeirdKey(this._keyClass, string, "unable to parse key as Class", new Object[0]);
                }
            }
            case 17: {
                try {
                    return deserializationContext.getConfig().getBase64Variant().decode(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return this._weirdKey(deserializationContext, string, illegalArgumentException);
                }
            }
        }
        throw new IllegalStateException("Internal error: unknown key type " + this._keyClass);
    }

    protected int _parseInt(String string) throws IllegalArgumentException {
        return NumberInput.parseInt(string);
    }

    protected long _parseLong(String string) throws IllegalArgumentException {
        return NumberInput.parseLong(string);
    }

    protected double _parseDouble(String string) throws IllegalArgumentException {
        return NumberInput.parseDouble(string);
    }

    protected Object _weirdKey(DeserializationContext deserializationContext, String string, Exception exception) throws IOException {
        return deserializationContext.handleWeirdKey(this._keyClass, string, "problem: %s", ClassUtil.exceptionMessage(exception));
    }

    static final class StringFactoryKeyDeserializer
    extends StdKeyDeserializer {
        final Method _factoryMethod;

        public StringFactoryKeyDeserializer(Method method) {
            super(-1, method.getDeclaringClass());
            this._factoryMethod = method;
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws Exception {
            return this._factoryMethod.invoke(null, string);
        }
    }

    static final class StringCtorKeyDeserializer
    extends StdKeyDeserializer {
        protected final Constructor<?> _ctor;

        public StringCtorKeyDeserializer(Constructor<?> constructor) {
            super(-1, constructor.getDeclaringClass());
            this._ctor = constructor;
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws Exception {
            return this._ctor.newInstance(string);
        }
    }

    @JacksonStdImpl
    static final class EnumKD
    extends StdKeyDeserializer {
        protected final EnumResolver _byNameResolver;
        protected final AnnotatedMethod _factory;
        protected volatile EnumResolver _byToStringResolver;
        protected volatile EnumResolver _byIndexResolver;
        protected final EnumResolver _byEnumNamingResolver;
        protected final Enum<?> _enumDefaultValue;

        protected EnumKD(EnumResolver enumResolver, AnnotatedMethod annotatedMethod, EnumResolver enumResolver2, EnumResolver enumResolver3, EnumResolver enumResolver4) {
            super(-1, enumResolver.getEnumClass());
            this._byNameResolver = enumResolver;
            this._factory = annotatedMethod;
            this._enumDefaultValue = enumResolver.getDefaultValue();
            this._byEnumNamingResolver = enumResolver2;
            this._byToStringResolver = enumResolver3;
            this._byIndexResolver = enumResolver4;
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws IOException {
            EnumResolver enumResolver;
            Enum<?> enum_;
            if (this._factory != null) {
                try {
                    return this._factory.call1(string);
                }
                catch (Exception exception) {
                    ClassUtil.unwrapAndThrowAsIAE(exception);
                }
            }
            if ((enum_ = (enumResolver = this._resolveCurrentResolver(deserializationContext)).findEnum(string)) == null && deserializationContext.isEnabled(EnumFeature.READ_ENUM_KEYS_USING_INDEX)) {
                enumResolver = this._getIndexResolver(deserializationContext);
                enum_ = enumResolver.findEnum(string);
            }
            if (enum_ == null) {
                if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
                    enum_ = this._enumDefaultValue;
                } else if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    return deserializationContext.handleWeirdKey(this._keyClass, string, "not one of the values accepted for Enum class: %s", enumResolver.getEnumIds());
                }
            }
            return enum_;
        }

        protected EnumResolver _resolveCurrentResolver(DeserializationContext deserializationContext) {
            if (this._byEnumNamingResolver != null) {
                return this._byEnumNamingResolver;
            }
            return deserializationContext.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING) ? this._getToStringResolver(deserializationContext) : this._byNameResolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        private EnumResolver _getToStringResolver(DeserializationContext deserializationContext) {
            EnumResolver enumResolver = this._byToStringResolver;
            if (enumResolver == null) {
                EnumKD enumKD = this;
                synchronized (enumKD) {
                    enumResolver = this._byToStringResolver;
                    if (enumResolver == null) {
                        this._byToStringResolver = enumResolver = EnumResolver.constructUsingToString(deserializationContext.getConfig(), this._byNameResolver.getEnumClass());
                    }
                }
            }
            return enumResolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        private EnumResolver _getIndexResolver(DeserializationContext deserializationContext) {
            EnumResolver enumResolver = this._byIndexResolver;
            if (enumResolver == null) {
                EnumKD enumKD = this;
                synchronized (enumKD) {
                    enumResolver = this._byIndexResolver;
                    if (enumResolver == null) {
                        this._byIndexResolver = enumResolver = EnumResolver.constructUsingIndex(deserializationContext.getConfig(), this._byNameResolver.getEnumClass());
                    }
                }
            }
            return enumResolver;
        }
    }

    static final class DelegatingKD
    extends KeyDeserializer
    implements Serializable {
        protected final Class<?> _keyClass;
        protected final JsonDeserializer<?> _delegate;

        protected DelegatingKD(Class<?> clazz, JsonDeserializer<?> jsonDeserializer) {
            this._keyClass = clazz;
            this._delegate = jsonDeserializer;
        }

        @Override
        public final Object deserializeKey(String string, DeserializationContext deserializationContext) throws IOException {
            if (string == null) {
                return null;
            }
            TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering();
            tokenBuffer.writeString(string);
            try {
                JsonParser jsonParser = tokenBuffer.asParser();
                jsonParser.nextToken();
                Object obj = this._delegate.deserialize(jsonParser, deserializationContext);
                if (obj != null) {
                    return obj;
                }
                return deserializationContext.handleWeirdKey(this._keyClass, string, "not a valid representation", new Object[0]);
            }
            catch (Exception exception) {
                return deserializationContext.handleWeirdKey(this._keyClass, string, "not a valid representation: %s", exception.getMessage());
            }
        }
    }

    @JacksonStdImpl
    static final class StringKD
    extends StdKeyDeserializer {
        private static final StringKD sString = new StringKD(String.class);
        private static final StringKD sObject = new StringKD(Object.class);

        private StringKD(Class<?> clazz) {
            super(-1, clazz);
        }

        public static StringKD forType(Class<?> clazz) {
            if (clazz == String.class) {
                return sString;
            }
            if (clazz == Object.class) {
                return sObject;
            }
            return new StringKD(clazz);
        }

        @Override
        public Object deserializeKey(String string, DeserializationContext deserializationContext) throws IOException {
            return string;
        }
    }
}

