/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.AbstractHasher;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.HashCode;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.Hasher;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.Java8Compatibility;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class AbstractStreamingHasher
extends AbstractHasher {
    private final ByteBuffer buffer;
    private final int bufferSize;
    private final int chunkSize;

    protected AbstractStreamingHasher(int n2) {
        this(n2, n2);
    }

    protected AbstractStreamingHasher(int n2, int n3) {
        Preconditions.checkArgument(n3 % n2 == 0);
        this.buffer = ByteBuffer.allocate(n3 + 7).order(ByteOrder.LITTLE_ENDIAN);
        this.bufferSize = n3;
        this.chunkSize = n2;
    }

    protected abstract void process(ByteBuffer var1);

    protected void processRemaining(ByteBuffer byteBuffer) {
        Java8Compatibility.position(byteBuffer, byteBuffer.limit());
        Java8Compatibility.limit(byteBuffer, this.chunkSize + 7);
        while (byteBuffer.position() < this.chunkSize) {
            byteBuffer.putLong(0L);
        }
        Java8Compatibility.limit(byteBuffer, this.chunkSize);
        Java8Compatibility.flip(byteBuffer);
        this.process(byteBuffer);
    }

    @Override
    public final Hasher putBytes(byte[] byArray, int n2, int n3) {
        return this.putBytesInternal(ByteBuffer.wrap(byArray, n2, n3).order(ByteOrder.LITTLE_ENDIAN));
    }

    private Hasher putBytesInternal(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() <= this.buffer.remaining()) {
            this.buffer.put(byteBuffer);
            this.munchIfFull();
            return this;
        }
        int n2 = this.bufferSize - this.buffer.position();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer.put(byteBuffer.get());
        }
        this.munch();
        while (byteBuffer.remaining() >= this.chunkSize) {
            this.process(byteBuffer);
        }
        this.buffer.put(byteBuffer);
        return this;
    }

    @Override
    public final Hasher putByte(byte by2) {
        this.buffer.put(by2);
        this.munchIfFull();
        return this;
    }

    @Override
    public final Hasher putInt(int n2) {
        this.buffer.putInt(n2);
        this.munchIfFull();
        return this;
    }

    @Override
    public final HashCode hash() {
        this.munch();
        Java8Compatibility.flip(this.buffer);
        if (this.buffer.remaining() > 0) {
            this.processRemaining(this.buffer);
            Java8Compatibility.position(this.buffer, this.buffer.limit());
        }
        return this.makeHash();
    }

    protected abstract HashCode makeHash();

    private void munchIfFull() {
        if (this.buffer.remaining() < 8) {
            this.munch();
        }
    }

    private void munch() {
        Java8Compatibility.flip(this.buffer);
        while (this.buffer.remaining() >= this.chunkSize) {
            this.process(this.buffer);
        }
        this.buffer.compact();
    }
}

