/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import java.nio.ByteBuffer;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final ObjectPool<PooledDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledDirectByteBuf>(){

        @Override
        public PooledDirectByteBuf newObject(ObjectPool.Handle<PooledDirectByteBuf> handle) {
            return new PooledDirectByteBuf(handle, 0);
        }
    });

    static PooledDirectByteBuf newInstance(int n2) {
        PooledDirectByteBuf pooledDirectByteBuf = RECYCLER.get();
        pooledDirectByteBuf.reuse(n2);
        return pooledDirectByteBuf;
    }

    private PooledDirectByteBuf(ObjectPool.Handle<PooledDirectByteBuf> handle, int n2) {
        super(handle, n2);
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int n2) {
        return ((ByteBuffer)this.memory).get(this.idx(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return ((ByteBuffer)this.memory).getShort(this.idx(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return ByteBufUtil.swapShort(this._getShort(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        n2 = this.idx(n2);
        return (((ByteBuffer)this.memory).get(n2) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(n2 + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get(n2 + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        n2 = this.idx(n2);
        return ((ByteBuffer)this.memory).get(n2) & 0xFF | (((ByteBuffer)this.memory).get(n2 + 1) & 0xFF) << 8 | (((ByteBuffer)this.memory).get(n2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getInt(int n2) {
        return ((ByteBuffer)this.memory).getInt(this.idx(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return ByteBufUtil.swapInt(this._getInt(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return ((ByteBuffer)this.memory).getLong(this.idx(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return ByteBufUtil.swapLong(this._getLong(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.getBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBuf.setBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        this._internalNioBuffer(n2, n4, true).get(byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkDstIndex(n3, n2, byArray.length);
        this._internalNioBuffer(this.readerIndex, n3, false).get(byArray, n2, n3);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        byteBuffer.put(this.duplicateInternalNioBuffer(n2, byteBuffer.remaining()));
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        byteBuffer.put(this._internalNioBuffer(this.readerIndex, n2, false));
        this.readerIndex += n2;
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        ((ByteBuffer)this.memory).put(this.idx(n2), (byte)n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        ((ByteBuffer)this.memory).putShort(this.idx(n2), (short)n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        n2 = this.idx(n2);
        ((ByteBuffer)this.memory).put(n2, (byte)(n3 >>> 16));
        ((ByteBuffer)this.memory).put(n2 + 1, (byte)(n3 >>> 8));
        ((ByteBuffer)this.memory).put(n2 + 2, (byte)n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        ((ByteBuffer)this.memory).putInt(this.idx(n2), n3);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        ((ByteBuffer)this.memory).putLong(this.idx(n2), l2);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.setBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.setBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBuf.getBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        this._internalNioBuffer(n2, n4, false).put(byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.remaining();
        this.checkIndex(n2, n3);
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        if (byteBuffer == byteBuffer2) {
            byteBuffer = byteBuffer.duplicate();
        }
        n2 = this.idx(n2);
        byteBuffer2.limit(n2 + n3).position(n2);
        byteBuffer2.put(byteBuffer);
        return this;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

