/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.CharSequenceValueConverter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DateFormatter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DefaultHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DefaultHeadersImpl;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.HeadersUtils;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.ValueConverter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.util.AsciiString;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultHttpHeaders
extends HttpHeaders {
    private final DefaultHeaders<CharSequence, CharSequence, ?> headers;

    public DefaultHttpHeaders() {
        this(DefaultHttpHeaders.nameValidator(true), DefaultHttpHeaders.valueValidator(true));
    }

    protected DefaultHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        this(nameValidator, valueValidator, 16);
    }

    protected DefaultHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int n2) {
        this(new DefaultHeadersImpl<CharSequence, CharSequence>(AsciiString.CASE_INSENSITIVE_HASHER, HeaderValueConverter.INSTANCE, nameValidator, n2, valueValidator));
    }

    protected DefaultHttpHeaders(DefaultHeaders<CharSequence, CharSequence, ?> defaultHeaders) {
        this.headers = defaultHeaders;
    }

    @Override
    public HttpHeaders add(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.add(httpHeaders);
    }

    @Override
    public HttpHeaders set(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.set(httpHeaders);
    }

    @Override
    public HttpHeaders add(String string, Object object) {
        this.headers.addObject(string, object);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Object object) {
        this.headers.addObject(charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders remove(String string) {
        this.headers.remove(string);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence charSequence) {
        this.headers.remove(charSequence);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Object object) {
        this.headers.setObject((CharSequence)string, object);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Object object) {
        this.headers.setObject(charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Iterable<?> iterable) {
        this.headers.setObject((CharSequence)string, iterable);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Iterable<?> iterable) {
        this.headers.setObject(charSequence, iterable);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String string) {
        return this.get((CharSequence)string);
    }

    @Override
    public String get(CharSequence charSequence) {
        return HeadersUtils.getAsString(this.headers, charSequence);
    }

    @Override
    public List<String> getAll(String string) {
        return this.getAll((CharSequence)string);
    }

    @Override
    public List<String> getAll(CharSequence charSequence) {
        return HeadersUtils.getAllAsString(this.headers, charSequence);
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, String>> iterator() {
        return HeadersUtils.iteratorAsString(this.headers);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.headers.iterator();
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence charSequence) {
        final Iterator<CharSequence> iterator = this.valueCharSequenceIterator(charSequence);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return ((CharSequence)iterator.next()).toString();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return this.headers.valueIterator(charSequence);
    }

    @Override
    public boolean contains(String string) {
        return this.contains((CharSequence)string);
    }

    @Override
    public boolean contains(CharSequence charSequence) {
        return this.headers.contains(charSequence);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean contains(String string, String string2, boolean bl2) {
        return this.contains((CharSequence)string, (CharSequence)string2, bl2);
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        return this.headers.contains(charSequence, charSequence2, bl2 ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultHttpHeaders && this.headers.equals(((DefaultHttpHeaders)object).headers, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.headers.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public HttpHeaders copy() {
        return new DefaultHttpHeaders(this.headers.copy());
    }

    static ValueConverter<CharSequence> valueConverter() {
        return HeaderValueConverter.INSTANCE;
    }

    static DefaultHeaders.ValueValidator<CharSequence> valueValidator(boolean bl2) {
        return bl2 ? DefaultHttpHeadersFactory.headersFactory().getValueValidator() : DefaultHttpHeadersFactory.headersFactory().withValidation(false).getValueValidator();
    }

    static DefaultHeaders.NameValidator<CharSequence> nameValidator(boolean bl2) {
        return bl2 ? DefaultHttpHeadersFactory.headersFactory().getNameValidator() : DefaultHttpHeadersFactory.headersFactory().withNameValidation(false).getNameValidator();
    }

    private static class HeaderValueConverter
    extends CharSequenceValueConverter {
        static final HeaderValueConverter INSTANCE = new HeaderValueConverter();

        private HeaderValueConverter() {
        }

        @Override
        public CharSequence convertObject(Object object) {
            if (object instanceof CharSequence) {
                return (CharSequence)object;
            }
            if (object instanceof Date) {
                return DateFormatter.format((Date)object);
            }
            if (object instanceof Calendar) {
                return DateFormatter.format(((Calendar)object).getTime());
            }
            return object.toString();
        }
    }
}

