/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar;

import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils.ArchiveUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils.ParsingUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils.TimeUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TarArchiveEntry {
    private static final TarArchiveEntry[] EMPTY_TAR_ARCHIVE_ENTRY_ARRAY = new TarArchiveEntry[0];
    private static final Pattern PAX_EXTENDED_HEADER_FILE_TIMES_PATTERN = Pattern.compile("-?\\d{1,19}(?:\\.\\d{1,19})?");
    private String name = "";
    private final boolean preserveAbsolutePath;
    private int mode;
    private long userId;
    private long groupId;
    private long size;
    private FileTime mTime;
    private FileTime cTime;
    private FileTime aTime;
    private FileTime birthTime;
    private boolean checkSumOK;
    private byte linkFlag;
    private String linkName = "";
    private String magic = "ustar\u0000";
    private String version = "00";
    private String userName;
    private String groupName = "";
    private int devMajor;
    private int devMinor;
    private List<TarArchiveStructSparse> sparseHeaders;
    private boolean isExtended;
    private long realSize;
    private boolean paxGNUSparse;
    private boolean paxGNU1XSparse;
    private boolean starSparse;
    private final Path file;
    private final LinkOption[] linkOptions;
    private final Map<String, String> extraPaxHeaders = new HashMap<String, String>();
    private long dataOffset = -1L;

    private static FileTime fileTimeFromOptionalSeconds(long l2) {
        if (l2 <= 0L) {
            return null;
        }
        return TimeUtils.unixTimeToFileTime(l2);
    }

    private static String normalizeFileName(String string, boolean bl2) {
        String string2;
        if (!bl2 && (string2 = System.getProperty("os.name")) != null) {
            int n2;
            String string3 = string2.toLowerCase(Locale.ROOT);
            if (string3.startsWith("windows")) {
                if (string.length() > 2) {
                    n2 = string.charAt(0);
                    char c2 = string.charAt(1);
                    if (c2 == ':' && (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90)) {
                        string = string.substring(2);
                    }
                }
            } else if (string3.contains("netware") && (n2 = string.indexOf(58)) != -1) {
                string = string.substring(n2 + 1);
            }
        }
        string = string.replace(File.separatorChar, '/');
        while (!bl2 && string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private static Instant parseInstantFromDecimalSeconds(String string) throws IOException {
        if (!PAX_EXTENDED_HEADER_FILE_TIMES_PATTERN.matcher(string).matches()) {
            throw new IOException("Corrupted PAX header. Time field value is invalid '" + string + "'");
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        long l2 = bigDecimal.longValue();
        long l3 = bigDecimal.remainder(BigDecimal.ONE).movePointRight(9).longValue();
        try {
            return Instant.ofEpochSecond(l2, l3);
        }
        catch (ArithmeticException | DateTimeException runtimeException) {
            throw new IOException("Corrupted PAX header. Time field value is invalid '" + string + "'", runtimeException);
        }
    }

    private TarArchiveEntry(boolean bl2) {
        String string = System.getProperty("user.name", "");
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.userName = string;
        this.file = null;
        this.linkOptions = IOUtils.EMPTY_LINK_OPTIONS;
        this.preserveAbsolutePath = bl2;
    }

    public TarArchiveEntry(Map<String, String> map, byte[] byArray, ZipEncoding zipEncoding, boolean bl2) throws IOException {
        this(false);
        this.parseTarHeader(map, byArray, zipEncoding, false, bl2);
    }

    public TarArchiveEntry(String string) {
        this(string, false);
    }

    public TarArchiveEntry(String string, boolean bl2) {
        this(bl2);
        string = TarArchiveEntry.normalizeFileName(string, bl2);
        boolean bl3 = string.endsWith("/");
        this.name = string;
        this.mode = bl3 ? 16877 : 33188;
        this.linkFlag = (byte)(bl3 ? 53 : 48);
        this.mTime = FileTime.from(Instant.now());
        this.userName = "";
    }

    public TarArchiveEntry(String string, byte by2) {
        this(string, by2, false);
    }

    public TarArchiveEntry(String string, byte by2, boolean bl2) {
        this(string, bl2);
        this.linkFlag = by2;
        if (by2 == 76) {
            this.magic = "ustar ";
            this.version = " \u0000";
        }
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.equals((TarArchiveEntry)object);
    }

    public boolean equals(TarArchiveEntry tarArchiveEntry) {
        return tarArchiveEntry != null && this.getName().equals(tarArchiveEntry.getName());
    }

    private int evaluateType(Map<String, String> map, byte[] byArray) {
        if (ArchiveUtils.matchAsciiBuffer("ustar ", byArray, 257, 6)) {
            return 2;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", byArray, 257, 6)) {
            if (this.isXstar(map, byArray)) {
                return 4;
            }
            return 3;
        }
        return 0;
    }

    private int fill(byte by2, int n2, byte[] byArray, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2 + i2] = by2;
        }
        return n2 + n3;
    }

    private int fill(int n2, int n3, byte[] byArray, int n4) {
        return this.fill((byte)n2, n3, byArray, n4);
    }

    void fillGNUSparse0xData(Map<String, String> map) throws IOException {
        this.paxGNUSparse = true;
        this.realSize = ParsingUtils.parseIntValue(map.get("GNU.sparse.size"));
        if (map.containsKey("GNU.sparse.name")) {
            this.name = map.get("GNU.sparse.name");
        }
    }

    void fillGNUSparse1xData(Map<String, String> map) throws IOException {
        this.paxGNUSparse = true;
        this.paxGNU1XSparse = true;
        if (map.containsKey("GNU.sparse.name")) {
            this.name = map.get("GNU.sparse.name");
        }
        if (map.containsKey("GNU.sparse.realsize")) {
            this.realSize = ParsingUtils.parseIntValue(map.get("GNU.sparse.realsize"));
        }
    }

    void fillStarSparseData(Map<String, String> map) throws IOException {
        this.starSparse = true;
        if (map.containsKey("SCHILY.realsize")) {
            this.realSize = ParsingUtils.parseLongValue(map.get("SCHILY.realsize"));
        }
    }

    public FileTime getCreationTime() {
        return this.birthTime;
    }

    public int getDevMajor() {
        return this.devMajor;
    }

    public int getDevMinor() {
        return this.devMinor;
    }

    public Map<String, String> getExtraPaxHeaders() {
        return Collections.unmodifiableMap(this.extraPaxHeaders);
    }

    public FileTime getLastAccessTime() {
        return this.aTime;
    }

    public FileTime getLastModifiedTime() {
        return this.mTime;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public long getLongGroupId() {
        return this.groupId;
    }

    public long getLongUserId() {
        return this.userId;
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public List<TarArchiveStructSparse> getOrderedSparseHeaders() throws IOException {
        TarArchiveStructSparse tarArchiveStructSparse2;
        if (this.sparseHeaders == null || this.sparseHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        List<TarArchiveStructSparse> list = this.sparseHeaders.stream().filter(tarArchiveStructSparse -> tarArchiveStructSparse.getOffset() > 0L || tarArchiveStructSparse.getNumbytes() > 0L).sorted(Comparator.comparingLong(TarArchiveStructSparse::getOffset)).collect(Collectors.toList());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TarArchiveStructSparse tarArchiveStructSparse3 = (TarArchiveStructSparse)list.get(i2);
            if (i2 + 1 < n2 && tarArchiveStructSparse3.getOffset() + tarArchiveStructSparse3.getNumbytes() > list.get(i2 + 1).getOffset()) {
                throw new IOException("Corrupted TAR archive. Sparse blocks for " + this.getName() + " overlap each other.");
            }
            if (tarArchiveStructSparse3.getOffset() + tarArchiveStructSparse3.getNumbytes() >= 0L) continue;
            throw new IOException("Unreadable TAR archive. Offset and numbytes for sparse block in " + this.getName() + " too large.");
        }
        if (!list.isEmpty() && (tarArchiveStructSparse2 = list.get(n2 - 1)).getOffset() + tarArchiveStructSparse2.getNumbytes() > this.getRealSize()) {
            throw new IOException("Corrupted TAR archive. Sparse block extends beyond real size of the entry");
        }
        return list;
    }

    public long getRealSize() {
        if (!this.isSparse()) {
            return this.getSize();
        }
        return this.realSize;
    }

    public long getSize() {
        return this.size;
    }

    public List<TarArchiveStructSparse> getSparseHeaders() {
        return this.sparseHeaders;
    }

    public FileTime getStatusChangeTime() {
        return this.cTime;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isBlockDevice() {
        return this.linkFlag == 52;
    }

    public boolean isCharacterDevice() {
        return this.linkFlag == 51;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return Files.isDirectory(this.file, this.linkOptions);
        }
        if (this.linkFlag == 53) {
            return true;
        }
        return !this.isPaxHeader() && !this.isGlobalPaxHeader() && this.getName().endsWith("/");
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public boolean isFIFO() {
        return this.linkFlag == 54;
    }

    public boolean isFile() {
        if (this.file != null) {
            return Files.isRegularFile(this.file, this.linkOptions);
        }
        if (this.linkFlag == 0 || this.linkFlag == 48) {
            return true;
        }
        return this.linkFlag != 53 && !this.getName().endsWith("/");
    }

    public boolean isGlobalPaxHeader() {
        return this.linkFlag == 103;
    }

    public boolean isGNULongLinkEntry() {
        return this.linkFlag == 75;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76;
    }

    public boolean isGNUSparse() {
        return this.isOldGNUSparse() || this.isPaxGNUSparse();
    }

    private boolean isInvalidPrefix(byte[] byArray) {
        if (byArray[475] != 0) {
            if (byArray[156] != 77) {
                return true;
            }
            if ((byArray[464] & 0x80) == 0 && byArray[475] != 32) {
                return true;
            }
        }
        return false;
    }

    private boolean isInvalidXtarTime(byte[] byArray, int n2, int n3) {
        if ((byArray[n2] & 0x80) == 0) {
            int n4;
            int n5 = n3 - 1;
            for (n4 = 0; n4 < n5; ++n4) {
                byte by2 = byArray[n2 + n4];
                if (by2 >= 48 && by2 <= 55) continue;
                return true;
            }
            n4 = byArray[n2 + n5];
            if (n4 != 32 && n4 != 0) {
                return true;
            }
        }
        return false;
    }

    public boolean isLink() {
        return this.linkFlag == 49;
    }

    public boolean isOldGNUSparse() {
        return this.linkFlag == 83;
    }

    public boolean isPaxGNU1XSparse() {
        return this.paxGNU1XSparse;
    }

    public boolean isPaxGNUSparse() {
        return this.paxGNUSparse;
    }

    public boolean isPaxHeader() {
        return this.linkFlag == 120 || this.linkFlag == 88;
    }

    public boolean isSparse() {
        return this.isGNUSparse() || this.isStarSparse();
    }

    public boolean isStarSparse() {
        return this.starSparse;
    }

    public boolean isSymbolicLink() {
        return this.linkFlag == 50;
    }

    private boolean isXstar(Map<String, String> map, byte[] byArray) {
        if (ArchiveUtils.matchAsciiBuffer("tar\u0000", byArray, 508, 4)) {
            return true;
        }
        String string = map.get("SCHILY.archtype");
        if (string != null) {
            return "xustar".equals(string) || "exustar".equals(string);
        }
        if (this.isInvalidPrefix(byArray)) {
            return false;
        }
        if (this.isInvalidXtarTime(byArray, 476, 12)) {
            return false;
        }
        return !this.isInvalidXtarTime(byArray, 488, 12);
    }

    private long parseOctalOrBinary(byte[] byArray, int n2, int n3, boolean bl2) {
        if (bl2) {
            try {
                return TarUtils.parseOctalOrBinary(byArray, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1L;
            }
        }
        return TarUtils.parseOctalOrBinary(byArray, n2, n3);
    }

    private void parseTarHeader(Map<String, String> map, byte[] byArray, ZipEncoding zipEncoding, boolean bl2, boolean bl3) throws IOException {
        try {
            this.parseTarHeaderUnwrapped(map, byArray, zipEncoding, bl2, bl3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Corrupted TAR archive.", illegalArgumentException);
        }
    }

    private void parseTarHeaderUnwrapped(Map<String, String> map, byte[] byArray, ZipEncoding zipEncoding, boolean bl2, boolean bl3) throws IOException {
        int n2 = 0;
        this.name = bl2 ? TarUtils.parseName(byArray, n2, 100) : TarUtils.parseName(byArray, n2, 100, zipEncoding);
        this.mode = (int)this.parseOctalOrBinary(byArray, n2 += 100, 8, bl3);
        this.userId = (int)this.parseOctalOrBinary(byArray, n2 += 8, 8, bl3);
        this.groupId = (int)this.parseOctalOrBinary(byArray, n2 += 8, 8, bl3);
        this.size = TarUtils.parseOctalOrBinary(byArray, n2 += 8, 12);
        if (this.size < 0L) {
            throw new IOException("broken archive, entry with negative size");
        }
        this.mTime = TimeUtils.unixTimeToFileTime(this.parseOctalOrBinary(byArray, n2 += 12, 12, bl3));
        n2 += 12;
        this.checkSumOK = TarUtils.verifyCheckSum(byArray);
        n2 += 8;
        this.linkFlag = byArray[n2++];
        this.linkName = bl2 ? TarUtils.parseName(byArray, n2, 100) : TarUtils.parseName(byArray, n2, 100, zipEncoding);
        this.magic = TarUtils.parseName(byArray, n2 += 100, 6);
        this.version = TarUtils.parseName(byArray, n2 += 6, 2);
        this.userName = bl2 ? TarUtils.parseName(byArray, n2, 32) : TarUtils.parseName(byArray, n2 += 2, 32, zipEncoding);
        this.groupName = bl2 ? TarUtils.parseName(byArray, n2, 32) : TarUtils.parseName(byArray, n2 += 32, 32, zipEncoding);
        n2 += 32;
        if (this.linkFlag == 51 || this.linkFlag == 52) {
            this.devMajor = (int)this.parseOctalOrBinary(byArray, n2, 8, bl3);
            this.devMinor = (int)this.parseOctalOrBinary(byArray, n2 += 8, 8, bl3);
            n2 += 8;
        } else {
            n2 += 16;
        }
        int n3 = this.evaluateType(map, byArray);
        switch (n3) {
            case 2: {
                this.aTime = TarArchiveEntry.fileTimeFromOptionalSeconds(this.parseOctalOrBinary(byArray, n2, 12, bl3));
                this.cTime = TarArchiveEntry.fileTimeFromOptionalSeconds(this.parseOctalOrBinary(byArray, n2 += 12, 12, bl3));
                n2 += 12;
                n2 += 12;
                n2 += 4;
                this.sparseHeaders = new ArrayList<TarArchiveStructSparse>(TarUtils.readSparseStructs(byArray, ++n2, 4));
                this.isExtended = TarUtils.parseBoolean(byArray, n2 += 96);
                this.realSize = TarUtils.parseOctal(byArray, ++n2, 12);
                n2 += 12;
                break;
            }
            case 4: {
                String string = bl2 ? TarUtils.parseName(byArray, n2, 131) : TarUtils.parseName(byArray, n2, 131, zipEncoding);
                n2 += 131;
                if (!string.isEmpty()) {
                    this.name = string + "/" + this.name;
                }
                this.aTime = TarArchiveEntry.fileTimeFromOptionalSeconds(this.parseOctalOrBinary(byArray, n2, 12, bl3));
                this.cTime = TarArchiveEntry.fileTimeFromOptionalSeconds(this.parseOctalOrBinary(byArray, n2 += 12, 12, bl3));
                n2 += 12;
                break;
            }
            default: {
                String string = bl2 ? TarUtils.parseName(byArray, n2, 155) : TarUtils.parseName(byArray, n2, 155, zipEncoding);
                n2 += 155;
                if (this.isDirectory() && !this.name.endsWith("/")) {
                    this.name = this.name + "/";
                }
                if (string.isEmpty()) break;
                this.name = string + "/" + this.name;
            }
        }
    }

    private void processPaxHeader(String string, String string2, Map<String, String> map) throws IOException {
        switch (string) {
            case "path": {
                this.setName(string2);
                break;
            }
            case "linkpath": {
                this.setLinkName(string2);
                break;
            }
            case "gid": {
                this.setGroupId(ParsingUtils.parseLongValue(string2));
                break;
            }
            case "gname": {
                this.setGroupName(string2);
                break;
            }
            case "uid": {
                this.setUserId(ParsingUtils.parseLongValue(string2));
                break;
            }
            case "uname": {
                this.setUserName(string2);
                break;
            }
            case "size": {
                long l2 = ParsingUtils.parseLongValue(string2);
                if (l2 < 0L) {
                    throw new IOException("Corrupted TAR archive. Entry size is negative");
                }
                this.setSize(l2);
                break;
            }
            case "mtime": {
                this.setLastModifiedTime(FileTime.from(TarArchiveEntry.parseInstantFromDecimalSeconds(string2)));
                break;
            }
            case "atime": {
                this.setLastAccessTime(FileTime.from(TarArchiveEntry.parseInstantFromDecimalSeconds(string2)));
                break;
            }
            case "ctime": {
                this.setStatusChangeTime(FileTime.from(TarArchiveEntry.parseInstantFromDecimalSeconds(string2)));
                break;
            }
            case "LIBARCHIVE.creationtime": {
                this.setCreationTime(FileTime.from(TarArchiveEntry.parseInstantFromDecimalSeconds(string2)));
                break;
            }
            case "SCHILY.devminor": {
                int n2 = ParsingUtils.parseIntValue(string2);
                if (n2 < 0) {
                    throw new IOException("Corrupted TAR archive. Dev-Minor is negative");
                }
                this.setDevMinor(n2);
                break;
            }
            case "SCHILY.devmajor": {
                int n3 = ParsingUtils.parseIntValue(string2);
                if (n3 < 0) {
                    throw new IOException("Corrupted TAR archive. Dev-Major is negative");
                }
                this.setDevMajor(n3);
                break;
            }
            case "GNU.sparse.size": {
                this.fillGNUSparse0xData(map);
                break;
            }
            case "GNU.sparse.realsize": {
                this.fillGNUSparse1xData(map);
                break;
            }
            case "SCHILY.filetype": {
                if (!"sparse".equals(string2)) break;
                this.fillStarSparseData(map);
                break;
            }
            default: {
                this.extraPaxHeaders.put(string, string2);
            }
        }
    }

    public void setCreationTime(FileTime fileTime) {
        this.birthTime = fileTime;
    }

    public void setDevMajor(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Major device number is out of range: " + n2);
        }
        this.devMajor = n2;
    }

    public void setDevMinor(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Minor device number is out of range: " + n2);
        }
        this.devMinor = n2;
    }

    public void setGroupId(long l2) {
        this.groupId = l2;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setLastAccessTime(FileTime fileTime) {
        this.aTime = fileTime;
    }

    public void setLastModifiedTime(FileTime fileTime) {
        this.mTime = Objects.requireNonNull(fileTime, "Time must not be null");
    }

    public void setLinkName(String string) {
        this.linkName = string;
    }

    public void setMode(int n2) {
        this.mode = n2;
    }

    public void setModTime(long l2) {
        this.setLastModifiedTime(FileTime.fromMillis(l2));
    }

    public void setName(String string) {
        this.name = TarArchiveEntry.normalizeFileName(string, this.preserveAbsolutePath);
    }

    public void setSize(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Size is out of range: " + l2);
        }
        this.size = l2;
    }

    public void setSparseHeaders(List<TarArchiveStructSparse> list) {
        this.sparseHeaders = list;
    }

    public void setStatusChangeTime(FileTime fileTime) {
        this.cTime = fileTime;
    }

    public void setUserId(long l2) {
        this.userId = l2;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    void updateEntryFromPaxHeaders(Map<String, String> map) throws IOException {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.processPaxHeader(entry.getKey(), entry.getValue(), map);
        }
    }

    public void writeEntryHeader(byte[] byArray, ZipEncoding zipEncoding, boolean bl2) throws IOException {
        int n2 = 0;
        n2 = TarUtils.formatNameBytes(this.name, byArray, n2, 100, zipEncoding);
        n2 = this.writeEntryHeaderField(this.mode, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.userId, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.groupId, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.size, byArray, n2, 12, bl2);
        int n3 = n2 = this.writeEntryHeaderField(TimeUtils.toUnixTime(this.mTime), byArray, n2, 12, bl2);
        n2 = this.fill((byte)32, n2, byArray, 8);
        byArray[n2++] = this.linkFlag;
        n2 = TarUtils.formatNameBytes(this.linkName, byArray, n2, 100, zipEncoding);
        n2 = TarUtils.formatNameBytes(this.magic, byArray, n2, 6);
        n2 = TarUtils.formatNameBytes(this.version, byArray, n2, 2);
        n2 = TarUtils.formatNameBytes(this.userName, byArray, n2, 32, zipEncoding);
        n2 = TarUtils.formatNameBytes(this.groupName, byArray, n2, 32, zipEncoding);
        n2 = this.writeEntryHeaderField(this.devMajor, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.devMinor, byArray, n2, 8, bl2);
        if (bl2) {
            n2 = this.fill(0, n2, byArray, 131);
            n2 = this.writeEntryHeaderOptionalTimeField(this.aTime, n2, byArray, 12);
            n2 = this.writeEntryHeaderOptionalTimeField(this.cTime, n2, byArray, 12);
            n2 = this.fill(0, n2, byArray, 8);
            n2 = this.fill(0, n2, byArray, 4);
        }
        n2 = this.fill(0, n2, byArray, byArray.length - n2);
        long l2 = TarUtils.computeCheckSum(byArray);
        TarUtils.formatCheckSumOctalBytes(l2, byArray, n3, 8);
    }

    private int writeEntryHeaderField(long l2, byte[] byArray, int n2, int n3, boolean bl2) {
        if (!(bl2 || l2 >= 0L && l2 < 1L << 3 * (n3 - 1))) {
            return TarUtils.formatLongOctalBytes(0L, byArray, n2, n3);
        }
        return TarUtils.formatLongOctalOrBinaryBytes(l2, byArray, n2, n3);
    }

    private int writeEntryHeaderOptionalTimeField(FileTime fileTime, int n2, byte[] byArray, int n3) {
        n2 = fileTime != null ? this.writeEntryHeaderField(TimeUtils.toUnixTime(fileTime), byArray, n2, n3, true) : this.fill(0, n2, byArray, n3);
        return n2;
    }
}

