/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.jacoco.core.data;

import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.ExecutionData;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.ExecutionDataWriter;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.IExecutionDataVisitor;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.ISessionInfoVisitor;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.IncompatibleExecDataVersionException;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.SessionInfo;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.internal.data.CompactDataInput;
import java.io.IOException;
import java.io.InputStream;

public class ExecutionDataReader {
    protected final CompactDataInput in;
    private ISessionInfoVisitor sessionInfoVisitor = null;
    private IExecutionDataVisitor executionDataVisitor = null;
    private boolean firstBlock = true;

    public ExecutionDataReader(InputStream inputStream) {
        this.in = new CompactDataInput(inputStream);
    }

    public void setSessionInfoVisitor(ISessionInfoVisitor iSessionInfoVisitor) {
        this.sessionInfoVisitor = iSessionInfoVisitor;
    }

    public void setExecutionDataVisitor(IExecutionDataVisitor iExecutionDataVisitor) {
        this.executionDataVisitor = iExecutionDataVisitor;
    }

    public boolean read() throws IOException, IncompatibleExecDataVersionException {
        byte by2;
        do {
            int n2;
            if ((n2 = this.in.read()) == -1) {
                return false;
            }
            by2 = (byte)n2;
            if (this.firstBlock && by2 != 1) {
                throw new IOException("Invalid execution data file.");
            }
            this.firstBlock = false;
        } while (this.readBlock(by2));
        return true;
    }

    protected boolean readBlock(byte by2) throws IOException {
        switch (by2) {
            case 1: {
                this.readHeader();
                return true;
            }
            case 16: {
                this.readSessionInfo();
                return true;
            }
            case 17: {
                this.readExecutionData();
                return true;
            }
        }
        throw new IOException(String.format("Unknown block type %x.", by2));
    }

    private void readHeader() throws IOException {
        if (this.in.readChar() != '\uc0c0') {
            throw new IOException("Invalid execution data file.");
        }
        char c2 = this.in.readChar();
        if (c2 != ExecutionDataWriter.FORMAT_VERSION) {
            throw new IncompatibleExecDataVersionException(c2);
        }
    }

    private void readSessionInfo() throws IOException {
        if (this.sessionInfoVisitor == null) {
            throw new IOException("No session info visitor.");
        }
        String string = this.in.readUTF();
        long l2 = this.in.readLong();
        long l3 = this.in.readLong();
        this.sessionInfoVisitor.visitSessionInfo(new SessionInfo(string, l2, l3));
    }

    private void readExecutionData() throws IOException {
        if (this.executionDataVisitor == null) {
            throw new IOException("No execution data visitor.");
        }
        long l2 = this.in.readLong();
        String string = this.in.readUTF();
        boolean[] blArray = this.in.readBooleanArray();
        this.executionDataVisitor.visitClassExecution(new ExecutionData(l2, string, blArray));
    }
}

