/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractDirectorySensitiveFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.MissingRootAndDuplicateIgnoringFileSystemSnapshotVisitor;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class AbsolutePathFingerprintingStrategy
extends AbstractDirectorySensitiveFingerprintingStrategy {
    public static final FingerprintingStrategy DEFAULT = new AbsolutePathFingerprintingStrategy(DirectorySensitivity.DEFAULT);
    public static final FingerprintingStrategy IGNORE_DIRECTORIES = new AbsolutePathFingerprintingStrategy(DirectorySensitivity.IGNORE_DIRECTORIES);
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public AbsolutePathFingerprintingStrategy(DirectorySensitivity directorySensitivity, FileSystemLocationSnapshotHasher fileSystemLocationSnapshotHasher) {
        super("ABSOLUTE_PATH", directorySensitivity, fileSystemLocationSnapshotHasher);
        this.normalizedContentHasher = fileSystemLocationSnapshotHasher;
    }

    private AbsolutePathFingerprintingStrategy(DirectorySensitivity directorySensitivity) {
        this(directorySensitivity, FileSystemLocationSnapshotHasher.DEFAULT);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot fileSystemSnapshot) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        fileSystemSnapshot.accept(new MissingRootAndDuplicateIgnoringFileSystemSnapshotVisitor(){

            @Override
            public void visitAcceptedEntry(FileSystemLocationSnapshot fileSystemLocationSnapshot, boolean bl2) {
                HashCode hashCode;
                String string = fileSystemLocationSnapshot.getAbsolutePath();
                if (AbsolutePathFingerprintingStrategy.this.getDirectorySensitivity().shouldFingerprint(fileSystemLocationSnapshot) && (hashCode = AbsolutePathFingerprintingStrategy.this.getNormalizedContentHash(fileSystemLocationSnapshot, AbsolutePathFingerprintingStrategy.this.normalizedContentHasher)) != null) {
                    builder.put(string, new DefaultFileSystemLocationFingerprint(fileSystemLocationSnapshot.getAbsolutePath(), fileSystemLocationSnapshot.getType(), hashCode));
                }
            }
        });
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

