/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.base;

import com.gradle.c.b;
import com.gradle.enterprise.java.a;
import com.gradle.enterprise.testselection.common.model.api.base.ImmutableSelectTestsResponse;
import com.gradle.enterprise.testselection.common.model.api.base.NonSelectionReasonId;
import com.gradle.enterprise.testselection.common.model.api.base.PublicBuildId;
import com.gradle.enterprise.testselection.common.model.api.base.ResultType;
import com.gradle.enterprise.testselection.common.model.api.base.SelectionProfile;
import com.gradle.enterprise.testselection.common.model.api.base.SelectionReasonId;
import com.gradle.enterprise.testselection.common.model.api.base.TestClassAndTime;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableSelectTestsResponse.class)
@JsonDeserialize(as=ImmutableSelectTestsResponse.class)
@Value.Immutable
public interface SelectTestsResponse {
    public ResultType getResultType();

    @JsonDeserialize(keyUsing=SelectionReasonIdDeserializer.class)
    public Map<SelectionReasonId, Set<TestClassAndTime>> getSelectedTests();

    @JsonDeserialize(keyUsing=NonSelectionReasonIdDeserializer.class)
    public Map<NonSelectionReasonId, Set<TestClassAndTime>> getNotSelectedTests();

    @JsonDeserialize(keyUsing=SelectionReasonIdDeserializer.class)
    public Map<SelectionReasonId, String> getSelectionReasonDescriptions();

    @JsonDeserialize(keyUsing=NonSelectionReasonIdDeserializer.class)
    public Map<NonSelectionReasonId, String> getNonSelectionReasonDescriptions();

    @b
    public SelectionProfile getSelectionProfile();

    public List<List<PublicBuildId>> getBuildIdsForCoverage();

    public static SelectTestsResponse selectTests(Map<SelectionReasonId, Set<TestClassAndTime>> map, Map<NonSelectionReasonId, Set<TestClassAndTime>> map2, Map<SelectionReasonId, String> map3, Map<NonSelectionReasonId, String> map4, SelectionProfile selectionProfile, List<List<PublicBuildId>> list) {
        a.b(map3.keySet().containsAll(map.keySet()), () -> "All selection reasons must be present in the descriptions map, missing: " + Sets.difference(map.keySet(), map3.keySet()));
        a.b(map4.keySet().containsAll(map2.keySet()), () -> "All non-selection reasons must be present in the descriptions map, missing: " + Sets.difference(map2.keySet(), map4.keySet()));
        return ImmutableSelectTestsResponse.builder().resultType(ResultType.SELECT_TESTS).selectedTests(map).notSelectedTests(map2).selectionReasonDescriptions(map3).nonSelectionReasonDescriptions(map4).selectionProfile(selectionProfile).buildIdsForCoverage(list).build();
    }

    public static SelectTestsResponse withInsufficientData() {
        return ImmutableSelectTestsResponse.builder().resultType(ResultType.INSUFFICIENT_DATA).build();
    }

    public static SelectTestsResponse withProcessingLagging() {
        return ImmutableSelectTestsResponse.builder().resultType(ResultType.PROCESSING_LAGGING).build();
    }

    public static class NonSelectionReasonIdDeserializer
    extends KeyDeserializer {
        @Override
        public Object deserializeKey(String string, DeserializationContext deserializationContext) {
            return NonSelectionReasonId.of(Integer.parseInt(string));
        }
    }

    public static class SelectionReasonIdDeserializer
    extends KeyDeserializer {
        @Override
        public Object deserializeKey(String string, DeserializationContext deserializationContext) {
            return SelectionReasonId.of(Integer.parseInt(string));
        }
    }
}

