/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.ReplayingDecoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.TooLongFrameException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import java.util.List;

public class WebSocket00FrameDecoder
extends ReplayingDecoder<Void>
implements WebSocketFrameDecoder {
    private final long maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocket00FrameDecoder() {
        this(16384);
    }

    public WebSocket00FrameDecoder(int n2) {
        this.maxFrameSize = n2;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        byte by2 = byteBuf.readByte();
        WebSocketFrame webSocketFrame = (by2 & 0x80) == 128 ? this.decodeBinaryFrame(channelHandlerContext, by2, byteBuf) : this.decodeTextFrame(channelHandlerContext, byteBuf);
        if (webSocketFrame != null) {
            list.add(webSocketFrame);
        }
    }

    private WebSocketFrame decodeBinaryFrame(ChannelHandlerContext channelHandlerContext, byte by2, ByteBuf byteBuf) {
        byte by3;
        long l2 = 0L;
        int n2 = 0;
        do {
            by3 = byteBuf.readByte();
            l2 <<= 7;
            if ((l2 |= (long)(by3 & 0x7F)) > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            if (++n2 <= 8) continue;
            throw new TooLongFrameException();
        } while ((by3 & 0x80) == 128);
        if (by2 == -1 && l2 == 0L) {
            this.receivedClosingHandshake = true;
            return new CloseWebSocketFrame(true, 0, channelHandlerContext.alloc().buffer(0));
        }
        ByteBuf byteBuf2 = ByteBufUtil.readBytes(channelHandlerContext.alloc(), byteBuf, (int)l2);
        return new BinaryWebSocketFrame(byteBuf2);
    }

    private WebSocketFrame decodeTextFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n2;
        int n3 = byteBuf.readerIndex();
        int n4 = byteBuf.indexOf(n3, n3 + (n2 = this.actualReadableBytes()), (byte)-1);
        if (n4 == -1) {
            if ((long)n2 > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            return null;
        }
        int n5 = n4 - n3;
        if ((long)n5 > this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        ByteBuf byteBuf2 = ByteBufUtil.readBytes(channelHandlerContext.alloc(), byteBuf, n5);
        byteBuf.skipBytes(1);
        int n6 = byteBuf2.indexOf(byteBuf2.readerIndex(), byteBuf2.writerIndex(), (byte)-1);
        if (n6 >= 0) {
            byteBuf2.release();
            throw new IllegalArgumentException("a text frame should not contain 0xFF.");
        }
        return new TextWebSocketFrame(byteBuf2);
    }
}

