/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert;

import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Property {
    private static final Map<Property, Annotation[]> annotationCache = new ConcurrentReferenceHashMap<Property, Annotation[]>();
    private final Class<?> objectType;
    private final Method readMethod;
    private final Method writeMethod;
    private final String name;
    private final MethodParameter methodParameter;
    private Annotation[] annotations;

    public Property(Class<?> clazz, Method method, Method method2) {
        this(clazz, method, method2, null);
    }

    public Property(Class<?> clazz, Method method, Method method2, String string) {
        this.objectType = clazz;
        this.readMethod = method;
        this.writeMethod = method2;
        this.methodParameter = this.resolveMethodParameter();
        this.name = string != null ? string : this.resolveName();
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.methodParameter.getParameterType();
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    private String resolveName() {
        if (this.readMethod != null) {
            int n2 = this.readMethod.getName().indexOf("get");
            n2 = n2 != -1 ? (n2 += 3) : ((n2 = this.readMethod.getName().indexOf("is")) != -1 ? (n2 += 2) : 0);
            return StringUtils.uncapitalize(this.readMethod.getName().substring(n2));
        }
        if (this.writeMethod != null) {
            int n3 = this.writeMethod.getName().indexOf("set");
            if (n3 == -1) {
                throw new IllegalArgumentException("Not a setter method");
            }
            return StringUtils.uncapitalize(this.writeMethod.getName().substring(n3 += 3));
        }
        throw new IllegalStateException("Property is neither readable nor writeable");
    }

    private MethodParameter resolveMethodParameter() {
        MethodParameter methodParameter = this.resolveReadMethodParameter();
        MethodParameter methodParameter2 = this.resolveWriteMethodParameter();
        if (methodParameter2 == null) {
            if (methodParameter == null) {
                throw new IllegalStateException("Property is neither readable nor writeable");
            }
            return methodParameter;
        }
        if (methodParameter != null) {
            Class<?> clazz = methodParameter.getParameterType();
            Class<?> clazz2 = methodParameter2.getParameterType();
            if (!clazz2.equals(clazz) && clazz2.isAssignableFrom(clazz)) {
                return methodParameter;
            }
        }
        return methodParameter2;
    }

    private MethodParameter resolveReadMethodParameter() {
        if (this.getReadMethod() == null) {
            return null;
        }
        return new MethodParameter(this.getReadMethod(), -1).withContainingClass(this.getObjectType());
    }

    private MethodParameter resolveWriteMethodParameter() {
        if (this.getWriteMethod() == null) {
            return null;
        }
        return new MethodParameter(this.getWriteMethod(), 0).withContainingClass(this.getObjectType());
    }

    private Annotation[] resolveAnnotations() {
        Annotation[] annotationArray = annotationCache.get(this);
        if (annotationArray == null) {
            LinkedHashMap<Class<? extends Annotation>, Annotation> linkedHashMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
            this.addAnnotationsToMap(linkedHashMap, this.getReadMethod());
            this.addAnnotationsToMap(linkedHashMap, this.getWriteMethod());
            this.addAnnotationsToMap(linkedHashMap, this.getField());
            annotationArray = linkedHashMap.values().toArray(new Annotation[0]);
            annotationCache.put(this, annotationArray);
        }
        return annotationArray;
    }

    private void addAnnotationsToMap(Map<Class<? extends Annotation>, Annotation> map, AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            for (Annotation annotation : annotatedElement.getAnnotations()) {
                map.put(annotation.annotationType(), annotation);
            }
        }
    }

    private Field getField() {
        String string = this.getName();
        if (!StringUtils.hasLength(string)) {
            return null;
        }
        Field field = null;
        Class<?> clazz = this.declaringClass();
        if (clazz != null && (field = ReflectionUtils.findField(clazz, string)) == null && (field = ReflectionUtils.findField(clazz, StringUtils.uncapitalize(string))) == null) {
            field = ReflectionUtils.findField(clazz, StringUtils.capitalize(string));
        }
        return field;
    }

    private Class<?> declaringClass() {
        if (this.getReadMethod() != null) {
            return this.getReadMethod().getDeclaringClass();
        }
        if (this.getWriteMethod() != null) {
            return this.getWriteMethod().getDeclaringClass();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Property)) {
            return false;
        }
        Property property = (Property)object;
        return ObjectUtils.nullSafeEquals(this.objectType, property.objectType) && ObjectUtils.nullSafeEquals(this.name, property.name) && ObjectUtils.nullSafeEquals(this.readMethod, property.readMethod) && ObjectUtils.nullSafeEquals(this.writeMethod, property.writeMethod);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.objectType) * 31 + ObjectUtils.nullSafeHashCode(this.name);
    }
}

